/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpElement;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.openide.filesystems.FileObject;

public final class PhpEditorExtender {
    private static final EditorExtender EMPTY_EDITOR_EXTENDER = new EmptyEditorExtender();

    private PhpEditorExtender() {
    }

    public static EditorExtender forFileObject(FileObject fileObject) {
        PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObject);
        if (phpProject == null) {
            return EMPTY_EDITOR_EXTENDER;
        }
        EditorExtender editorExtender = (EditorExtender)phpProject.getLookup().lookup(EditorExtender.class);
        assert (editorExtender != null) : "Editor extender must be found for " + phpProject;
        return editorExtender;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyEditorExtender
    extends EditorExtender {
        private EmptyEditorExtender() {
        }

        public List<PhpElement> getElementsForCodeCompletion(FileObject fileObject) {
            return Collections.emptyList();
        }

        public PhpClass getClass(FileObject fileObject, String string) {
            return null;
        }
    }
}

