/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.dlight.util.Computable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TasksCachedProcessor<P, R>
implements Computable<P, R> {
    private final ConcurrentMap<P, Future<R>> cache = new ConcurrentHashMap<P, Future<R>>();
    private final Computable<P, R> computable;
    private final boolean removeOnCompletion;

    public TasksCachedProcessor(Computable<P, R> computable, boolean bl) {
        this.computable = computable;
        this.removeOnCompletion = bl;
    }

    public boolean isResultAvailable(P p) {
        Future future = (Future)this.cache.get(p);
        if (future == null) {
            return false;
        }
        return future.isDone() && !future.isCancelled();
    }

    @Override
    public R compute(final P p) throws InterruptedException {
        Object object;
        FutureTask futureTask;
        FutureTask futureTask2 = (FutureTask)this.cache.get(p);
        if (futureTask2 == null && (futureTask2 = (Future)this.cache.putIfAbsent(p, futureTask = new FutureTask(object = new Callable<R>(){

            @Override
            public R call() throws InterruptedException {
                return TasksCachedProcessor.this.computable.compute(p);
            }
        }))) == null) {
            futureTask2 = futureTask;
            futureTask.run();
        }
        try {
            object = futureTask2.get();
            return (R)object;
        }
        catch (Throwable throwable) {
            this.cache.remove(p, futureTask2);
            throw new CancellationException(throwable.getMessage());
        }
        finally {
            if (this.removeOnCompletion) {
                this.cache.remove(p, futureTask2);
            }
        }
    }

    public void remove(P p) {
        Future future = (Future)this.cache.get(p);
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        this.cache.remove(p);
    }

    public void resetCache() {
        this.cache.clear();
    }
}

