/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class WebAppFilterNode
extends FilterNode {
    private boolean isTopLevelNode = false;
    private FileObject file;

    WebAppFilterNode(Project project, Node node, File file) {
        this(project, node, file, true);
    }

    private WebAppFilterNode(Project project, Node node, File file, boolean bl) {
        super(node, (Children)(node.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new WebAppFilterChildren(project, node, file)));
        this.isTopLevelNode = bl;
        if (bl) {
            this.file = FileUtil.toFileObject((File)file);
        }
    }

    public String getDisplayName() {
        if (this.isTopLevelNode) {
            String string = NbBundle.getMessage(WebAppFilterNode.class, (String)"LBL_Web_Pages");
            try {
                string = this.file.getFileSystem().getStatus().annotateName(string, Collections.singleton(this.file));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
            return string;
        }
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.isTopLevelNode) {
            return this.getOriginal().getHtmlDisplayName();
        }
        try {
            FileSystem.Status status = this.file.getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                String string;
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string2 = NbBundle.getMessage(WebAppFilterNode.class, (String)"LBL_Web_Pages");
                if (!string2.equals(string = htmlStatus.annotateNameHtml(string2, Collections.singleton(this.file)))) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean bl) {
        return super.getActions(bl);
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        if (this.isTopLevelNode) {
            image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/web/webPagesBadge.png"), (int)8, (int)8);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        if (this.isTopLevelNode) {
            image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/web/webPagesBadge.png"), (int)8, (int)8);
        }
        return image;
    }

    static class WebAppFilterChildren
    extends FilterNode.Children {
        private File root;
        private Project project;

        WebAppFilterChildren(Project project, Node node, File file) {
            super(node);
            this.root = file;
            this.project = project;
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject != null) {
                if (!VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile())) {
                    return new Node[0];
                }
                WebAppFilterNode webAppFilterNode = new WebAppFilterNode(this.project, node, this.root, false);
                return new Node[]{webAppFilterNode};
            }
            Node node2 = node;
            return new Node[]{node2.cloneNode()};
        }
    }
}

