/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarFactory;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.netbeans.modules.j2ee.spi.ejbjar.support.EjbJarSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.ContainerCPModifierImpl;
import org.netbeans.modules.maven.j2ee.EMGSResolverImpl;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.J2EEPrerequisitesChecker;
import org.netbeans.modules.maven.j2ee.J2eeMavenSourcesImpl;
import org.netbeans.modules.maven.j2ee.J2eeRecoPrivTemplates;
import org.netbeans.modules.maven.j2ee.JPAStuffImpl;
import org.netbeans.modules.maven.j2ee.MavenPersistenceProviderSupplier;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbEntRefContainerImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.CopyOnSave;
import org.netbeans.modules.maven.j2ee.web.EntRefContainerImpl;
import org.netbeans.modules.maven.j2ee.web.WebEjbJarImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebReplaceTokenProvider;
import org.netbeans.spi.project.LookupProvider;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class J2eeLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        assert (project != null);
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new J2EEPrerequisitesChecker());
        instanceContent.add((Object)new J2eeRecoPrivTemplates(project));
        instanceContent.add((Object)new J2eeMavenSourcesImpl(project));
        instanceContent.add((Object)new ExecutionChecker(project));
        instanceContent.add((Object)new SessionContent());
        Provider provider = new Provider(project, instanceContent);
        instanceContent.add((Object)new POHImpl(project, provider));
        instanceContent.add((Object)new ContainerCPModifierImpl(project));
        return provider;
    }

    public static class Provider
    extends AbstractLookup
    implements PropertyChangeListener {
        private final Project project;
        private final InstanceContent content;
        private String lastType = "jar";
        private Object lastInstance = null;
        private CopyOnSave copyOnSave;
        private final WebReplaceTokenProvider replacer;
        private final EntRefContainerImpl webEnt;
        private final EjbEntRefContainerImpl ejbEnt;
        private final JPAStuffImpl jpa;
        private final EMGSResolverImpl resolver;
        private final MavenPersistenceProviderSupplier supplier;
        private EjbJarProvider webEjbJarProvider;
        private EjbJarsInProject ejbJarsInProject;

        public Provider(Project project, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.project = project;
            this.content = instanceContent;
            this.replacer = new WebReplaceTokenProvider(project);
            this.webEnt = new EntRefContainerImpl(project);
            this.ejbEnt = new EjbEntRefContainerImpl(project);
            this.jpa = new JPAStuffImpl(project);
            this.resolver = new EMGSResolverImpl();
            this.supplier = new MavenPersistenceProviderSupplier(project);
            this.checkJ2ee();
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.checkJ2ee();
            }
        }

        private void checkJ2ee() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            String string = nbMavenProject.getPackagingType();
            this.doCheckJ2ee(string);
        }

        public void hackModuleServerChange() {
            this.doCheckJ2ee(null);
            this.checkJ2ee();
        }

        private void doCheckJ2ee(String string) {
            if (string == null) {
                string = "jar";
            }
            if (this.copyOnSave != null && !"war".equals(string)) {
                try {
                    this.copyOnSave.cleanup();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    fileStateInvalidException.printStackTrace();
                }
                this.content.remove((Object)this.copyOnSave);
                this.copyOnSave = null;
            }
            if ("war".equals(string) && !this.lastType.equals(string)) {
                this.removeInstances();
                WebModuleProviderImpl webModuleProviderImpl = new WebModuleProviderImpl(this.project);
                this.lastInstance = webModuleProviderImpl;
                this.content.add(this.lastInstance);
                this.content.add((Object)this.replacer);
                this.content.add((Object)this.webEnt);
                this.content.add((Object)this.jpa);
                this.content.add((Object)this.resolver);
                this.content.add((Object)this.supplier);
                Profile profile = webModuleProviderImpl.getWebModuleImplementation().getJ2eeProfile();
                if (Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile)) {
                    WebEjbJarImpl webEjbJarImpl = new WebEjbJarImpl(webModuleProviderImpl.getWebModuleImplementation(), this.project);
                    EjbJar ejbJar = EjbJarFactory.createEjbJar((EjbJarImplementation2)webEjbJarImpl);
                    this.webEjbJarProvider = EjbJarSupport.createEjbJarProvider((Project)this.project, (EjbJar)ejbJar);
                    this.ejbJarsInProject = EjbJarSupport.createEjbJarsInProject((EjbJar)ejbJar);
                    this.content.add((Object)this.webEjbJarProvider);
                    this.content.add((Object)this.ejbJarsInProject);
                }
                this.copyOnSave = webModuleProviderImpl.getCopyOnSaveSupport();
                try {
                    this.copyOnSave.initialize();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    fileStateInvalidException.printStackTrace();
                }
                this.content.add((Object)this.copyOnSave);
            } else if ("ear".equals(string) && !this.lastType.equals(string)) {
                this.removeInstances();
                this.lastInstance = new EarModuleProviderImpl(this.project);
                this.content.add(this.lastInstance);
                this.content.add((Object)((EarModuleProviderImpl)((Object)this.lastInstance)).getEarImplementation());
            } else if ("ejb".equals(string) && !this.lastType.equals(string)) {
                this.removeInstances();
                this.lastInstance = new EjbModuleProviderImpl(this.project);
                this.content.add(this.lastInstance);
                this.content.add((Object)this.jpa);
                this.content.add((Object)this.ejbEnt);
                this.content.add((Object)this.resolver);
                this.content.add((Object)this.supplier);
            } else if (!(this.lastInstance == null || "war".equals(string) || "ejb".equals(string) || "ear".equals(string))) {
                this.removeInstances();
                this.lastInstance = null;
            }
            this.lastType = string;
        }

        private void removeInstances() {
            if (this.lastInstance != null) {
                if (this.lastInstance instanceof EarModuleProviderImpl) {
                    this.content.remove((Object)((EarModuleProviderImpl)((Object)this.lastInstance)).getEarImplementation());
                }
                this.content.remove(this.lastInstance);
            }
            this.content.remove((Object)this.replacer);
            this.content.remove((Object)this.webEnt);
            this.content.remove((Object)this.ejbEnt);
            this.content.remove((Object)this.jpa);
            this.content.remove((Object)this.resolver);
            this.content.remove((Object)this.supplier);
            if (this.webEjbJarProvider != null) {
                this.content.remove((Object)this.webEjbJarProvider);
                this.webEjbJarProvider = null;
            }
            if (this.ejbJarsInProject != null) {
                this.content.remove((Object)this.ejbJarsInProject);
                this.ejbJarsInProject = null;
            }
        }
    }
}

