/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RefactoringPanelContainer
extends TopComponent {
    private static RefactoringPanelContainer usages = null;
    private static RefactoringPanelContainer refactorings = null;
    private transient boolean isVisible = false;
    private JPopupMenu pop;
    private PopupListener listener;
    private CloseListener closeL;
    private boolean isRefactoring;
    private static Image REFACTORING_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/api/resources/refactoringpreview.png");
    private static Image USAGES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/refactoring/api/resources/findusages.png");

    private RefactoringPanelContainer() {
        this("", false);
    }

    private RefactoringPanelContainer(String string, boolean bl) {
        this.setName(string);
        this.setToolTipText(string);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(1, 1));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"ACSD_usagesPanel"));
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.listener = new PopupListener();
        this.closeL = new CloseListener();
        this.isRefactoring = bl;
        this.setFocusCycleRoot(true);
        JLabel jLabel = new JLabel(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_NoUsages"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setEnabled(false);
        this.add(jLabel, "Center");
        this.initActions();
    }

    void addPanel(JPanel jPanel) {
        RefactoringPanel.checkEventThread();
        if (this.getComponentCount() == 0) {
            this.add(jPanel, "Center");
        } else {
            Component component = this.getComponent(0);
            if (component instanceof JTabbedPane) {
                ((JTabbedPane)component).addTab(jPanel.getName(), null, jPanel, jPanel.getToolTipText());
                ((JTabbedPane)component).setSelectedComponent(jPanel);
                component.validate();
            } else if (component instanceof JLabel) {
                this.remove(component);
                this.add(jPanel, "Center");
            } else {
                this.remove(component);
                JTabbedPane jTabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
                jTabbedPane.addMouseListener((MouseListener)((Object)this.listener));
                jTabbedPane.addPropertyChangeListener(this.closeL);
                this.add(jTabbedPane, "Center");
                jTabbedPane.addTab(component.getName(), null, component, ((JPanel)component).getToolTipText());
                jTabbedPane.addTab(jPanel.getName(), null, jPanel, jPanel.getToolTipText());
                jTabbedPane.setSelectedComponent(jPanel);
                jTabbedPane.validate();
            }
        }
        if (!this.isVisible) {
            this.isVisible = true;
            this.open();
        }
        this.validate();
        this.requestActive();
    }

    protected void componentActivated() {
        super.componentActivated();
        RefactoringPanel refactoringPanel = this.getCurrentPanel();
        if (refactoringPanel != null) {
            ((JComponent)refactoringPanel).requestFocus();
        }
    }

    void removePanel(JPanel jPanel) {
        Component component;
        RefactoringPanel.checkEventThread();
        Component component2 = component = this.getComponentCount() > 0 ? this.getComponent(0) : null;
        if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            if (jPanel == null) {
                jPanel = (JPanel)jTabbedPane.getSelectedComponent();
            }
            jTabbedPane.remove(jPanel);
            if (jTabbedPane.getTabCount() == 1) {
                Component component3 = jTabbedPane.getComponentAt(0);
                jTabbedPane.removeMouseListener((MouseListener)((Object)this.listener));
                jTabbedPane.removePropertyChangeListener(this.closeL);
                this.remove(jTabbedPane);
                this.add(component3, "Center");
            }
        } else {
            if (component != null) {
                this.remove(component);
            }
            this.isVisible = false;
            this.close();
        }
        this.validate();
    }

    void closeAllButCurrent() {
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            Component component2 = jTabbedPane.getSelectedComponent();
            int n2 = jTabbedPane.getTabCount();
            Component[] componentArray = new Component[n2 - 1];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                Component component3 = jTabbedPane.getComponentAt(n);
                if (component3 == component2) continue;
                componentArray[n3++] = component3;
            }
            for (n = 0; n < componentArray.length; ++n) {
                ((RefactoringPanel)componentArray[n]).close();
            }
        }
    }

    public static synchronized RefactoringPanelContainer getUsagesComponent() {
        if (usages == null && (usages = (RefactoringPanelContainer)WindowManager.getDefault().findTopComponent("find-usages")) == null) {
            usages = RefactoringPanelContainer.createUsagesComponent();
        }
        return usages;
    }

    public static synchronized RefactoringPanelContainer getRefactoringComponent() {
        if (refactorings == null && (refactorings = (RefactoringPanelContainer)WindowManager.getDefault().findTopComponent("refactoring-preview")) == null) {
            refactorings = RefactoringPanelContainer.createRefactoringComponent();
        }
        return refactorings;
    }

    public static synchronized RefactoringPanelContainer createRefactoringComponent() {
        if (refactorings == null) {
            refactorings = new RefactoringPanelContainer(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_Refactoring"), true);
        }
        return refactorings;
    }

    public static synchronized RefactoringPanelContainer createUsagesComponent() {
        if (usages == null) {
            usages = new RefactoringPanelContainer(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_Usages"), false);
        }
        return usages;
    }

    protected void componentClosed() {
        this.isVisible = false;
        if (this.getComponentCount() == 0) {
            return;
        }
        Component component = this.getComponent(0);
        if (component instanceof JTabbedPane) {
            int n;
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            Component[] componentArray = new Component[jTabbedPane.getTabCount()];
            for (n = 0; n < componentArray.length; ++n) {
                componentArray[n] = jTabbedPane.getComponentAt(n);
            }
            for (n = 0; n < componentArray.length; ++n) {
                ((RefactoringPanel)componentArray[n]).close();
            }
        } else if (component instanceof RefactoringPanel) {
            ((RefactoringPanel)component).close();
        }
    }

    protected String preferredID() {
        return "RefactoringPanel";
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("jumpNext", new PrevNextAction(false));
        actionMap.put("jumpPrev", new PrevNextAction(true));
    }

    public RefactoringPanel getCurrentPanel() {
        if (this.getComponentCount() > 0) {
            Component component = this.getComponent(0);
            if (component instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                return (RefactoringPanel)jTabbedPane.getSelectedComponent();
            }
            if (component instanceof RefactoringPanel) {
                return (RefactoringPanel)component;
            }
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RefactoringPanelContainer.class.getName() + (this.isRefactoring ? ".refactoring-preview" : ".find-usages"));
    }

    public Image getIcon() {
        if (this.isRefactoring) {
            return REFACTORING_BADGE;
        }
        return USAGES_BADGE;
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_CloseAllButCurrent"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RefactoringPanelContainer.this.closeAllButCurrent();
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_CloseAll"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RefactoringPanelContainer.this.close();
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(RefactoringPanelContainer.class, (String)"LBL_CloseWindow"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RefactoringPanelContainer.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            RefactoringPanelContainer.this.pop.show((Component)((Object)RefactoringPanelContainer.this), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("close".equals(propertyChangeEvent.getPropertyName())) {
                RefactoringPanelContainer.this.removePanel((JPanel)propertyChangeEvent.getNewValue());
            }
        }
    }

    private final class PrevNextAction
    extends AbstractAction {
        private boolean prev;

        public PrevNextAction(boolean bl) {
            this.prev = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RefactoringPanel refactoringPanel = RefactoringPanelContainer.this.getCurrentPanel();
            if (refactoringPanel != null) {
                if (this.prev) {
                    refactoringPanel.selectPrevUsage();
                } else {
                    refactoringPanel.selectNextUsage();
                }
            }
        }
    }
}

