/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.refactoring.spi.impl.RefactoringContextActionsProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class RefactoringContextAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    private final Lookup context;

    public RefactoringContextAction() {
        this((Lookup)null);
    }

    public RefactoringContextAction(Lookup lookup) {
        this.context = lookup;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new RefactoringContextAction(lookup);
    }

    public JMenuItem getMenuPresenter() {
        return new InlineMenu(this.context, false);
    }

    public JMenuItem getPopupPresenter() {
        return new InlineMenu(this.context, true);
    }

    private static final class InlineMenu
    extends JMenuItem
    implements DynamicMenuContent {
        private static final JComponent[] EMPTY_CONTENT = new JComponent[0];
        private Lookup context;
        private final boolean popup;

        public InlineMenu(Lookup lookup, boolean bl) {
            this.context = lookup;
            this.popup = bl;
        }

        public JComponent[] getMenuPresenters() {
            return this.createMenuItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            JComponent[] jComponentArray2 = new JComponent[1];
            for (JComponent jComponent : jComponentArray) {
                if (!(jComponent instanceof Actions.MenuItem)) continue;
                jComponentArray2[0] = jComponent;
                ((Actions.MenuItem)jComponent).synchMenuPresenters(jComponentArray2);
            }
            return this.createMenuItems();
        }

        private JComponent[] createMenuItems() {
            RefactoringContextActionsProvider refactoringContextActionsProvider;
            this.resolveContext();
            MimePath mimePath = this.resolveMIMEType();
            RefactoringContextActionsProvider refactoringContextActionsProvider2 = refactoringContextActionsProvider = mimePath != null ? (RefactoringContextActionsProvider)MimeLookup.getLookup((MimePath)mimePath).lookup(RefactoringContextActionsProvider.class) : null;
            if (refactoringContextActionsProvider != null) {
                return refactoringContextActionsProvider.getMenuItems(this.popup);
            }
            return EMPTY_CONTENT;
        }

        private void resolveContext() {
            if (this.context == null) {
                this.context = Utilities.actionsGlobalContext();
            }
        }

        private MimePath resolveMIMEType() {
            MimePath mimePath = (MimePath)this.context.lookup(MimePath.class);
            if (mimePath != null) {
                return mimePath;
            }
            FileObject fileObject = (FileObject)this.context.lookup(FileObject.class);
            if (fileObject != null) {
                return MimePath.parse((String)fileObject.getMIMEType());
            }
            DataObject dataObject = (DataObject)this.context.lookup(DataObject.class);
            return dataObject == null ? null : MimePath.parse((String)dataObject.getPrimaryFile().getMIMEType());
        }
    }
}

