/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;

public final class ProgressSupport {
    private final List<ProgressListener> progressListenerList = new ArrayList<ProgressListener>();
    private int counter;
    private boolean deterministic;

    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.progressListenerList.add(progressListener);
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.progressListenerList.remove(progressListener);
    }

    public void fireProgressListenerStart(Object object, int n, int n2) {
        ProgressListener[] progressListenerArray;
        this.counter = -1;
        this.deterministic = n2 > 0;
        ProgressEvent progressEvent = new ProgressEvent(object, 1, n, n2);
        for (ProgressListener progressListener : progressListenerArray = this.getListenersCopy()) {
            try {
                progressListener.start(progressEvent);
            }
            catch (RuntimeException runtimeException) {
                this.log(runtimeException);
            }
        }
    }

    public void fireProgressListenerStart(int n, int n2) {
        this.fireProgressListenerStart(this, n, n2);
    }

    public void fireProgressListenerStep(Object object, int n) {
        ProgressListener[] progressListenerArray;
        if (this.deterministic) {
            if (n < 0) {
                this.deterministic = false;
            }
            this.counter = n;
        } else if (n > 0) {
            this.deterministic = true;
            this.counter = -1;
        } else {
            this.counter = n;
        }
        ProgressEvent progressEvent = new ProgressEvent(object, 2, 0, n);
        for (ProgressListener progressListener : progressListenerArray = this.getListenersCopy()) {
            try {
                progressListener.step(progressEvent);
            }
            catch (RuntimeException runtimeException) {
                this.log(runtimeException);
            }
        }
    }

    public void fireProgressListenerStep(Object object) {
        if (this.deterministic) {
            ++this.counter;
        }
        this.fireProgressListenerStep(object, this.counter);
    }

    public void fireProgressListenerStop(Object object) {
        ProgressListener[] progressListenerArray;
        ProgressEvent progressEvent = new ProgressEvent(object, 4);
        for (ProgressListener progressListener : progressListenerArray = this.getListenersCopy()) {
            try {
                progressListener.stop(progressEvent);
            }
            catch (RuntimeException runtimeException) {
                this.log(runtimeException);
            }
        }
    }

    public void fireProgressListenerStop() {
        this.fireProgressListenerStop(this);
    }

    private synchronized ProgressListener[] getListenersCopy() {
        return this.progressListenerList.toArray(new ProgressListener[this.progressListenerList.size()]);
    }

    private void log(Exception exception) {
        Logger.getLogger(ProgressSupport.class.getName()).log(Level.INFO, exception.getMessage(), exception);
    }
}

