/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RunSQLAction
extends SQLExecutionBaseAction
implements ActionProvider {
    private static final Logger LOGGER = Logger.getLogger(RunSQLAction.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/runsql.png";

    protected String getIconBase() {
        return ICON_PATH;
    }

    protected String getDisplayName(SQLExecution sQLExecution) {
        return NbBundle.getMessage(RunSQLAction.class, (String)"LBL_RunSqlAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunSQLAction.class);
    }

    protected void actionPerformed(SQLExecution sQLExecution) {
        DatabaseConnection databaseConnection;
        if (LOG) {
            LOGGER.log(Level.FINE, "actionPerformed for " + sQLExecution);
        }
        if ((databaseConnection = sQLExecution.getDatabaseConnection()) != null) {
            sQLExecution.execute();
        } else {
            databaseConnection = RunSQLAction.selectDatabaseConnection();
            if (databaseConnection != null) {
                LOGGER.finer("Set DatabaseConnection: " + databaseConnection);
                sQLExecution.setDatabaseConnection(databaseConnection);
                sQLExecution.execute();
            }
        }
    }

    public String[] getSupportedActions() {
        return new String[]{"run.single"};
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        Collection collection = lookup.lookupAll(DataObject.class);
        if (collection.isEmpty()) {
            return false;
        }
        for (DataObject dataObject : collection) {
            if (FileUtil.getMIMEType((FileObject)dataObject.getPrimaryFile()) == null || !FileUtil.getMIMEType((FileObject)dataObject.getPrimaryFile()).equals("text/x-sql")) continue;
            return true;
        }
        return false;
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        Lookup.Result result = lookup.lookup(new Lookup.Template(SQLExecution.class));
        if (!result.allInstances().isEmpty()) {
            SQLExecution sQLExecution = (SQLExecution)result.allInstances().iterator().next();
            LOGGER.finer("Using " + sQLExecution + " for executing " + string);
            this.actionPerformed(sQLExecution);
            return;
        }
        Collection collection = lookup.lookupAll(DataObject.class);
        if (collection.isEmpty()) {
            assert (false) : "Any DataObject must found in lookup for command " + string;
            return;
        }
        for (DataObject dataObject : collection) {
            DatabaseConnection databaseConnection;
            if (FileUtil.getMIMEType((FileObject)dataObject.getPrimaryFile()) == null || !FileUtil.getMIMEType((FileObject)dataObject.getPrimaryFile()).equals("text/x-sql")) continue;
            SQLExecuteCookie sQLExecuteCookie = (SQLExecuteCookie)dataObject.getCookie(SQLExecuteCookie.class);
            LOGGER.finer("Using SQLExecuteCookie: " + sQLExecuteCookie + " for executing " + string);
            if (sQLExecuteCookie != null && sQLExecuteCookie.getDatabaseConnection() == null) {
                databaseConnection = RunSQLAction.selectDatabaseConnection();
                LOGGER.finer("Attach DatabaseConnection: " + databaseConnection + " for executing " + string);
                sQLExecuteCookie.setDatabaseConnection(databaseConnection);
            }
            if ((databaseConnection = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null && databaseConnection.getOpenedPanes() == null) {
                LOGGER.finer("Opening " + dataObject + " in the editor.");
                databaseConnection.open();
            }
            if (sQLExecuteCookie == null) continue;
            sQLExecuteCookie.execute();
            return;
        }
    }
}

