/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.push.PushAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushOtherAction
extends ContextAction
implements ChangeListener {
    private final VCSContext context;
    private Repository repository = null;
    private JButton pushButton = null;
    private JButton cancelButton = null;

    public PushOtherAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        Object object;
        File[] fileArray = HgUtils.getActionRoots(this.context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = Mercurial.getInstance().getRepositoryRoot(fileArray[0]);
        if (this.repository == null) {
            int n = 100;
            object = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(n, (String)object, true);
            this.repository.addChangeListener(this);
        }
        this.pushButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.pushButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Push"));
        this.pushButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Push"));
        this.pushButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Push"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Cancel"));
        this.pushButton.setEnabled(false);
        Object object2 = this.repository.show(NbBundle.getMessage(PushOtherAction.class, (String)"CTL_PushDialog_Title"), new HelpCtx(PushOtherAction.class), new Object[]{this.pushButton, this.cancelButton}, true, "hg.push.dialog");
        if (object2 == this.pushButton) {
            try {
                object = this.repository.getUrl();
            }
            catch (URISyntaxException uRISyntaxException) {
                Mercurial.LOG.log(Level.SEVERE, this.getClass().getName() + ": Could not push because of invalid URI." + this.repository.getUrlString());
                Mercurial.LOG.log(Level.SEVERE, this.getClass().getName() + ": Invalid URI: " + this.repository.getUrlString());
                return;
            }
            PushOtherAction.push(this.context, file, (HgURL)object);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.pushButton.setEnabled(this.repository.isValid());
    }

    public static void push(VCSContext vCSContext, final File file, final HgURL hgURL) {
        if (file == null || hgURL == null) {
            return;
        }
        final String string = HgProjectUtils.getProjectName(file);
        final String string2 = NbBundle.getMessage(PushAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                PushAction.performPush(file, hgURL, string, string2, this.getLogger(), false);
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS"));
    }

    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(this.context) && set != null && set.size() != 0;
    }
}

