/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.kenai.HgKenaiSupport;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.ui.rollback.BackoutAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener,
DiffSetupSource {
    private static final String SUMMARY_DIFF_PROPERTY = "Summary-Diff-";
    private static final String SUMMARY_REVERT_PROPERTY = "Summary-Revert-";
    private static final String HLINK_ISSUE_PROPERTY = "Hyperlink-Issue-";
    private static final String SUMMARY_EXPORTDIFFS_PROPERTY = "Summary-ExportDiffs-";
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;
    private List<RepositoryRevision> results;
    private Map<String, VCSKenaiSupport.KenaiUser> kenaiUsersMap = null;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();

    public SummaryView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
        this.master = searchHistoryPanel;
        this.results = list;
        this.dispResults = this.expandResults(list);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.message = searchHistoryPanel.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        searchHistoryPanel.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
        if (list.size() > 0) {
            boolean bl;
            String string = HgUtils.getRemoteRepository(list.get(0).getRepositoryRoot());
            boolean bl2 = bl = string != null && HgKenaiSupport.getInstance().isKenai(string);
            if (bl) {
                this.kenaiUsersMap = new HashMap<String, VCSKenaiSupport.KenaiUser>();
                for (RepositoryRevision repositoryRevision : list) {
                    VCSKenaiSupport.KenaiUser kenaiUser;
                    String string2 = repositoryRevision.getLog().getAuthor();
                    if (string2 == null || string2.equals("") || this.kenaiUsersMap.keySet().contains(string2) || (kenaiUser = HgKenaiSupport.getInstance().forName(string2)) == null) continue;
                    this.kenaiUsersMap.put(string2, kenaiUser);
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private List expandResults(List<RepositoryRevision> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (RepositoryRevision repositoryRevision : list) {
            arrayList.add(repositoryRevision);
            List<RepositoryRevision.Event> list2 = repositoryRevision.getEvents();
            for (RepositoryRevision.Event event : list2) {
                arrayList.add(event);
            }
        }
        return arrayList;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.diffPrevious(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n)) != null && rectangle2.contains(point)) {
            this.revertModifications(new int[]{n});
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_EXPORTDIFFS_PROPERTY + n)) != null && rectangle2.contains(point)) {
            this.exportDiffs(n);
        }
        this.linkerSupport.mouseClicked(point, n);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.master.isIncomingSearch() && mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.master.isIncomingSearch() && mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsList.setToolTipText("");
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_DIFF_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_REVERT_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty(SUMMARY_EXPORTDIFFS_PROPERTY + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.linkerSupport.mouseMoved(point, (JComponent)this.resultsList, n);
    }

    @Override
    public Collection getSetups() {
        int[] nArray;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0) {
            return this.master.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray = this.resultsList.getSelectedIndices()) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        return this.master.getSetups(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void onPopup(MouseEvent mouseEvent) {
        this.onPopup(mouseEvent.getPoint());
    }

    private void onPopup(Point point) {
        boolean bl;
        RepositoryRevision.Event[] eventArray;
        boolean bl2;
        int[] nArray = this.resultsList.getSelectedIndices();
        if (nArray.length == 0) {
            int n = this.resultsList.locationToIndex(point);
            if (n == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(n);
            nArray = new int[]{n};
        }
        final int[] nArray2 = nArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = null;
        RepositoryRevision repositoryRevision = null;
        Object e = this.dispResults.get(nArray2[0]);
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        if (e instanceof RepositoryRevision) {
            bl2 = true;
            repositoryRevision = (RepositoryRevision)this.dispResults.get(nArray2[0]);
            eventArray = new RepositoryRevision.Event[]{};
            bl5 = true;
            bl3 = true;
        } else {
            bl2 = false;
            eventArray = new RepositoryRevision.Event[nArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                eventArray[i] = (RepositoryRevision.Event)this.dispResults.get(nArray2[i]);
                if (!bl4 && eventArray[i].getFile() == null) {
                    bl4 = true;
                }
                if (bl5 && i > 0 && eventArray[0].getLogInfoHeader().getLog().getRevision().equals(eventArray[i].getLogInfoHeader().getLog().getRevision())) {
                    bl5 = false;
                }
                if (eventArray[i].getFile() == null || !eventArray[i].getFile().exists() || eventArray[i].getChangedPath().getAction() != 'D') continue;
                bl3 = false;
            }
            repositoryRevision = eventArray[0].getLogInfoHeader();
        }
        long l = Long.parseLong(repositoryRevision.getLog().getRevision());
        final boolean bl6 = !bl4 && !bl2 && bl5;
        final boolean bl7 = !bl4 && bl5 && eventArray.length == 0;
        final boolean bl8 = nArray2.length == 1 && !bl2 && eventArray[0].getFile() != null && eventArray[0].getFile().exists() && !eventArray[0].getFile().isDirectory();
        boolean bl9 = bl = nArray2.length == 1;
        if (l > 0L) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)("" + string))){
                {
                    super(string);
                    this.setEnabled(bl);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        }
        if (bl2) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
                {
                    super(string);
                    this.setEnabled(bl7);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.backout(nArray2[0]);
                }
            }));
        } else {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)("" + l))){
                {
                    super(string);
                    this.setEnabled(bl6);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.revertModifications(nArray2);
                }
            }));
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View")){
                {
                    super(string);
                    this.setEnabled(bl8);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.this.view(nArray2[0]);
                        }
                    });
                }
            }));
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ExportFileDiff")){
                {
                    super(string);
                    this.setEnabled(bl8);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SummaryView.this.exportFileDiff(nArray2[0]);
                        }
                    });
                }
            }));
        }
        jPopupMenu.show(this.resultsList, point.x, point.y);
    }

    private void backout(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision) {
            RepositoryRevision repositoryRevision = (RepositoryRevision)e;
            BackoutAction.backout(repositoryRevision);
        }
    }

    static void backout(RepositoryRevision.Event event) {
        RepositoryRevision repositoryRevision = event.getLogInfoHeader();
        BackoutAction.backout(repositoryRevision);
    }

    static void revertModifications(RepositoryRevision.Event event) {
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        hashSet.add(event);
        SummaryView.revert(null, hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    public void revertModifications(int[] nArray) {
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (int n : nArray) {
            Object e = this.dispResults.get(n);
            if (e instanceof RepositoryRevision) {
                hashSet2.add((RepositoryRevision)e);
                continue;
            }
            hashSet.add((RepositoryRevision.Event)e);
        }
        SummaryView.revert(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    static void revert(final RepositoryRevision[] repositoryRevisionArray, final RepositoryRevision.Event[] eventArray) {
        File file;
        if (repositoryRevisionArray == null || repositoryRevisionArray.length == 0) {
            if (eventArray == null || eventArray.length == 0 || eventArray[0].getLogInfoHeader() == null) {
                return;
            }
            file = eventArray[0].getLogInfoHeader().getRepositoryRoot();
        } else {
            file = repositoryRevisionArray[0].getRepositoryRoot();
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                SummaryView.revertImpl(repositoryRevisionArray, eventArray, this);
            }
        };
        hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
    }

    /*
     * WARNING - void declaration
     */
    private static void revertImpl(RepositoryRevision[] repositoryRevisionArray, RepositoryRevision.Event[] eventArray, HgProgressSupport hgProgressSupport) {
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl = HgModuleConfig.getDefault().getBackupOnRevertModifications();
        if (repositoryRevisionArray != null) {
            for (RepositoryRevision repositoryRevision : repositoryRevisionArray) {
                File object22 = repositoryRevision.getRepositoryRoot();
                for (RepositoryRevision.Event event : repositoryRevision.getEvents()) {
                    if (event.getFile() == null) continue;
                    arrayList.add(event.getFile());
                }
                RevertModificationsAction.performRevert(object22, repositoryRevision.getLog().getRevision(), arrayList, bl, hgProgressSupport.getLogger());
                arrayList.clear();
            }
        }
        Object object4 = new HashMap();
        for (RepositoryRevision.Event event : eventArray) {
            void var11_23;
            List list;
            if (event.getFile() == null) continue;
            Iterator iterator = Mercurial.getInstance().getRepositoryRoot(event.getFile());
            if (object4 == null) {
                object4 = new HashMap();
            }
            if ((list = (List)object4.get(iterator)) == null) {
                ArrayList arrayList2 = new ArrayList();
                object4.put(iterator, arrayList2);
            }
            var11_23.add(event);
        }
        if (eventArray != null && eventArray.length > 0 && object4 != null && !object4.isEmpty()) {
            Set set = object4.keySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                File file = (File)iterator2.next();
                List list = (List)object4.get(file);
                for (RepositoryRevision.Event event : list) {
                    if (event.getFile() == null) continue;
                    arrayList.add(event.getFile());
                }
                if (list == null || list.isEmpty()) continue;
                RevertModificationsAction.performRevert(file, ((RepositoryRevision.Event)list.get(0)).getLogInfoHeader().getLog().getRevision(), arrayList, bl, hgProgressSupport.getLogger());
            }
        }
    }

    private void view(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            try {
                RepositoryRevision.Event event = (RepositoryRevision.Event)e;
                File file = VersionsCache.getInstance().getFileRevision(event.getFile(), event.getLogInfoHeader().getLog().getRevision());
                if (file == null) {
                    file = File.createTempFile("tmp", "-" + event.getFile().getName());
                    file.deleteOnExit();
                }
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                String string = event.getLogInfoHeader().getLog().getRevision();
                EditorCookie editorCookie = null;
                OpenCookie openCookie = null;
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Mercurial.LOG.log(Level.FINE, null, dataObjectNotFoundException);
                }
                if (editorCookie != null) {
                    Utils.openFile((FileObject)fileObject, (String)string);
                } else if (openCookie != null) {
                    openCookie.open();
                } else {
                    Utils.openFile((FileObject)fileObject, (String)string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void diffPrevious(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            this.master.showDiff(event);
        } else {
            RepositoryRevision repositoryRevision = (RepositoryRevision)e;
            this.master.showDiff(repositoryRevision);
        }
    }

    private void exportDiffs(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision) {
            RepositoryRevision repositoryRevision = (RepositoryRevision)e;
            ExportDiffAction.exportDiffRevision(repositoryRevision, this.master.getRoots());
        }
    }

    private void exportFileDiff(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof RepositoryRevision.Event) {
            RepositoryRevision.Event event = (RepositoryRevision.Event)e;
            ExportDiffAction.exportDiffFileRevision(event);
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String string, Color color, Color color2) {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (color.equals(UIManager.getColor("List.foreground"))) {
                stringBuilder.append("<html><a href=\"\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            } else {
                stringBuilder.append("<html><a href=\"\" style=\"color:");
                stringBuilder.append("rgb(");
                stringBuilder.append(color.getRed());
                stringBuilder.append(",");
                stringBuilder.append(color.getGreen());
                stringBuilder.append(",");
                stringBuilder.append(color.getBlue());
                stringBuilder.append(")");
                stringBuilder.append("\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            }
            this.setText(stringBuilder.toString());
            this.setBackground(color2);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private Style issueHyperlinkStyle;
        private final Style authorStyle;
        private Color selectionBackground;
        private Color selectionForeground;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel revertLink;
        private HyperlinkLabel exportDiffsLink;

        public SummaryCellRenderer() {
            this.selectionBackground = new JList().getSelectionBackground();
            this.selectionForeground = new JList().getSelectionForeground();
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, this.selectionForeground);
            StyleConstants.setBackground(this.selectedStyle, this.selectionBackground);
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.issueHyperlinkStyle = this.textPane.addStyle("issuehyperlink", this.normalStyle);
            StyleConstants.setForeground(this.issueHyperlinkStyle, Color.BLUE);
            StyleConstants.setUnderline(this.issueHyperlinkStyle, true);
            this.authorStyle = this.textPane.addStyle("author", this.normalStyle);
            StyleConstants.setForeground(this.authorStyle, Color.BLUE);
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (color != null) {
                StyleConstants.setBackground(this.hiliteStyle, color);
            }
            if ((color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, color);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPane.add(this.diffLink);
            this.revertLink = new HyperlinkLabel();
            this.revertLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPane.add(this.revertLink);
            this.exportDiffsLink = new HyperlinkLabel();
            this.actionsPane.add(this.exportDiffsLink);
            this.textPane.setBorder(null);
        }

        public Color darker(Color color) {
            return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RepositoryRevision) {
                this.renderContainer(jList, (RepositoryRevision)object, n, bl);
            } else {
                this.renderRevision(jList, (RepositoryRevision.Event)object, n, bl);
            }
            return this;
        }

        private void renderContainer(JList jList, RepositoryRevision repositoryRevision, int n, boolean bl) {
            Style style;
            Color color;
            Color color2;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                color2 = this.selectionForeground;
                color = this.selectionBackground;
                style = this.selectedStyle;
            } else {
                color2 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                color = this.darker(color);
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setBackground(color);
            this.index = n;
            Lookup.Result result = Lookup.getDefault().lookupResult(HyperlinkProvider.class);
            Collection collection = result.allInstances();
            try {
                int n2;
                Object object;
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
                styledDocument.insertString(0, repositoryRevision.getLog().getRevision() + " (" + repositoryRevision.getLog().getCSetShortID() + ")", null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR, style);
                String string = repositoryRevision.getLog().getAuthor();
                VCSHyperlinkSupport.Linker linker = SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, n);
                if (linker == null && SummaryView.this.kenaiUsersMap != null && string != null && !string.equals("") && (object = (VCSKenaiSupport.KenaiUser)SummaryView.this.kenaiUsersMap.get(string)) != null) {
                    linker = new VCSHyperlinkSupport.AuthorLinker((VCSKenaiSupport.KenaiUser)object, this.authorStyle, styledDocument, string);
                    SummaryView.this.linkerSupport.add(linker, n);
                }
                if (linker != null) {
                    linker.insertString(styledDocument, bl ? style : null);
                } else {
                    styledDocument.insertString(styledDocument.getLength(), string, style);
                }
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + this.defaultFormat.format(repositoryRevision.getLog().getDate()), null);
                object = repositoryRevision.getLog().getMessage();
                if (((String)object).endsWith("\n")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
                linker = SummaryView.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, n);
                if (linker == null) {
                    for (HyperlinkProvider hyperlinkProvider : collection) {
                        linker = VCSHyperlinkSupport.IssueLinker.create((HyperlinkProvider)hyperlinkProvider, (Style)this.issueHyperlinkStyle, (File)SummaryView.this.master.getRoots()[0], (StyledDocument)styledDocument, (String)object);
                        if (linker == null) continue;
                        SummaryView.this.linkerSupport.add(linker, n);
                        break;
                    }
                }
                if (linker != null) {
                    linker.insertString(styledDocument, style);
                } else {
                    styledDocument.insertString(styledDocument.getLength(), (String)object, style);
                }
                int n3 = ((String)object).length();
                int n4 = styledDocument.getLength();
                if (SummaryView.this.message != null && !bl && (n2 = ((String)object).indexOf(SummaryView.this.message)) != -1) {
                    styledDocument.setCharacterAttributes(n4 - n3 + n2, SummaryView.this.message.length(), this.hiliteStyle, true);
                }
                this.resizePane((String)object, jList.getFontMetrics(jList.getFont()));
                if (bl) {
                    styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            this.actionsPane.setVisible(true);
            if (!SummaryView.this.master.isIncomingSearch()) {
                this.diffLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Diff"), color2, color);
                this.revertLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_Revert"), color2, color);
                this.exportDiffsLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_ExportDiffs"), color2, color);
            }
        }

        private void renderRevision(JList jList, RepositoryRevision.Event event, int n, boolean bl) {
            Style style;
            Color color;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                Color color2 = this.selectionForeground;
                color = this.selectionBackground;
                style = this.selectedStyle;
            } else {
                Color color3 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setVisible(false);
            this.index = -1;
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.indentStyle, false);
                String string = String.valueOf(event.getChangedPath().getAction()).trim();
                styledDocument.insertString(styledDocument.getLength(), string, null);
                styledDocument.insertString(styledDocument.getLength(), (string.equals("") ? "" : FIELDS_SEPARATOR) + event.getChangedPath().getPath(), null);
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                this.resizePane(styledDocument.getText(0, styledDocument.getLength() - 1), jList.getFontMetrics(jList.getFont()));
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }

        private void resizePane(String string, FontMetrics fontMetrics) {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = SummaryView.this.master.getWidth()) > 0) {
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.textPane.getGraphics());
                int n2 = -1;
                int n3 = 0;
                while (n3 != -1) {
                    n3 = string.indexOf(10, n3 + 1);
                    ++n2;
                }
                int n4 = (int)(rectangle2D.getWidth() / (double)(n - 80) + 1.0);
                int n5 = fontMetrics.getHeight() * (n4 + ++n2) + 0;
                this.textPane.setPreferredSize(new Dimension(n - 50, n5));
            }
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.index == -1) {
                return;
            }
            Rectangle rectangle = this.actionsPane.getBounds();
            Rectangle rectangle2 = this.diffLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_DIFF_PROPERTY + this.index, rectangle2);
            rectangle2 = this.revertLink.getBounds();
            rectangle2.setBounds(rectangle2.x, rectangle2.y + rectangle.y, rectangle2.width, rectangle2.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_REVERT_PROPERTY + this.index, rectangle2);
            Rectangle rectangle3 = this.exportDiffsLink.getBounds();
            rectangle3.setBounds(rectangle3.x, rectangle3.y + rectangle.y, rectangle3.width, rectangle3.height);
            SummaryView.this.resultsList.putClientProperty(SummaryView.SUMMARY_EXPORTDIFFS_PROPERTY + this.index, rectangle3);
            SummaryView.this.linkerSupport.computeBounds(this.textPane, this.index);
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int n) {
            return SummaryView.this.dispResults.get(n);
        }
    }
}

