/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.netbeans.modules.mercurial.VersionsCache;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;

public abstract class FileEnvironment
implements CloneableEditorSupport.Env {
    private static final long serialVersionUID = 1L;
    private String mime = "text/plain";
    private final File peer;
    private final String revision;
    private transient Date modified;

    public FileEnvironment(File file, String string, String string2) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.peer = file;
        this.modified = new Date();
        this.revision = string;
        if (string2 != null) {
            this.mime = string2;
        }
    }

    public void markModified() throws IOException {
        throw new IOException("r/o");
    }

    public void unmarkModified() {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public boolean isModified() {
        return false;
    }

    public Date getTime() {
        return this.modified;
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    public boolean isValid() {
        return true;
    }

    public OutputStream outputStream() throws IOException {
        throw new IOException("r/o");
    }

    public String getMimeType() {
        return this.mime;
    }

    public InputStream inputStream() throws IOException {
        return new LazyInputStream();
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    private class LazyInputStream
    extends InputStream {
        private InputStream in;

        private InputStream peer() throws IOException {
            try {
                if (this.in == null) {
                    File file = VersionsCache.getInstance().getFileRevision(FileEnvironment.this.peer, FileEnvironment.this.revision);
                    this.in = new FileInputStream(file);
                }
                return this.in;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                IOException iOException2 = new IOException();
                errorManager.annotate((Throwable)iOException2, (Throwable)iOException);
                errorManager.annotate((Throwable)iOException2, 256, null, null, null, null);
                throw iOException2;
            }
        }

        public int available() throws IOException {
            return this.peer().available();
        }

        public void close() throws IOException {
            this.peer().close();
        }

        public void mark(int n) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            return this.peer().read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.peer().read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.peer().read(byArray, n, n2);
        }

        public void reset() throws IOException {
            this.peer().reset();
        }

        public long skip(long l) throws IOException {
            return this.peer().skip(l);
        }
    }
}

