/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.annotate;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationBar;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationBarManager;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateAction
extends ContextAction {
    private final VCSContext context;

    public AnnotateAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        if (!HgUtils.isFromHgRepository(this.context)) {
            return false;
        }
        Node[] nodeArray = this.context.getElements().lookupAll(Node.class).toArray(new Node[0]);
        if (this.context.getRootFiles().size() > 0 && this.activatedEditorCookie(nodeArray) != null) {
            File file;
            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
            FileInformation fileInformation = fileStatusCache.getCachedStatus(file = this.activatedFile(nodeArray));
            if (fileInformation != null) {
                int n = fileInformation.getStatus();
                return n != 4 && n != 2;
            }
            return true;
        }
        return false;
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        Node[] nodeArray = this.context.getElements().lookupAll(Node.class).toArray(new Node[0]);
        if (this.visible(nodeArray)) {
            JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
            AnnotationBarManager.hideAnnotationBar(jEditorPane);
        } else {
            EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
            if (editorCookie == null) {
                return;
            }
            final File file = this.activatedFile(nodeArray);
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null) {
                editorCookie.open();
            }
            if ((jEditorPaneArray = editorCookie.getOpenedPanes()) == null) {
                return;
            }
            JEditorPane jEditorPane = jEditorPaneArray[0];
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jEditorPane);
            topComponent.requestActive();
            final AnnotationBar annotationBar = AnnotationBarManager.showAnnotationBar(jEditorPane);
            annotationBar.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationSubstitute"));
            final File file2 = HgUtils.getRootFile(this.context);
            if (file2 == null) {
                return;
            }
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file2);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    outputLogger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_TITLE_SEP"));
                    AnnotateAction.this.computeAnnotations(file2, file, this, annotationBar);
                    outputLogger.output("\t" + file.getAbsolutePath());
                    outputLogger.outputInRed(NbBundle.getMessage(AnnotateAction.class, (String)"MSG_ANNOTATE_DONE"));
                }
            };
            hgProgressSupport.start(requestProcessor, file2, NbBundle.getMessage(AnnotateAction.class, (String)"MSG_Annotation_Progress"));
        }
    }

    private void computeAnnotations(File file, File file2, HgProgressSupport hgProgressSupport, AnnotationBar annotationBar) {
        HgLogMessage[] hgLogMessageArray;
        List<String> list = null;
        try {
            list = HgCommand.doAnnotate(file, file2, hgProgressSupport.getLogger());
        }
        catch (HgException hgException) {
            hgLogMessageArray = new NotifyDescriptor.Exception((Throwable)hgException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)hgLogMessageArray);
        }
        if (hgProgressSupport.isCanceled()) {
            annotationBar.setAnnotationMessage(NbBundle.getMessage(AnnotateAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        if (list == null) {
            return;
        }
        AnnotateLine[] annotateLineArray = AnnotateAction.toAnnotateLines(list);
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(file2);
        hgLogMessageArray = HgCommand.getLogMessagesNoFileInfo(file, hashSet, -1, hgProgressSupport.getLogger());
        if (hgProgressSupport.isCanceled()) {
            return;
        }
        if (hgLogMessageArray == null) {
            return;
        }
        AnnotateAction.fillCommitMessages(annotateLineArray, hgLogMessageArray);
        annotationBar.setLogs(hgLogMessageArray);
        annotationBar.annotationLines(file2, Arrays.asList(annotateLineArray));
    }

    private static void fillCommitMessages(AnnotateLine[] annotateLineArray, HgLogMessage[] hgLogMessageArray) {
        long l = Long.MAX_VALUE;
        for (int i = 0; i < annotateLineArray.length; ++i) {
            AnnotateLine annotateLine = annotateLineArray[i];
            if (annotateLine == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotateLineArray.length});
                continue;
            }
            for (int j = 0; j < hgLogMessageArray.length; ++j) {
                HgLogMessage hgLogMessage = hgLogMessageArray[j];
                if (hgLogMessage == null) {
                    Mercurial.LOG.log(Level.WARNING, "AnnotateAction: log {0} of {1} is null", new Object[]{j, hgLogMessageArray.length});
                    continue;
                }
                if (hgLogMessage.getRevisionAsLong() < l) {
                    l = hgLogMessage.getRevisionAsLong();
                }
                if (!annotateLine.getRevision().equals(hgLogMessage.getRevision())) continue;
                annotateLine.setDate(hgLogMessage.getDate());
                annotateLine.setId(hgLogMessage.getCSetShortID());
                annotateLine.setCommitMessage(hgLogMessage.getMessage());
            }
        }
        String string = Long.toString(l);
        for (int i = 0; i < annotateLineArray.length; ++i) {
            AnnotateLine annotateLine = annotateLineArray[i];
            if (annotateLine == null) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: annotation {0} of {1} is null", new Object[]{i, annotateLineArray.length});
                continue;
            }
            annotateLine.setCanBeRolledBack(!annotateLine.getRevision().equals(string));
        }
    }

    private static AnnotateLine[] toAnnotateLines(List<String> list) {
        ArrayList<AnnotateLine> arrayList = new ArrayList<AnnotateLine>();
        int n = 0;
        Pattern pattern = Pattern.compile("^\\s*(\\w+\\b)\\s+(\\d+)\\s+(\\b\\S*):\\s(.*)$");
        for (String string : list) {
            ++n;
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                Mercurial.LOG.log(Level.WARNING, "AnnotateAction: toAnnotateLines(): Failed when matching: {0}", new Object[]{string});
                continue;
            }
            AnnotateLine annotateLine = new AnnotateLine();
            annotateLine.setAuthor(matcher.group(1));
            annotateLine.setRevision(matcher.group(2));
            annotateLine.setFileName(matcher.group(3));
            annotateLine.setContent(matcher.group(4));
            annotateLine.setLineNum(n);
            arrayList.add(annotateLine);
        }
        return arrayList.toArray(new AnnotateLine[arrayList.size()]);
    }

    public boolean visible(Node[] nodeArray) {
        JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
        return AnnotationBarManager.annotationBarVisible(jEditorPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodeArray) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodeArray.length == 1) {
            Node node = nodeArray[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodeArray) {
        Node node;
        DataObject dataObject;
        if (nodeArray.length == 1 && (dataObject = (DataObject)(node = nodeArray[0]).getCookie(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }
}

