/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MergeMenu;
import org.netbeans.modules.mercurial.RecoverMenu;
import org.netbeans.modules.mercurial.ShareMenu;
import org.netbeans.modules.mercurial.ShowMenu;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.clone.CloneExternalAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.create.CreateAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffChangesAction;
import org.netbeans.modules.mercurial.ui.diff.ImportDiffAction;
import org.netbeans.modules.mercurial.ui.ignore.IgnoreAction;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.properties.PropertiesAction;
import org.netbeans.modules.mercurial.ui.pull.FetchAction;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.ui.update.ResolveConflictsAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialAnnotator
extends VCSAnnotator {
    private static final int INITIAL_ACTION_ARRAY_LENGTH = 25;
    private static MessageFormat uptodateFormat = MercurialAnnotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = MercurialAnnotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = MercurialAnnotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = MercurialAnnotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = MercurialAnnotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = MercurialAnnotator.getFormat("deletedLocallyFormat");
    private static MessageFormat excludedFormat = MercurialAnnotator.getFormat("excludedFormat");
    private static MessageFormat conflictFormat = MercurialAnnotator.getFormat("conflictFormat");
    private static MessageFormat newLocallyTooltipFormat = MercurialAnnotator.getFormat("newLocallyTooltipFormat");
    private static MessageFormat addedLocallyTooltipFormat = MercurialAnnotator.getFormat("addedLocallyTooltipFormat");
    private static MessageFormat modifiedLocallyTooltipFormat = MercurialAnnotator.getFormat("modifiedLocallyTooltipFormat");
    private static MessageFormat removedLocallyTooltipFormat = MercurialAnnotator.getFormat("removedLocallyTooltipFormat");
    private static MessageFormat deletedLocallyTooltipFormat = MercurialAnnotator.getFormat("deletedLocallyTooltipFormat");
    private static MessageFormat excludedTooltipFormat = MercurialAnnotator.getFormat("excludedTooltipFormat");
    private static MessageFormat conflictTooltipFormat = MercurialAnnotator.getFormat("conflictTooltipFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6494;
    private static final Pattern lessThan = Pattern.compile("<");
    private static final int STATUS_BADGEABLE = 28;
    private static int STATUS_IS_IMPORTANT = 6622;
    public static final String ANNOTATION_STATUS = "status";
    public static final String ANNOTATION_FOLDER = "folder";
    public static final String PROP_ICON_BADGE_CHANGED = "event.badgeChanged";
    public static String[] LABELS = new String[]{"status", "folder"};
    private FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private File folderToScan;
    private ConcurrentLinkedQueue<File> dirsToScan = new ConcurrentLinkedQueue();
    private Map<File, FileInformation> modifiedFiles = null;
    private RequestProcessor.Task scanTask;
    private final RequestProcessor.Task modifiedFilesRPScanTask;
    private final ModifiedFilesScanTask modifiedFilesScanTask;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private static final RequestProcessor rp = new RequestProcessor("MercurialAnnotateScan", 1, true);
    private static String badgeModified = "org/netbeans/modules/mercurial/resources/icons/modified-badge.png";
    private static String badgeConflicts = "org/netbeans/modules/mercurial/resources/icons/conflicts-badge.png";
    private static String toolTipModified = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource(badgeModified) + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Modified_Locally");
    private static String toolTipConflict = "<img src=\"" + MercurialAnnotator.class.getClassLoader().getResource(badgeConflicts) + "\">&nbsp;" + NbBundle.getMessage(MercurialAnnotator.class, (String)"MSG_Contains_Conflicts");
    private final WeakSet<Map<File, FileInformation>> allModifiedFiles = new WeakSet(1);

    public MercurialAnnotator() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.scanTask = rp.create((Runnable)new ScanTask());
        this.modifiedFilesScanTask = new ModifiedFilesScanTask();
        this.modifiedFilesRPScanTask = rp.create((Runnable)this.modifiedFilesScanTask);
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fieldArray = MercurialAnnotator.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.endsWith("Format")) continue;
            this.initDefaultColor(string.substring(0, string.length() - 6));
        }
        this.refresh();
    }

    public void refresh() {
        String string = HgModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            if (!HgUtils.isAnnotationFormatValid(string = HgUtils.createAnnotationFormat(string))) {
                Mercurial.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                string = NbBundle.getMessage(MercurialAnnotator.class, (String)"MercurialAnnotator.defaultFormat");
            }
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
    }

    private void initDefaultColor(String string) {
        String string2 = System.getProperty("hg.color." + string);
        if (string2 == null) {
            return;
        }
        this.setAnnotationColor(string, string2);
    }

    private void setAnnotationColor(String string, String string2) {
        try {
            Field field = MercurialAnnotator.class.getDeclaredField(string + "Format");
            MessageFormat messageFormat = new MessageFormat("<font color=\"" + string2 + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, messageFormat);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(MercurialAnnotator.class, (String)string);
        return new MessageFormat(string2);
    }

    public String annotateName(String string, VCSContext vCSContext) {
        FileInformation fileInformation = null;
        File file = null;
        boolean bl = false;
        for (File file2 : vCSContext.getRootFiles()) {
            int n;
            FileInformation fileInformation2 = this.cache.getCachedStatus(file2);
            if (fileInformation2 == null) {
                File file3 = file2.getParentFile();
                Mercurial.LOG.log(Level.FINE, "null cached status for: {0} {1} {2}", new Object[]{file2, this.folderToScan, file3});
                if (!Mercurial.getInstance().isRefreshScheduled(file3).booleanValue()) {
                    this.folderToScan = file3;
                    this.reScheduleScan(1000);
                }
                fileInformation2 = new FileInformation(8, false);
            }
            if (((n = fileInformation2.getStatus()) & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
            file = file2;
            bl = file2.isDirectory();
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.isFromMultiFileDataObject((VCSContext)vCSContext);
        }
        if (fileInformation == null) {
            return null;
        }
        return bl ? this.annotateFolderNameHtml(string, vCSContext, fileInformation, file) : this.annotateNameHtml(string, fileInformation, file);
    }

    public Image annotateIcon(Image image, VCSContext vCSContext) {
        boolean bl = false;
        for (File file : vCSContext.getRootFiles()) {
            if (!file.isDirectory()) continue;
            bl = true;
            Utils.addFolderToLog((File)file);
            break;
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !Utils.isFromMultiFileDataObject((VCSContext)vCSContext);
        }
        if (!bl) {
            return this.annotateFileIcon(vCSContext, image);
        }
        return this.annotateFolderIcon(vCSContext, image);
    }

    private Image annotateFileIcon(VCSContext vCSContext, Image image) throws IllegalArgumentException {
        FileInformation fileInformation = null;
        for (File file : vCSContext.getRootFiles()) {
            int n;
            FileInformation fileInformation2 = this.cache.getCachedStatus(file);
            if (fileInformation2 == null) {
                File file2 = file.getParentFile();
                Mercurial.LOG.log(Level.FINE, "null cached status for: {0} {1} {2}", new Object[]{file, this.folderToScan, file2});
                if (!Mercurial.getInstance().isRefreshScheduled(file2).booleanValue()) {
                    this.folderToScan = file2;
                    this.reScheduleScan(1000);
                }
                fileInformation2 = new FileInformation(8, false);
            }
            if (((n = fileInformation2.getStatus()) & STATUS_IS_IMPORTANT) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
        }
        if (fileInformation == null) {
            return null;
        }
        Object object = null;
        int n = fileInformation.getStatus();
        if (0 != (n & 2)) {
            object = excludedTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 0x800)) {
            object = deletedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 0x100)) {
            object = removedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 4)) {
            object = newLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 0x1000)) {
            object = addedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 0x10)) {
            object = modifiedLocallyTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 8)) {
            object = null;
        } else if (0 != (n & 0x40)) {
            object = conflictTooltipFormat.format(new Object[]{fileInformation.getStatusText()});
        } else if (0 != (n & 1)) {
            object = null;
        } else if (n == 0) {
            object = null;
        } else {
            throw new IllegalArgumentException("Uncomparable status: " + n);
        }
        return object != null ? ImageUtilities.addToolTipToImage((Image)image, (String)object) : null;
    }

    private Image annotateFolderIcon(VCSContext vCSContext, Image image) {
        Object object;
        boolean bl = false;
        for (File file : vCSContext.getRootFiles()) {
            FileInformation fileInformation = this.cache.getCachedStatus(file);
            if (fileInformation == null || (fileInformation.getStatus() & 0x1C) == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        if (!"false".equals(System.getProperty("mercurial.newGenerationCache", "true"))) {
            object = null;
            if (this.cache.containsFileOfStatus(vCSContext, 64, true, true)) {
                object = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
            } else if (this.cache.containsFileOfStatus(vCSContext, 6612, true, true)) {
                object = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
            }
            if (object != null) {
                return ImageUtilities.mergeImages((Image)image, (Image)object, (int)16, (int)9);
            }
            return image;
        }
        object = new IconSelector(vCSContext.getRootFiles(), image);
        ((IconSelector)object).scanFilesLazy();
        return ((IconSelector)object).getBadge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, FileInformation> getLocallyChangedFiles(boolean[] blArray) {
        Map<File, FileInformation> map = blArray != null ? this.cache.getAllModifiedFilesCached(blArray) : this.cache.getAllModifiedFiles();
        Map map2 = null;
        WeakSet<Map<File, FileInformation>> weakSet = this.allModifiedFiles;
        synchronized (weakSet) {
            Iterator<File> iterator = this.allModifiedFiles.iterator();
            if (iterator.hasNext()) {
                Map object;
                map2 = object = (Map)iterator.next();
            }
            if (this.modifiedFiles == null || map != map2) {
                this.allModifiedFiles.clear();
                this.allModifiedFiles.add(map);
                this.modifiedFiles = new HashMap<File, FileInformation>();
                for (File file : map.keySet()) {
                    FileInformation fileInformation = map.get(file);
                    if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
                    this.modifiedFiles.put(file, fileInformation);
                }
            }
            return this.modifiedFiles;
        }
    }

    public Action[] getActions(VCSContext vCSContext, VCSAnnotator.ActionDestination actionDestination) {
        ResourceBundle resourceBundle = NbBundle.getBundle(MercurialAnnotator.class);
        Node[] nodeArray = vCSContext.getElements().lookupAll(Node.class).toArray(new Node[0]);
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        Set<File> set = HgUtils.getRepositoryRoots(vCSContext);
        boolean bl = set == null || set.size() == 0;
        boolean bl2 = this.onlyFolders(fileArray);
        boolean bl3 = MercurialAnnotator.onlyProjects(nodeArray);
        ArrayList<Object> arrayList = new ArrayList<Object>(25);
        if (actionDestination == VCSAnnotator.ActionDestination.MainMenu) {
            Object object;
            arrayList.add(new CreateAction(resourceBundle.getString("CTL_MenuItem_Create"), vCSContext));
            arrayList.add(null);
            arrayList.add(new StatusAction(resourceBundle.getString("CTL_PopupMenuItem_Status"), vCSContext));
            arrayList.add(new DiffAction(resourceBundle.getString("CTL_PopupMenuItem_Diff"), vCSContext));
            arrayList.add(new UpdateAction(resourceBundle.getString("CTL_PopupMenuItem_Update"), vCSContext));
            arrayList.add(new CommitAction(resourceBundle.getString("CTL_PopupMenuItem_Commit"), vCSContext));
            arrayList.add(null);
            arrayList.add(new ExportDiffAction(resourceBundle.getString("CTL_PopupMenuItem_ExportDiff"), vCSContext));
            arrayList.add(new ExportDiffChangesAction(resourceBundle.getString("CTL_PopupMenuItem_ExportDiffChanges"), vCSContext));
            arrayList.add(new ImportDiffAction(resourceBundle.getString("CTL_PopupMenuItem_ImportDiff"), vCSContext));
            arrayList.add(null);
            if (!bl) {
                object = set.size() == 1 ? NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_CloneLocal", (Object)set.iterator().next().getName()) : NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_CloneRepository");
                arrayList.add(new CloneAction((String)object, vCSContext));
            }
            arrayList.add(new CloneExternalAction(resourceBundle.getString("CTL_PopupMenuItem_CloneOther"), vCSContext));
            arrayList.add(new FetchAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_FetchLocal"), vCSContext));
            arrayList.add(new ShareMenu(vCSContext));
            arrayList.add(new MergeMenu(vCSContext, false));
            arrayList.add(null);
            arrayList.add(new LogAction(resourceBundle.getString("CTL_PopupMenuItem_Log"), vCSContext));
            if (!bl3 && !bl2) {
                object = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations"), vCSContext);
                if (((AnnotateAction)object).visible(nodeArray)) {
                    arrayList.add(new ShowMenu(vCSContext, true, true));
                } else {
                    arrayList.add(new ShowMenu(vCSContext, true, false));
                }
            } else {
                arrayList.add(new ShowMenu(vCSContext, false, false));
            }
            arrayList.add(null);
            arrayList.add(new RevertModificationsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Revert"), vCSContext));
            arrayList.add(new RecoverMenu(vCSContext));
            if (!bl3 && !bl2) {
                object = new IgnoreAction(resourceBundle.getString("CTL_PopupMenuItem_Ignore"), vCSContext);
                arrayList.add(object);
            }
            arrayList.add(null);
            arrayList.add(new PropertiesAction(resourceBundle.getString("CTL_PopupMenuItem_Properties"), vCSContext));
        } else if (bl) {
            arrayList.add(new CreateAction(resourceBundle.getString("CTL_PopupMenuItem_Create"), vCSContext));
        } else {
            ContextAction contextAction;
            arrayList.add(new StatusAction(resourceBundle.getString("CTL_PopupMenuItem_Status"), vCSContext));
            arrayList.add(new DiffAction(resourceBundle.getString("CTL_PopupMenuItem_Diff"), vCSContext));
            arrayList.add(new CommitAction(resourceBundle.getString("CTL_PopupMenuItem_Commit"), vCSContext));
            arrayList.add(null);
            arrayList.add(new ResolveConflictsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Resolve"), vCSContext));
            if (!bl3 && !bl2) {
                arrayList.add(new ConflictResolvedAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_MarkResolved"), vCSContext));
            }
            arrayList.add(null);
            if (!bl3 && !bl2) {
                contextAction = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations"), vCSContext);
                if (contextAction.visible(nodeArray)) {
                    contextAction = new AnnotateAction(resourceBundle.getString("CTL_PopupMenuItem_HideAnnotations"), vCSContext);
                }
                arrayList.add(contextAction);
            }
            arrayList.add(new LogAction(resourceBundle.getString("CTL_PopupMenuItem_Log"), vCSContext));
            arrayList.add(null);
            arrayList.add(new RevertModificationsAction(NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_PopupMenuItem_Revert"), vCSContext));
            if (!bl3 && !bl2) {
                contextAction = new IgnoreAction(resourceBundle.getString("CTL_PopupMenuItem_Ignore"), vCSContext);
                arrayList.add(contextAction);
            }
            arrayList.add(null);
            arrayList.add(new PropertiesAction(resourceBundle.getString("CTL_PopupMenuItem_Properties"), vCSContext));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private String formatAnnotation(FileInformation fileInformation, File file) {
        Object[] objectArray;
        String string;
        String string2;
        String string3 = "";
        int n = fileInformation.getStatus();
        if (n != 8) {
            string3 = fileInformation.getShortStatusText();
        }
        if ((string2 = null) == null) {
            string2 = "";
        }
        if ((string = this.format.format(objectArray = new Object[]{string3, string2}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + string;
    }

    public String annotateNameHtml(File file, FileInformation fileInformation) {
        return this.annotateNameHtml(file.getName(), fileInformation, file);
    }

    public String annotateNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        boolean bl = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        int n = fileInformation.getStatus();
        if (bl && file != null && (n & 0x195E) != 0) {
            if (this.format != null) {
                string2 = this.formatAnnotation(fileInformation, file);
            } else {
                String string3;
                String string4 = null;
                string2 = n == 8 && string4 == null ? "" : (n == 8 ? " [" + string4 + "]" : (string4 == null ? (!(string3 = fileInformation.getShortStatusText()).equals("") ? " [" + fileInformation.getShortStatusText() + "]" : "") : " [" + fileInformation.getShortStatusText() + "; " + string4 + "]"));
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(MercurialAnnotator.class, (String)"textAnnotation", (Object)string2);
        }
        if (0 != (n & 2)) {
            return excludedFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x800)) {
            return deletedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x100)) {
            return removedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 4)) {
            return newLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x1000)) {
            return addedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x10)) {
            return modifiedLocallyFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 8)) {
            return uptodateFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 0x40)) {
            return conflictFormat.format(new Object[]{string, string2});
        }
        if (0 != (n & 1)) {
            return string;
        }
        if (n == 0) {
            return string;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    private String htmlEncode(String string) {
        if (string.indexOf(60) == -1) {
            return string;
        }
        return lessThan.matcher(string).replaceAll("&lt;");
    }

    private String annotateFolderNameHtml(String string, VCSContext vCSContext, FileInformation fileInformation, File file) {
        String string2 = this.htmlEncode(string);
        if (fileInformation.getStatus() == 2) {
            return excludedFormat.format(new Object[]{string2, ""});
        }
        String string3 = file.getName();
        if (string3.equals(string)) {
            return uptodateFormat.format(new Object[]{string2, ""});
        }
        Set set = vCSContext.getRootFiles();
        File file2 = null;
        String string4 = null;
        if (set.size() == 1) {
            File file3 = null;
            for (File file4 : set) {
                file2 = Mercurial.getInstance().getRepositoryRoot(file4);
                if (file2 == null) {
                    Mercurial.LOG.warning("Couldn't find repository root for file " + file4);
                    continue;
                }
                file3 = file4;
                break;
            }
            if (file2 == null || !file2.getAbsolutePath().equals(file3.getAbsolutePath())) {
                return uptodateFormat.format(new Object[]{string2, ""});
            }
        } else {
            File file5 = null;
            for (File file6 : set) {
                if (file5 == null) {
                    file5 = file6.getParentFile();
                    continue;
                }
                File file7 = file6.getParentFile();
                if (file7 != null && file5.getAbsolutePath().equals(file7.getAbsolutePath())) continue;
                return uptodateFormat.format(new Object[]{string2, ""});
            }
            for (File file6 : set) {
                file2 = Mercurial.getInstance().getRepositoryRoot(file6);
                if (file2 == null) {
                    Mercurial.LOG.warning("Couldn't find repository root for file " + file6);
                    continue;
                }
                if (file2.getAbsolutePath().equals(file5.getAbsolutePath())) break;
                return uptodateFormat.format(new Object[]{string2, ""});
            }
        }
        if (file2 != null && !file2.getName().equals(string)) {
            string4 = file2.getName();
        }
        return uptodateFormat.format(new Object[]{string2, string4 != null ? " [" + string4 + "]" : ""});
    }

    private boolean isMoreImportant(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation2 == null) {
            return true;
        }
        if (fileInformation == null) {
            return false;
        }
        return MercurialAnnotator.getComparableStatus(fileInformation.getStatus()) < MercurialAnnotator.getComparableStatus(fileInformation2.getStatus());
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private static boolean onlyProjects(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (Node node : nodeArray) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private boolean onlyFolders(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            FileInformation fileInformation = this.cache.getCachedStatus(fileArray[i]);
            if (fileInformation != null && (fileArray[i].exists() || fileInformation.isDirectory())) continue;
            return false;
        }
        return true;
    }

    private void reScheduleScan(int n) {
        if (!this.dirsToScan.contains(this.folderToScan) && !this.dirsToScan.offer(this.folderToScan)) {
            Mercurial.LOG.log(Level.FINE, "reScheduleScan failed to add to dirsToScan queue: {0} ", this.folderToScan);
        }
        this.scanTask.schedule(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IconSelector {
        private Set<File> rootFiles;
        private final Image initialIcon;
        private Image badge = null;
        private String badgePath;
        private String originalBadgePath;
        private final Set<File> responsibleFiles;
        boolean allExcluded;
        boolean modified;

        public IconSelector(Set<File> set, Image image) {
            this.rootFiles = set;
            this.initialIcon = image;
            this.responsibleFiles = new HashSet<File>();
        }

        void scanFilesLazy() {
            boolean[] blArray = new boolean[1];
            Map map = MercurialAnnotator.this.getLocallyChangedFiles(blArray);
            this.scanFiles(map);
            if (blArray[0]) {
                this.scheduleDeepScan();
            }
        }

        private void scanFiles(Map<File, FileInformation> map) {
            this.allExcluded = true;
            this.modified = false;
            HgModuleConfig hgModuleConfig = HgModuleConfig.getDefault();
            this.responsibleFiles.clear();
            for (File file : this.rootFiles) {
                for (Map.Entry<File, FileInformation> entry : map.entrySet()) {
                    File file2 = entry.getKey();
                    FileInformation fileInformation = entry.getValue();
                    int n = fileInformation.getStatus();
                    if (!(VersioningSupport.isFlat((File)file) ? file2.getParentFile().equals(file) && !fileInformation.isDirectory() && this.checkConflictAndUpdateFlags(file2, hgModuleConfig, n) : Utils.isAncestorOrEqual((File)file, (File)file2) && (n != 4 && n != 4096 || !file.equals(file2)) && this.checkConflictAndUpdateFlags(file2, hgModuleConfig, n))) continue;
                    return;
                }
            }
            if (this.modified && !this.allExcluded) {
                this.badgePath = badgeModified;
                this.badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)this.badgePath, (boolean)true), (String)toolTipModified);
                this.badge = ImageUtilities.mergeImages((Image)this.initialIcon, (Image)this.badge, (int)16, (int)9);
            } else {
                this.badge = null;
                this.badgePath = "";
                this.responsibleFiles.addAll(this.rootFiles);
            }
        }

        private boolean checkConflictAndUpdateFlags(File file, HgModuleConfig hgModuleConfig, int n) {
            this.responsibleFiles.add(file);
            if (n == 64) {
                this.badgePath = badgeConflicts;
                this.badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)this.badgePath, (boolean)true), (String)toolTipConflict);
                this.badge = ImageUtilities.mergeImages((Image)this.initialIcon, (Image)this.badge, (int)16, (int)9);
                return true;
            }
            this.modified = true;
            this.allExcluded = this.allExcluded && hgModuleConfig.isExcludedFromCommit(file.getAbsolutePath());
            return false;
        }

        Image getBadge() {
            return this.badge;
        }

        private void scheduleDeepScan() {
            this.originalBadgePath = this.badgePath;
            MercurialAnnotator.this.modifiedFilesScanTask.schedule(this);
        }

        public Set<File> getFilesToRefresh() {
            assert (this.originalBadgePath != null);
            if (!this.badgePath.equals(this.originalBadgePath)) {
                return this.responsibleFiles;
            }
            return Collections.EMPTY_SET;
        }
    }

    private class ModifiedFilesScanTask
    implements Runnable {
        private final LinkedList<IconSelector> scanners = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList<IconSelector> linkedList;
            Object object = this.scanners;
            synchronized (object) {
                linkedList = new LinkedList<IconSelector>(this.scanners);
                this.scanners.clear();
            }
            object = MercurialAnnotator.this.getLocallyChangedFiles(null);
            HashSet<File> hashSet = new HashSet<File>();
            for (IconSelector iconSelector : linkedList) {
                iconSelector.scanFiles((Map)object);
                hashSet.addAll(iconSelector.getFilesToRefresh());
            }
            if (hashSet.size() > 0) {
                MercurialAnnotator.this.support.firePropertyChange(MercurialAnnotator.PROP_ICON_BADGE_CHANGED, null, hashSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(IconSelector iconSelector) {
            LinkedList<IconSelector> linkedList = this.scanners;
            synchronized (linkedList) {
                this.scanners.add(iconSelector);
                MercurialAnnotator.this.modifiedFilesRPScanTask.schedule(1000);
            }
        }
    }

    private class ScanTask
    implements Runnable {
        private ScanTask() {
        }

        public void run() {
            Thread.interrupted();
            File file = (File)MercurialAnnotator.this.dirsToScan.poll();
            if (file != null) {
                MercurialAnnotator.this.cache.getScannedFiles(file, null);
                file = (File)MercurialAnnotator.this.dirsToScan.peek();
                if (file != null) {
                    MercurialAnnotator.this.scanTask.schedule(1000);
                }
            }
        }
    }
}

