/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.FileStatusCacheNewGeneration;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialInterceptor;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.kenai.HgKenaiSupport;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mercurial {
    public static final int HG_FETCH_20_REVISIONS = 20;
    public static final int HG_FETCH_50_REVISIONS = 50;
    public static final int HG_FETCH_ALL_REVISIONS = -1;
    public static final int HG_NUMBER_FETCH_OPTIONS = 3;
    public static final int HG_NUMBER_TO_FETCH_DEFAULT = 7;
    public static final int HG_MAX_REVISION_COMBO_SIZE = 10;
    public static final String MERCURIAL_OUTPUT_TAB_TITLE = NbBundle.getMessage(Mercurial.class, (String)"CTL_Mercurial_DisplayName");
    public static final String CHANGESET_STR = "changeset:";
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    public static final String PROP_CHANGESET_CHANGED = "changesetChanged";
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial");
    public static final Logger STATUS_LOG = Logger.getLogger("org.netbeans.modules.mercurial.status");
    private static final int STATUS_DIFFABLE = 1272;
    private static final String MERCURIAL_SUPPORTED_VERSION_093 = "0.9.3";
    private static final String MERCURIAL_SUPPORTED_VERSION_094 = "0.9.4";
    private static final String MERCURIAL_SUPPORTED_VERSION_095 = "0.9.5";
    private static final String MERCURIAL_SUPPORTED_VERSION_100 = "1.0";
    private static Mercurial instance;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final MercurialVCS mvcs;
    private MercurialAnnotator mercurialAnnotator;
    private MercurialInterceptor mercurialInterceptor;
    private FileStatusCache fileStatusCache;
    private HashMap<HgURL, RequestProcessor> processorsToUrl;
    private boolean goodVersion;
    private String version;
    private boolean gotVersion;
    private Lookup.Result<? extends HgHook> hooksResult;
    private Lookup.Result<? extends HyperlinkProvider> hpResult;
    private final RootsToFile rootsToFile = new RootsToFile();

    public static synchronized Mercurial getInstance() {
        if (instance == null) {
            instance = new Mercurial();
            instance.init();
        }
        return instance;
    }

    private Mercurial() {
        this.mvcs = (MercurialVCS)Lookup.getDefault().lookup(MercurialVCS.class);
    }

    private void init() {
        this.setDefaultPath();
        this.fileStatusCache = "false".equals(System.getProperty("mercurial.newGenerationCache", "true")) ? new FileStatusCache() : new FileStatusCacheNewGeneration();
        this.mercurialAnnotator = new MercurialAnnotator();
        this.mercurialInterceptor = new MercurialInterceptor();
        this.fileStatusCache.addPropertyChangeListener(this.mvcs);
        this.mercurialAnnotator.addPropertyChangeListener(this.mvcs);
        this.addPropertyChangeListener(this.mvcs);
        this.asyncInit();
    }

    private void setDefaultPath() {
        String string;
        String string2;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String string3 = HgModuleConfig.getDefault().getExecutableBinaryPath();
            if (string3 == null || string3.length() == 0) {
                String[] stringArray = new String[]{"/Library/Frameworks/Python.framework/Versions/Current/bin", "/usr/bin", "/usr/local/bin", "/opt/local/bin/", "/sw/bin"};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!HgModuleConfig.getDefault().isExecPathValid(stringArray[i]).booleanValue()) continue;
                    HgModuleConfig.getDefault().setExecutableBinaryPath(stringArray[i]);
                    break;
                }
            }
        } else if (Utilities.isWindows() && ((string2 = HgModuleConfig.getDefault().getExecutableBinaryPath()) == null || string2.length() == 0) && (string = HgUtils.findInUserPath(HgCommand.HG_WINDOWS_EXECUTABLES)) != null && !string.equals("")) {
            HgModuleConfig.getDefault().setExecutableBinaryPath(string);
        }
    }

    public void asyncInit() {
        this.gotVersion = false;
        RequestProcessor requestProcessor = this.getRequestProcessor();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HgKenaiSupport.getInstance().registerVCSNoficationListener();
                1 var1_1 = this;
                synchronized (var1_1) {
                    Mercurial.this.checkVersionIntern();
                }
            }
        };
        requestProcessor.post(runnable);
    }

    private void checkVersionIntern() {
        this.version = HgCommand.getHgVersion();
        LOG.log(Level.FINE, "version: {0}", this.version);
        this.goodVersion = this.version != null ? this.isSupportedVersion(this.version) : false;
        this.gotVersion = true;
    }

    private boolean isSupportedVersion(String string) {
        if (string.startsWith(MERCURIAL_SUPPORTED_VERSION_093) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_094) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_095) || string.startsWith(MERCURIAL_SUPPORTED_VERSION_100)) {
            return true;
        }
        return !string.startsWith("0.");
    }

    public boolean isAvailable() {
        return this.isAvailable(false, false);
    }

    public boolean isAvailable(boolean bl) {
        return this.isAvailable(false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(boolean bl, boolean bl2) {
        Object object = this;
        synchronized (object) {
            if (!this.gotVersion) {
                LOG.log(Level.FINE, "Call to hg version not finished");
                if (bl) {
                    this.checkVersionIntern();
                } else {
                    return true;
                }
            }
        }
        if (this.version != null && !this.goodVersion) {
            object = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            ((OutputLogger)object).outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_USING_UNRECOGNIZED_VERSION_MSG", (Object)this.version));
            ((OutputLogger)object).closeLog();
            LOG.log(Level.WARNING, "Using an unsupported hg version: {0}", this.version);
            this.goodVersion = true;
        } else if (this.version == null && bl2) {
            object = this.getLogger(MERCURIAL_OUTPUT_TAB_TITLE);
            ((OutputLogger)object).outputInRed(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_OUTPUT_MSG"));
            HgUtils.warningDialog(Mercurial.class, "MSG_VERSION_NONE_TITLE", "MSG_VERSION_NONE_MSG");
            ((OutputLogger)object).closeLog();
            LOG.warning("Hg is not available");
        }
        return this.goodVersion;
    }

    public MercurialAnnotator getMercurialAnnotator() {
        return this.mercurialAnnotator;
    }

    MercurialInterceptor getMercurialInterceptor() {
        return this.mercurialInterceptor;
    }

    public FileStatusCache getFileStatusCache() {
        return this.fileStatusCache;
    }

    public boolean isManaged(File file) {
        return VersioningSupport.getOwner((File)file) instanceof MercurialVCS && !HgUtils.isPartOfMercurialMetadata(file);
    }

    public File getRepositoryRoot(File file) {
        File file2 = file;
        this.rootsToFile.logStatistics();
        File file3 = this.rootsToFile.get(file, true);
        if (file3 != null) {
            return file3;
        }
        file3 = this.mvcs.getTopmostManagedAncestor(file);
        if (file3 != null) {
            if (file.isFile()) {
                file = file.getParentFile();
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            while (file != null && !file.getAbsolutePath().equals(file3.getAbsolutePath())) {
                File file4 = this.rootsToFile.get(file);
                if (file4 != null) {
                    this.rootsToFile.put(arrayList, file4);
                    this.rootsToFile.put(file2, file4);
                    return file4;
                }
                arrayList.add(file);
                if (HgUtils.hgExistsFor(file)) {
                    this.rootsToFile.put(arrayList, file);
                    this.rootsToFile.put(file2, file);
                    return file;
                }
                file = file.getParentFile();
            }
            arrayList.add(file3);
            this.rootsToFile.put(arrayList, file3);
            this.rootsToFile.put(file2, file3);
            return file3;
        }
        return null;
    }

    public String getMimeType(File file) {
        String string;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            string = "content/unknown";
        } else {
            string = fileObject.getMIMEType();
            if ("content/unknown".equals(string)) {
                string = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return HgUtils.isFileContentBinary(file) ? "application/octet-stream" : string;
        }
        return string;
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void changesetChanged(File file) {
        this.support.firePropertyChange(PROP_CHANGESET_CHANGED, file, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void getOriginalFile(File file, File file2) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        LOG.log(Level.FINE, "getOriginalFile: {0} {1}", new Object[]{file, fileInformation});
        if ((fileInformation.getStatus() & 0x4F8) == 0) {
            return;
        }
        try {
            File file3 = VersionsCache.getInstance().getFileRevision(file, "BASE");
            if (file3 == null) {
                return;
            }
            Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file2), (InputStream)new FileInputStream(file3));
            file3.delete();
        }
        catch (IOException iOException) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.INFO, "Unable to get original file", iOException);
        }
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor((HgURL)null);
    }

    public RequestProcessor getRequestProcessor(File file) {
        return this.getRequestProcessor(new HgURL(file));
    }

    public RequestProcessor getRequestProcessor(HgURL hgURL) {
        RequestProcessor requestProcessor;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((requestProcessor = this.processorsToUrl.get(hgURL)) == null) {
            String string = "Mercurial - " + (hgURL != null ? hgURL.toString() : "ANY_KEY");
            requestProcessor = new RequestProcessor(string, 1, true);
            this.processorsToUrl.put(hgURL, requestProcessor);
        }
        return requestProcessor;
    }

    public void clearRequestProcessor(HgURL hgURL) {
        if (this.processorsToUrl != null & hgURL != null) {
            this.processorsToUrl.remove(hgURL);
        }
    }

    public void notifyFileChanged(File file) {
        this.fileStatusCache.notifyFileChanged(file);
    }

    public OutputLogger getLogger(String string) {
        return OutputLogger.getLogger(string);
    }

    public Boolean isRefreshScheduled(File file) {
        return this.mercurialInterceptor.isRefreshScheduled(file);
    }

    public List<HgHook> getHooks() {
        if (this.hooksResult == null) {
            this.hooksResult = Lookup.getDefault().lookupResult(HgHook.class);
        }
        if (this.hooksResult == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HgHook> arrayList = new ArrayList<HgHook>();
        Collection collection = this.hooksResult.allInstances();
        if (collection.size() > 0) {
            for (HgHook hgHook : collection) {
                arrayList.add(hgHook);
            }
        }
        return arrayList;
    }

    public List<HyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(HyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.EMPTY_LIST;
        }
        Collection collection = this.hpResult.allInstances();
        ArrayList arrayList = new ArrayList(collection.size());
        arrayList.addAll(collection);
        return Collections.unmodifiableList(arrayList);
    }

    public String getVersion() {
        return this.version;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootsToFile {
        private static Logger LOG = Logger.getLogger("org.netbeans.modules.mercurial.RootsToFile");
        private LinkedList<File> order = new LinkedList();
        private Map<File, File> files = new HashMap<File, File>();
        private long cachedAccesCount = 0L;
        private long accesCount = 0L;
        private int statisticsFrequency = 0;

        public RootsToFile() {
            String string = System.getProperty("mercurial.root.stat.frequency", "0");
            this.statisticsFrequency = Integer.parseInt(string);
        }

        synchronized void put(Collection<File> collection, File file) {
            for (File file2 : collection) {
                this.put(file2, file);
            }
        }

        synchronized void put(File file, File file2) {
            if (this.order.size() > 1500) {
                for (int i = 0; i < 150; ++i) {
                    this.files.remove(this.order.getFirst());
                    this.order.removeFirst();
                }
            }
            this.order.addLast(file);
            this.files.put(file, file2);
        }

        synchronized File get(File file) {
            return this.get(file, false);
        }

        synchronized File get(File file, boolean bl) {
            File file2 = this.files.get(file);
            if (bl && LOG.isLoggable(Level.FINEST)) {
                this.cachedAccesCount += file2 != null ? 1L : 0L;
                ++this.accesCount;
            }
            return file2;
        }

        synchronized int size() {
            return this.order.size();
        }

        synchronized void logStatistics() {
            if (!LOG.isLoggable(Level.FINEST) || this.statisticsFrequency > 0 && this.accesCount % (long)this.statisticsFrequency != 0L) {
                return;
            }
            LOG.finest("HG Repository roots cache statistics:\n  cached roots size       = " + this.order.size() + "\n" + "  access count            = " + this.accesCount + "\n" + "  cached access count     = " + this.cachedAccesCount + "\n" + "  not cached access count = " + (this.accesCount - this.cachedAccesCount) + "\n");
        }
    }
}

