/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableUISupport {
    private TableUISupport() {
    }

    public static JList createTableList() {
        return new TableJList();
    }

    public static void connectAvailable(JList jList, TableClosure tableClosure) {
        jList.setModel(new AvailableTablesModel(tableClosure));
        if (!(jList.getCellRenderer() instanceof AvailableTableRenderer)) {
            jList.setCellRenderer(new AvailableTableRenderer());
        }
    }

    public static void connectSelected(JList jList, TableClosure tableClosure) {
        jList.setModel(new SelectedTablesModel(tableClosure));
        if (!(jList.getCellRenderer() instanceof SelectedTableRenderer)) {
            jList.setCellRenderer(new SelectedTableRenderer());
        }
    }

    public static Set<Table> getSelectedTables(JList jList) {
        HashSet<Table> hashSet = new HashSet<Table>();
        Object[] objectArray = jList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            hashSet.add((Table)objectArray[i]);
        }
        return hashSet;
    }

    public static void connectClassNames(JTable jTable, SelectedTables selectedTables) {
        jTable.setModel(new TableClassNamesModel(selectedTables));
        TableUISupport.setRenderer(jTable.getColumnModel().getColumn(0));
        TableUISupport.setRenderer(jTable.getColumnModel().getColumn(1));
    }

    private static void setRenderer(TableColumn tableColumn) {
        if (!(tableColumn.getCellRenderer() instanceof TableClassNameRenderer)) {
            tableColumn.setCellRenderer(new TableClassNameRenderer());
        }
    }

    private static final class TableJList
    extends JList {
        private TableJList() {
        }

        public int getNextMatch(String string, int n, Position.Bias bias) {
            ListModel listModel = this.getModel();
            if (!(listModel instanceof TableModel)) {
                return super.getNextMatch(string, n, bias);
            }
            TableModel tableModel = (TableModel)listModel;
            int n2 = tableModel.getSize();
            int n3 = bias == Position.Bias.Forward ? 1 : -1;
            int n4 = n;
            string = string.toUpperCase();
            do {
                Table table;
                String string2;
                if (!(string2 = (table = tableModel.getElementAt(n4)).getName().toUpperCase()).startsWith(string)) continue;
                return n4;
            } while ((n4 = (n4 + n3 + n2) % n2) != n);
            return -1;
        }
    }

    private static final class TableClassNameRenderer
    extends DefaultTableCellRenderer {
        private static Color errorForeground = UIManager.getColor("nb.errorForeground");
        private static Color nonErrorForeground;

        private TableClassNameRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Object object3;
            boolean bl3 = false;
            boolean bl4 = true;
            String string = null;
            if (jTable.getModel() instanceof TableClassNamesModel) {
                object3 = (TableClassNamesModel)jTable.getModel();
                object2 = ((TableClassNamesModel)object3).getTableAt(n);
                bl3 = ((Table)object2).isJoin();
                if (n2 == 1 && !(bl4 = ((TableClassNamesModel)object3).isValidClass((Table)object2))) {
                    string = ((TableClassNamesModel)object3).getProblemDisplayName((Table)object2);
                }
            }
            object3 = null;
            object3 = bl3 && n2 == 1 ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTable") : object;
            object2 = (JComponent)super.getTableCellRendererComponent(jTable, object3, bl, bl2, n, n2);
            ((JComponent)object2).setEnabled(!bl3);
            ((JComponent)object2).setToolTipText(bl3 ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTableDescription") : string);
            ((JComponent)object2).setForeground(bl4 ? nonErrorForeground : errorForeground);
            return object2;
        }

        static {
            if (errorForeground == null) {
                errorForeground = Color.RED;
            }
            nonErrorForeground = UIManager.getColor("Label.foreground");
        }
    }

    private static final class TableClassNamesModel
    extends AbstractTableModel {
        private SelectedTables selectedTables;
        private final List<Table> tables;

        public TableClassNamesModel(SelectedTables selectedTables) {
            this.selectedTables = selectedTables;
            this.tables = selectedTables.getTables();
        }

        public Table getTableAt(int n) {
            return this.tables.get(n);
        }

        public boolean isValidClass(Table table) {
            return !this.selectedTables.hasProblem(table);
        }

        public String getProblemDisplayName(Table table) {
            return this.selectedTables.getProblemDisplayNameForTable(table);
        }

        public int getRowCount() {
            return this.tables.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.tables.get(n).getName();
                }
                case 1: {
                    Table table = this.tables.get(n);
                    return this.selectedTables.getClassName(table);
                }
            }
            assert (false);
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 != 1) {
                return;
            }
            Table table = this.tables.get(n);
            this.selectedTables.setClassName(table, (String)object);
        }

        public boolean isCellEditable(int n, int n2) {
            Table table = this.tables.get(n);
            return !table.isJoin() && n2 == 1;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_DatabaseTable");
                }
                case 1: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_ClassName");
                }
            }
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SelectedTableRenderer
    extends DefaultListCellRenderer {
        private SelectedTableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Serializable serializable;
            Table table = null;
            Object object2 = null;
            boolean bl3 = false;
            TableClosure tableClosure = null;
            if (object instanceof Table) {
                table = (Table)object;
                object2 = ((Table)object).isTable() ? table.getName() : table.getName() + NbBundle.getMessage(TableUISupport.class, (String)"LBL_DB_VIEW");
                if (jList.getModel() instanceof SelectedTablesModel) {
                    serializable = (SelectedTablesModel)jList.getModel();
                    tableClosure = ((SelectedTablesModel)serializable).getTableClosure();
                    bl3 = tableClosure.getReferencedTables().contains(table);
                }
            } else {
                object2 = object;
            }
            serializable = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
            ((JComponent)serializable).setEnabled(!bl3);
            ((JComponent)serializable).setToolTipText(bl3 ? SelectedTableRenderer.getTableTooltip(table, tableClosure) : null);
            return serializable;
        }

        private static String getTableTooltip(Table table, TableClosure tableClosure) {
            String string;
            Set<Table> set;
            ArrayList<Table> arrayList = new ArrayList<Table>();
            if (table.isJoin()) {
                set = table.getReferencedTables();
                string = "LBL_RelatedTableJoin";
            } else {
                set = table.getReferencedByTables();
                string = "LBL_RelatedTableRefBy";
            }
            for (Table table2 : set) {
                if (!tableClosure.getSelectedTables().contains(table2)) continue;
                arrayList.add(table2);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return NbBundle.getMessage(TableUISupport.class, (String)string, (Object)SelectedTableRenderer.createTableList(arrayList));
        }

        private static String createTableList(List<Table> list) {
            assert (list.size() > 0);
            if (list.size() == 1) {
                return list.iterator().next().getName();
            }
            Collections.sort(list);
            String string = NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableListSep");
            Iterator<Table> iterator = list.iterator();
            StringBuilder stringBuilder = new StringBuilder(iterator.next().getName());
            String string2 = iterator.next().getName();
            while (iterator.hasNext()) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string2 = iterator.next().getName();
            }
            return NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableList", (Object)stringBuilder.toString(), (Object)string2);
        }
    }

    private static final class AvailableTableRenderer
    extends DefaultListCellRenderer {
        private AvailableTableRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Table.DisabledReason disabledReason = null;
            String string = null;
            if (object instanceof Table) {
                object2 = (Table)object;
                disabledReason = ((Table)object2).getDisabledReason();
                string = disabledReason != null ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableNameWithDisabledReason", (Object)((Table)object2).getName(), (Object)disabledReason.getDisplayName()) : (((Table)object2).isTable() ? ((Table)object2).getName() : ((Table)object2).getName() + NbBundle.getMessage(TableUISupport.class, (String)"LBL_DB_VIEW"));
            }
            object2 = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            ((JComponent)object2).setEnabled(disabledReason == null);
            ((JComponent)object2).setToolTipText(disabledReason != null ? disabledReason.getDescription() : null);
            return object2;
        }
    }

    private static final class SelectedTablesModel
    extends TableModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public SelectedTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        public Table getElementAt(int n) {
            return this.displayTables.get(n);
        }

        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }

        private void refresh() {
            int n = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getSelectedTables());
            Collections.sort(this.displayTables);
            this.fireIntervalRemoved(this, 0, n);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        public TableClosure getTableClosure() {
            return this.tableClosure;
        }
    }

    private static final class AvailableTablesModel
    extends TableModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public AvailableTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        public Table getElementAt(int n) {
            return this.displayTables.get(n);
        }

        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh();
        }

        private void refresh() {
            int n = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getAvailableTables());
            Collections.sort(this.displayTables);
            this.fireIntervalRemoved(this, 0, n);
            this.fireIntervalAdded(this, 0, this.getSize());
        }
    }

    private static abstract class TableModel
    extends AbstractListModel {
        private TableModel() {
        }

        public abstract Table getElementAt(int var1);
    }
}

