/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibraryCustomizer;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class PersistenceProviderComboboxHelper {
    private static final String SEPARATOR = "PersistenceProviderComboboxHelper.SEPARATOR";
    private static final String EMPTY = "PersistenceProviderComboboxHelper.EMPTY";
    private final PersistenceProviderSupplier providerSupplier;

    public PersistenceProviderComboboxHelper(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (persistenceProviderSupplier == null) {
            persistenceProviderSupplier = new DefaultPersistenceProviderSupplier();
        }
        this.providerSupplier = persistenceProviderSupplier;
    }

    public void connect(final JComboBox jComboBox) {
        jComboBox.setEditable(false);
        this.initCombo(jComboBox);
        jComboBox.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                int n = keyEvent.getKeyCode();
                if (10 == n && (object = jComboBox.getSelectedItem()) instanceof LibraryItem) {
                    jComboBox.hidePopup();
                    ((LibraryItem)object).performAction();
                    keyEvent.consume();
                    PersistenceProviderComboboxHelper.this.initCombo(jComboBox);
                }
            }
        });
        jComboBox.addActionListener(new ActionListener(){
            Object currentItem;
            int currentIndex;
            {
                this.currentItem = jComboBox.getSelectedItem();
                this.currentIndex = jComboBox.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(object)) {
                    int n = jComboBox.getSelectedIndex();
                    if (n > this.currentIndex) {
                        this.currentIndex = n + 1;
                        this.currentItem = jComboBox.getItemAt(this.currentIndex);
                    } else {
                        this.currentIndex = n - 1;
                        this.currentItem = jComboBox.getItemAt(this.currentIndex);
                    }
                    jComboBox.setSelectedItem(this.currentItem);
                } else if ((actionEvent.getModifiers() & 0x10) != 0) {
                    if (object instanceof LibraryItem) {
                        jComboBox.setPopupVisible(false);
                        ((LibraryItem)object).performAction();
                        PersistenceProviderComboboxHelper.this.initCombo(jComboBox);
                    }
                } else {
                    this.currentItem = object;
                    this.currentIndex = jComboBox.getSelectedIndex();
                }
            }
        });
    }

    private void initCombo(JComboBox jComboBox) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
        for (Provider provider : this.providerSupplier.getSupportedProviders()) {
            defaultComboBoxModel.addElement(provider);
        }
        if (defaultComboBoxModel.getSize() == 0 && this.providerSupplier.supportsDefaultProvider()) {
            defaultComboBoxModel.addElement(ProviderUtil.DEFAULT_PROVIDER);
        }
        this.addProvidersFromLibraries(defaultComboBoxModel);
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.addElement(EMPTY);
        }
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.addItem(SEPARATOR);
        jComboBox.addItem(new NewPersistenceLibraryItem());
        jComboBox.addItem(new ManageLibrariesItem());
        jComboBox.setRenderer(new PersistenceProviderCellRenderer(this.getDefaultProvider(defaultComboBoxModel)));
        jComboBox.setSelectedIndex(0);
    }

    private Provider getDefaultProvider(ComboBoxModel comboBoxModel) {
        if (!this.providerSupplier.supportsDefaultProvider()) {
            return null;
        }
        if (comboBoxModel.getElementAt(0) instanceof Provider) {
            return (Provider)comboBoxModel.getElementAt(0);
        }
        return null;
    }

    private void addProvidersFromLibraries(DefaultComboBoxModel defaultComboBoxModel) {
        for (Provider provider : PersistenceLibrarySupport.getProvidersFromLibraries()) {
            boolean bl = false;
            for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                Object e = defaultComboBoxModel.getElementAt(i);
                if (!(e instanceof Provider) || !provider.equals(e)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            defaultComboBoxModel.addElement(provider);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPersistenceProviderSupplier
    implements PersistenceProviderSupplier {
        private DefaultPersistenceProviderSupplier() {
        }

        @Override
        public List<Provider> getSupportedProviders() {
            return Collections.emptyList();
        }

        @Override
        public boolean supportsDefaultProvider() {
            return false;
        }
    }

    private static class PersistenceProviderCellRenderer
    extends DefaultListCellRenderer {
        Provider defaultProvider;

        PersistenceProviderCellRenderer(Provider provider) {
            this.defaultProvider = provider;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof Provider) {
                Provider provider = (Provider)object;
                String string = provider.getDisplayName();
                if (object.equals(this.defaultProvider) && !(object instanceof DefaultProvider)) {
                    string = string + NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_DEFAULT_PROVIDER");
                }
                this.setText(string);
            } else {
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(object)) {
                    JSeparator jSeparator = new JSeparator();
                    jSeparator.setPreferredSize(new Dimension(jSeparator.getWidth(), 1));
                    jSeparator.setForeground(Color.BLACK);
                    return jSeparator;
                }
                if (PersistenceProviderComboboxHelper.EMPTY.equals(object)) {
                    this.setText(" ");
                } else if (object instanceof LibraryItem) {
                    this.setText(((LibraryItem)object).getText());
                } else {
                    this.setText(object != null ? object.toString() : "");
                }
            }
            return this;
        }
    }

    private static class ManageLibrariesItem
    implements LibraryItem {
        private ManageLibrariesItem() {
        }

        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_ManageLibraries");
        }

        public void performAction() {
            LibrariesCustomizer.showCustomizer(null);
        }
    }

    private static class NewPersistenceLibraryItem
    implements LibraryItem {
        private NewPersistenceLibraryItem() {
        }

        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_NewPersistenceLibrary");
        }

        public void performAction() {
            PersistenceLibraryCustomizer.showCustomizer();
        }
    }

    public static interface LibraryItem {
        public String getText();

        public void performAction();
    }
}

