/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.common.Properties;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.DataNucleusProvider;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.EclipseLinkProvider;
import org.netbeans.modules.j2ee.persistence.provider.HibernateProvider;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.KodoProvider;
import org.netbeans.modules.j2ee.persistence.provider.OpenJPAProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ToplinkProvider;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.j2ee.persistence.spi.server.ServerStatusProvider;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderUtil {
    public static final Provider HIBERNATE_PROVIDER = new HibernateProvider();
    public static final Provider TOPLINK_PROVIDER = ToplinkProvider.create();
    public static final Provider ECLIPSELINK_PROVIDER = new EclipseLinkProvider("2.0");
    public static final Provider ECLIPSELINK_PROVIDER1_0 = new EclipseLinkProvider("1.0");
    public static final Provider KODO_PROVIDER = new KodoProvider();
    public static final Provider DATANUCLEUS_PROVIDER = new DataNucleusProvider();
    public static final Provider OPENJPA_PROVIDER = new OpenJPAProvider();
    public static final Provider DEFAULT_PROVIDER = new DefaultProvider();
    private static final Provider TOPLINK_PROVIDER_55_COMPATIBLE = ToplinkProvider.create55Compatible();

    private ProviderUtil() {
    }

    public static Provider getProvider(String string, Project project) {
        if (null == string || "".equals(string.trim())) {
            return ProviderUtil.getContainerManagedProvider(project);
        }
        for (Provider provider : ProviderUtil.getAllProviders()) {
            if (!provider.getProviderClass().equals(string.trim())) continue;
            return provider;
        }
        return DEFAULT_PROVIDER;
    }

    private static Provider getContainerManagedProvider(Project project) {
        PersistenceProviderSupplier persistenceProviderSupplier = (PersistenceProviderSupplier)project.getLookup().lookup(PersistenceProviderSupplier.class);
        if (persistenceProviderSupplier == null || !persistenceProviderSupplier.supportsDefaultProvider() || persistenceProviderSupplier.getSupportedProviders().isEmpty()) {
            return null;
        }
        return persistenceProviderSupplier.getSupportedProviders().get(0);
    }

    public static DatabaseConnection getConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"pu", (Object)persistenceUnit);
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        Property[] propertyArray = persistenceUnit.getProperties().getProperty2();
        Provider provider = ProviderUtil.getProvider(persistenceUnit);
        for (int i = 0; i < propertyArray.length; ++i) {
            String string4 = propertyArray[i].getName();
            if (string4 == null) continue;
            if (string4.equals(provider.getJdbcUrl())) {
                string = propertyArray[i].getValue();
                continue;
            }
            if (string4.equals(provider.getJdbcDriver())) {
                string2 = propertyArray[i].getValue();
                continue;
            }
            if (!string4.equals(provider.getJdbcUsername())) continue;
            string3 = propertyArray[i].getValue();
        }
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            DatabaseConnection databaseConnection = databaseConnectionArray[i];
            if (!databaseConnection.getDatabaseURL().equals(string) || !databaseConnection.getDriverClass().equals(string2) || !databaseConnection.getUser().equals(string3)) continue;
            return databaseConnection;
        }
        return null;
    }

    public static void setTableGeneration(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string, Project project) {
        String string2 = persistenceUnit.getProvider();
        Provider provider = ProviderUtil.getProvider(string2, project);
        ProviderUtil.setTableGeneration(persistenceUnit, string, provider);
    }

    public static void setTableGeneration(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string, Provider provider) {
        Property property;
        if (provider == null) {
            return;
        }
        String string2 = "1.0";
        if (persistenceUnit instanceof PersistenceUnit) {
            string2 = "2.0";
        }
        Property property2 = provider.getTableGenerationProperty(string, string2);
        Properties properties = persistenceUnit.getProperties();
        if (properties == null) {
            properties = persistenceUnit.newProperties();
            persistenceUnit.setProperties(properties);
        }
        if ((property = ProviderUtil.getProperty(properties.getProperty2(), provider.getTableGenerationPropertyName())) != null && property2 == null) {
            properties.removeProperty2(property);
        } else if (property != null && property2 != null) {
            property.setValue(property2.getValue());
        } else if (property2 != null) {
            properties.addProperty2(property2);
        }
    }

    public static void setProvider(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection databaseConnection, String string) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        ProviderUtil.removeProviderProperties(persistenceUnit);
        persistenceUnit.setProvider(provider.getProviderClass());
        ProviderUtil.setDatabaseConnection(persistenceUnit, provider, databaseConnection);
        ProviderUtil.setTableGeneration(persistenceUnit, string, provider);
    }

    public static void removeProviderProperties(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        ArrayList<Provider> arrayList = ProviderUtil.getProviders(persistenceUnit);
        HashSet hashSet = new HashSet();
        for (Provider provider : arrayList) {
            hashSet.addAll(provider.getPropertyNames());
        }
        Property[] propertyArray = ProviderUtil.getProperties(persistenceUnit);
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (!hashSet.contains(property.getName())) continue;
            persistenceUnit.getProperties().removeProperty2(property);
        }
        persistenceUnit.setProvider(null);
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit buildPersistenceUnit(String string, Provider provider, DatabaseConnection databaseConnection, String string2) {
        Parameters.notNull((CharSequence)"name", (Object)string);
        Parameters.notNull((CharSequence)"provider", (Object)provider);
        Parameters.notNull((CharSequence)"connection", (Object)databaseConnection);
        BaseBean baseBean = null;
        baseBean = "2.0".equals(string2) ? new PersistenceUnit() : new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
        baseBean.setName(string);
        baseBean.setProvider(provider.getProviderClass());
        Properties properties = baseBean.newProperties();
        Map<String, String> map = provider.getConnectionPropertiesMap(databaseConnection, string2);
        for (String object : map.keySet()) {
            Object object2 = properties.newProperty();
            object2.setName(object);
            object2.setValue(map.get(object));
            properties.addProperty2((Property)object2);
        }
        Map map2 = provider.getDefaultVendorSpecificProperties();
        for (Object object2 : map2.keySet()) {
            Property property = properties.newProperty();
            property.setName((String)object2);
            property.setValue((String)map2.get(object2));
            properties.addProperty2(property);
        }
        baseBean.setProperties(properties);
        return baseBean;
    }

    public static void setDatabaseConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, DatabaseConnection databaseConnection) {
        ProviderUtil.setDatabaseConnection(persistenceUnit, null, databaseConnection);
    }

    public static void setDatabaseConnection(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Provider provider, DatabaseConnection databaseConnection) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        if (provider == null) {
            provider = ProviderUtil.getProvider(persistenceUnit);
        }
        Property[] propertyArray = ProviderUtil.getProperties(persistenceUnit);
        String string = persistenceUnit instanceof PersistenceUnit ? "2.0" : "1.0";
        Map<String, String> map = provider.getConnectionPropertiesMap(databaseConnection, string);
        for (String string2 : map.keySet()) {
            String string3;
            Property property = ProviderUtil.getProperty(propertyArray, string2);
            if (property == null) {
                if (persistenceUnit.getProperties() == null) {
                    persistenceUnit.setProperties(persistenceUnit.newProperties());
                }
                property = persistenceUnit.getProperties().newProperty();
                property.setName(string2);
                persistenceUnit.getProperties().addProperty2(property);
            }
            if ((string3 = map.get(string2)) == null) {
                string3 = "";
            }
            property.setValue(string3);
        }
    }

    static Property[] getProperties(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        if (persistenceUnit.getProperties() != null) {
            return persistenceUnit.getProperties().getProperty2();
        }
        return new Property[0];
    }

    private static Property getProperty(Property[] propertyArray, String string) {
        if (null == propertyArray) {
            return null;
        }
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            if (property.getName() == null || !property.getName().equals(string)) continue;
            return property;
        }
        return null;
    }

    public static Property getProperty(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string) {
        if (persistenceUnit.getProperties() == null) {
            return null;
        }
        return ProviderUtil.getProperty(persistenceUnit.getProperties().getProperty2(), string);
    }

    public static Provider getProvider(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        String string = persistenceUnit instanceof org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit ? "1.0" : "2.0";
        long l = Math.round(Double.parseDouble(string) * 100.0);
        Provider provider = null;
        for (Provider provider2 : ProviderUtil.getAllProviders()) {
            if (!provider2.getProviderClass().equals(persistenceUnit.getProvider())) continue;
            String string2 = provider2.getVersion();
            if (string2 == null) {
                return provider2;
            }
            long l2 = Math.round(Double.parseDouble(string2) * 100.0);
            if (l2 < l) continue;
            provider = provider2;
        }
        return provider == null ? DEFAULT_PROVIDER : provider;
    }

    public static ArrayList<Provider> getProviders(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        for (Provider provider : ProviderUtil.getAllProviders()) {
            if (!provider.getProviderClass().equals(persistenceUnit.getProvider())) continue;
            arrayList.add(provider);
        }
        if (arrayList.size() == 0) {
            arrayList.add(DEFAULT_PROVIDER);
        }
        return arrayList;
    }

    public static boolean isValid(PUDataObject pUDataObject) {
        return null == pUDataObject ? false : pUDataObject.parseDocument();
    }

    public static org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] getPersistenceUnits(PUDataObject pUDataObject) {
        if (pUDataObject.getPersistence() == null) {
            return new org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[0];
        }
        return pUDataObject.getPersistence().getPersistenceUnit();
    }

    public static void renameManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string, String string2, PUDataObject pUDataObject) {
        pUDataObject.removeClass(persistenceUnit, string2, false);
        pUDataObject.addClass(persistenceUnit, string, false);
    }

    public static void removeManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string, PUDataObject pUDataObject) {
        pUDataObject.removeClass(persistenceUnit, string, false);
    }

    public static void addManagedClass(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, String string, PUDataObject pUDataObject) {
        pUDataObject.addClass(persistenceUnit, string, false);
    }

    public static void addPersistenceUnit(org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit, Project project) throws InvalidPersistenceXmlException {
        String string = persistenceUnit instanceof PersistenceUnit ? "2.0" : "1.0";
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project, string);
        pUDataObject.addPersistenceUnit(persistenceUnit);
        pUDataObject.save();
    }

    public static PUDataObject getPUDataObject(FileObject fileObject) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        if (!(dataObject instanceof PUDataObject)) {
            throw new InvalidPersistenceXmlException(FileUtil.getFileDisplayName((FileObject)fileObject));
        }
        return (PUDataObject)dataObject;
    }

    public static synchronized PUDataObject getPUDataObject(Project project, String string) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        FileObject fileObject = ProviderUtil.getDDFile(project);
        if (fileObject == null) {
            try {
                fileObject = ProviderUtil.createPersistenceDDFile(project, string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject == null) {
            return null;
        }
        return ProviderUtil.getPUDataObject(fileObject);
    }

    public static synchronized PUDataObject getPUDataObject(Project project) throws InvalidPersistenceXmlException {
        return ProviderUtil.getPUDataObject(project, null);
    }

    private static FileObject createPersistenceDDFile(Project project, String string) throws IOException {
        final FileObject fileObject = PersistenceLocation.createLocation((Project)project);
        if (fileObject == null) {
            return null;
        }
        final FileObject[] fileObjectArray = new FileObject[1];
        String string2 = string == null ? PersistenceUtils.getJPAVersion(project) : string;
        final String string3 = string2 != null ? string2 : "1.0";
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                fileObjectArray[0] = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)("org-netbeans-modules-j2ee-persistence/persistence-" + string3 + ".xml")), (FileObject)fileObject, (String)"persistence");
            }
        });
        PersistenceUtils.logUsage(ProviderUtil.class, "USG_PERSISTENCE_XML_CREATED", new String[]{string3});
        return fileObjectArray[0];
    }

    public static boolean persistenceExists(Project project) throws InvalidPersistenceXmlException {
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (ProviderUtil.getDDFile(project) == null) {
            return false;
        }
        PUDataObject pUDataObject = ProviderUtil.getPUDataObject(project);
        return pUDataObject.getPersistence().getPersistenceUnit().length > 0;
    }

    public static FileObject getDDFile(Project project) {
        int n = 0;
        PersistenceScope[] persistenceScopeArray = PersistenceUtils.getPersistenceScopes(project);
        if (n < persistenceScopeArray.length) {
            return persistenceScopeArray[n].getPersistenceXml();
        }
        return null;
    }

    public static Provider[] getAllProviders() {
        return new Provider[]{ECLIPSELINK_PROVIDER, ECLIPSELINK_PROVIDER1_0, TOPLINK_PROVIDER, HIBERNATE_PROVIDER, KODO_PROVIDER, DATANUCLEUS_PROVIDER, OPENJPA_PROVIDER, TOPLINK_PROVIDER_55_COMPATIBLE};
    }

    public static boolean makePortableIfPossible(Project project, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"persistenceUnit", (Object)persistenceUnit);
        if (Util.isJavaSE(project)) {
            return false;
        }
        Provider provider = ProviderUtil.getContainerManagedProvider(project);
        if (provider == null) {
            return false;
        }
        if (provider.getProviderClass().equals(persistenceUnit.getProvider()) && persistenceUnit.getProperties().sizeProperty2() == 0) {
            persistenceUnit.setProvider(null);
            return true;
        }
        return false;
    }

    public static boolean isValidServerInstanceOrNone(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ServerStatusProvider serverStatusProvider = (ServerStatusProvider)project.getLookup().lookup(ServerStatusProvider.class);
        if (serverStatusProvider == null) {
            return true;
        }
        return serverStatusProvider.validServerInstancePresent();
    }

    public static void migrateProperties(String string, String string2, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
        block3: {
            block2: {
                if (!string.equals("oracle.toplink.essentials.PersistenceProvider") || !string2.equals("org.eclipse.persistence.jpa.PersistenceProvider")) break block2;
                Property[] propertyArray = persistenceUnit.getProperties().getProperty2();
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (!propertyArray[i].getName().contains("toplink")) continue;
                    String string3 = propertyArray[i].getName();
                    string3 = string3.replace("toplink", "eclipselink");
                    Property property = persistenceUnit.getProperties().newProperty();
                    property.setName(string3);
                    property.setValue(propertyArray[i].getValue());
                    persistenceUnit.getProperties().removeProperty2(propertyArray[i]);
                    persistenceUnit.getProperties().addProperty2(property);
                }
                break block3;
            }
            if (!string.equals("org.eclipse.persistence.jpa.PersistenceProvider") || !string2.equals("oracle.toplink.essentials.PersistenceProvider")) break block3;
            Property[] propertyArray = persistenceUnit.getProperties().getProperty2();
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!propertyArray[i].getName().contains("eclipselink")) continue;
                String string4 = propertyArray[i].getName();
                string4 = string4.replace("eclipselink", "toplink");
                Property property = persistenceUnit.getProperties().newProperty();
                property.setName(string4);
                property.setValue(propertyArray[i].getValue());
                persistenceUnit.getProperties().removeProperty2(propertyArray[i]);
                persistenceUnit.getProperties().addProperty2(property);
            }
        }
    }
}

