/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.XStrNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.ruby.AstUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateDetector {
    private ParserResult info;
    private BaseDocument doc;
    private List<Node> nodes;
    private Node startNode;
    private Node endNode;
    private Node root;
    private int currentStart;
    private int currentEnd;
    private List<OffsetRange> duplicates = new ArrayList<OffsetRange>();

    public DuplicateDetector(ParserResult parserResult, BaseDocument baseDocument, Node node, List<Node> list, Node node2, Node node3) {
        this.info = parserResult;
        this.doc = baseDocument;
        this.root = node;
        this.nodes = list;
        this.startNode = node2;
        this.endNode = node3;
    }

    public static List<OffsetRange> findDuplicates(ParserResult parserResult, BaseDocument baseDocument, Node node, List<Node> list, Node node2, Node node3) {
        if (list.size() == 0 || node2 != node3) {
            return Collections.emptyList();
        }
        if (node2.getNodeType() == NodeType.ARRAYNODE) {
            if (node2.childNodes().size() == 1) {
                node2 = (Node)node2.childNodes().get(0);
            } else {
                return Collections.emptyList();
            }
        }
        DuplicateDetector duplicateDetector = new DuplicateDetector(parserResult, baseDocument, node, list, node2, node3);
        duplicateDetector.visit(node, node2);
        return duplicateDetector.duplicates;
    }

    private void visit(Node node, Node node2) {
        if (node.getNodeType() == node2.getNodeType()) {
            boolean bl = false;
            switch (node.getNodeType()) {
                case FLOATNODE: {
                    bl = ((FloatNode)node).getValue() == ((FloatNode)node2).getValue();
                    break;
                }
                case BIGNUMNODE: {
                    bl = ((BignumNode)node).getValue() == ((BignumNode)node2).getValue();
                    break;
                }
                case FIXNUMNODE: {
                    bl = ((FixnumNode)node).getValue() == ((FixnumNode)node2).getValue();
                    break;
                }
                case SYMBOLNODE: {
                    bl = ((SymbolNode)node).getName().equals(((SymbolNode)node2).getName());
                    break;
                }
                case STRNODE: {
                    bl = ((StrNode)node).getValue().equals(((StrNode)node2).getValue());
                    break;
                }
                case XSTRNODE: {
                    bl = ((XStrNode)node).getValue().equals(((XStrNode)node2).getValue());
                }
            }
            if (bl) {
                this.duplicates.add(AstUtilities.getRange((Node)node));
            }
        }
        List list = node.childNodes();
        for (Node node3 : list) {
            if (node3.isInvisible()) continue;
            this.visit(node3, node2);
        }
    }
}

