/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.DefaultButtonModel;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.SourcesInformationPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ForumsAndMailingListsPanel
extends JPanel
implements RefreshableContentPanel {
    public static final String CHAT_BUTTON = "CHAT_BUTTON";
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT"));
    private JEditorPane commChannelsDisplayer;

    public ForumsAndMailingListsPanel() {
        this.initComponents();
        this.commChannelsDisplayer.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setToolTipText(hyperlinkEvent.getDescription());
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setToolTipText("");
                    ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
                    return;
                }
            }
        });
    }

    public String getChatRoomHTML(KenaiProject kenaiProject) {
        String string = "";
        try {
            if (kenaiProject.isMyProject()) {
                KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.CHAT);
                string = string + String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_CHATROOM"));
                string = kenaiFeatureArray.length > 0 ? string + String.format("<input type=\"reset\" id=\"CHAT_BUTTON\" value=\"%s\"><br>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_ENTER_CHATROOM")) : string + String.format("<i>%s</i><br>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_NO_CHAT"));
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        string = string + "</div>";
        return string;
    }

    public String getForumsHTML(KenaiProject kenaiProject) {
        KenaiFeature[] kenaiFeatureArray = null;
        String string = "";
        try {
            kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.FORUM);
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (kenaiFeatureArray.length > 0) {
            string = String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_FORUMS"));
            for (int i = 0; i < kenaiFeatureArray.length; ++i) {
                KenaiFeature kenaiFeature = kenaiFeatureArray[i];
                string = string + String.format("<div class=\"item\">%s&nbsp;<a href=\"%s\">%s</a> - <i>%s</i></div>", kenaiProjectTopComponent.linkImageHTML, kenaiFeature.getWebLocation(), kenaiFeature.getDisplayName(), kenaiFeature.getWebLocation());
            }
            string = string + "</div>";
        }
        return string;
    }

    public String getMailingListsHTML(KenaiProject kenaiProject) {
        KenaiFeature[] kenaiFeatureArray = null;
        String string = "";
        try {
            kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.LISTS);
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (kenaiFeatureArray.length > 0) {
            string = string + String.format("<div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_MAILING_LISTS"));
            for (int i = 0; i < kenaiFeatureArray.length; ++i) {
                KenaiFeature kenaiFeature = kenaiFeatureArray[i];
                string = string + String.format("<div class=\"item\">%s&nbsp;<a href=\"%s\">%s</a> - <i>%s</i></div>", kenaiProjectTopComponent.linkImageHTML, kenaiFeature.getWebLocation(), kenaiFeature.getDisplayName(), kenaiFeature.getWebLocation());
            }
            string = string + "</div>";
        }
        return string;
    }

    public void loadActiveTopics(KenaiProject kenaiProject) throws DOMException {
        try {
            Object object;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String string = Kenai.getDefault().getUrl().toString().replaceFirst("https://", "http://");
            String string2 = string + "/projects/" + kenaiProject.getName() + "/forums?format=atom";
            int n = 0;
            NodeList nodeList = null;
            if (Thread.interrupted()) {
                this.clearContent();
                return;
            }
            try {
                object = documentBuilder.parse(string2);
                if (Thread.interrupted()) {
                    this.clearContent();
                    return;
                }
                nodeList = object.getElementsByTagName("entry");
                n = nodeList.getLength();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (SAXParseException sAXParseException) {
                final String string3 = "<div class=\"section\"><i>" + NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_PARSE_ERR") + "</i></div>";
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Element element = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (element != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(element, string3);
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
                return;
            }
            object = "<div class=\"section\">";
            if (n > 0 && nodeList != null) {
                for (int i = 0; i < n; ++i) {
                    if (Thread.interrupted()) {
                        this.clearContent();
                        return;
                    }
                    Node node = nodeList.item(i);
                    NodeList nodeList2 = node.getChildNodes();
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        if (Thread.interrupted()) {
                            this.clearContent();
                            return;
                        }
                        Node node2 = nodeList2.item(j);
                        if (node2.getNodeName().equals("title")) {
                            string4 = node2.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (node2.getNodeName().equals("link")) {
                            string6 = node2.getAttributes().getNamedItem("href").getNodeValue();
                            if (string6.startsWith(string)) continue;
                            string6 = string + string6;
                            continue;
                        }
                        if (!node2.getNodeName().equals("content")) continue;
                        string5 = node2.getFirstChild().getNodeValue();
                    }
                    if (string4 != null && string6 != null) {
                        object = (String)object + String.format("%s&nbsp;<a href=\"%s\">%s</a><br>", kenaiProjectTopComponent.linkImageHTML, string6, string4);
                    }
                    if (string5 == null) continue;
                    object = (String)object + String.format("<i>%s</i><br><br>", string5);
                }
                object = (String)object + "</div>";
                if (Thread.interrupted()) {
                    this.clearContent();
                    return;
                }
                Object object2 = object;
                SwingUtilities.invokeLater(new Runnable((String)object2){
                    final /* synthetic */ String val$appString;
                    {
                        this.val$appString = string;
                    }

                    public void run() {
                        try {
                            Element element = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (element != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(element, this.val$appString);
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            } else {
                final String string7 = (String)object + "<i>" + NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_NO_ACTIVE_TOPICS") + "</i></div>";
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Element element = ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).getElement("DYN_CONTENT");
                            if (element != null) {
                                ((HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument()).insertAfterStart(element, string7);
                            }
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                });
            }
        }
        catch (SAXException sAXException) {
            Exceptions.printStackTrace((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Exceptions.printStackTrace((Throwable)parserConfigurationException);
        }
    }

    public void resetContent(final KenaiProject kenaiProject) {
        Font font = UIManager.getFont("Label.font");
        String string = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.commChannelsDisplayer.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("div.item {margin-bottom: 5px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}");
        String string2 = "<html>";
        string2 = string2 + this.getMailingListsHTML(kenaiProject);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        string2 = string2 + this.getChatRoomHTML(kenaiProject);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        string2 = string2 + this.getForumsHTML(kenaiProject);
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        string2 = string2 + String.format("<h2>%s</h2><div id=\"DYN_CONTENT\"></div>", NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"MSG_ACTIVE_FORUMS"));
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        string2 = string2 + "</html>";
        if (Thread.interrupted()) {
            this.clearContent();
            return;
        }
        final String string3 = string2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setText(string3);
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.validate();
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setCaretPosition(0);
                HTMLDocument hTMLDocument = (HTMLDocument)ForumsAndMailingListsPanel.this.commChannelsDisplayer.getDocument();
                Element element = hTMLDocument.getElement(ForumsAndMailingListsPanel.CHAT_BUTTON);
                if (element != null) {
                    AttributeSet attributeSet = element.getAttributes();
                    Enumeration<?> enumeration = attributeSet.getAttributeNames();
                    while (enumeration.hasMoreElements()) {
                        Object obj = enumeration.nextElement();
                        Object object = attributeSet.getAttribute(obj);
                        if (!"model".equals(obj.toString())) continue;
                        DefaultButtonModel defaultButtonModel = (DefaultButtonModel)object;
                        defaultButtonModel.setActionCommand(ForumsAndMailingListsPanel.CHAT_BUTTON);
                        defaultButtonModel.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ChatTopComponent chatTopComponent = ChatTopComponent.findInstance();
                                chatTopComponent.open();
                                chatTopComponent.requestActive();
                                chatTopComponent.setActiveGroup(kenaiProject.getName());
                            }
                        });
                    }
                }
            }
        });
        this.loadActiveTopics(kenaiProject);
    }

    private void initComponents() {
        this.commChannelsDisplayer = new JEditorPane();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.commChannelsDisplayer.setBackground(new Color(255, 255, 255));
        this.commChannelsDisplayer.setContentType(NbBundle.getMessage(ForumsAndMailingListsPanel.class, (String)"ForumsAndMailingListsPanel.commChannelsDisplayer.contentType"));
        this.commChannelsDisplayer.setEditable(false);
        this.commChannelsDisplayer.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ForumsAndMailingListsPanel.this.commChannelsDisplayerFocusGained(focusEvent);
            }
        });
        this.add((Component)this.commChannelsDisplayer, "Center");
    }

    private void commChannelsDisplayerFocusGained(FocusEvent focusEvent) {
        this.commChannelsDisplayer.getCaret().setVisible(false);
    }

    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ForumsAndMailingListsPanel.this.commChannelsDisplayer.setText(ForumsAndMailingListsPanel.this.WAIT_STRING);
            }
        });
    }
}

