/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.kenai.ui.dashboard.MemberNode;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.SectionNode;
import org.netbeans.modules.kenai.ui.spi.MemberAccessor;
import org.netbeans.modules.kenai.ui.spi.MemberHandle;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberListNode
extends SectionNode {
    private MessagingHandle msg;
    private PropertyChangeListener l;
    private static final String PROP_MEMBERS = "members";

    public MemberListNode(ProjectNode projectNode) {
        super(MemberListNode.getText(MessagingAccessor.getDefault().getMessaging(projectNode.getProject())), projectNode, PROP_MEMBERS);
        this.msg = MessagingAccessor.getDefault().getMessaging(this.project);
        this.l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("onlineCount".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (MemberListNode.this.lblName != null) {
                                MemberListNode.this.lblName.setText(MemberListNode.getText(MemberListNode.this.msg));
                            }
                        }
                    });
                }
            }
        };
        this.msg.addPropertyChangeListener(this.l);
    }

    private static String getText(MessagingHandle messagingHandle) {
        int n = messagingHandle.getOnlineCount();
        if (n >= 0) {
            return NbBundle.getMessage(MemberListNode.class, (String)"LBL_MembersOnline", (Object)messagingHandle.getOnlineCount());
        }
        return NbBundle.getMessage(MemberListNode.class, (String)"LBL_Members");
    }

    @Override
    protected List<TreeListNode> createChildren() {
        ArrayList<TreeListNode> arrayList = new ArrayList<TreeListNode>(20);
        MemberAccessor memberAccessor = MemberAccessor.getDefault();
        List<MemberHandle> list = memberAccessor.getMembers(this.project);
        for (MemberHandle memberHandle : list) {
            arrayList.add(new MemberNode(memberHandle, (TreeListNode)this));
        }
        return arrayList;
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.msg != null) {
            this.msg.removePropertyChangeListener(this.l);
        }
    }
}

