/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.LoginAction;
import org.netbeans.modules.kenai.ui.LoginHandleImpl;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.dashboard.CategoryNode;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.EmptyNode;
import org.netbeans.modules.kenai.ui.dashboard.ErrorNode;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.dashboard.MyProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.ProjectNode;
import org.netbeans.modules.kenai.ui.dashboard.UserNode;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeList;
import org.netbeans.modules.kenai.ui.treelist.TreeListModel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DashboardImpl
extends Dashboard {
    private static final String PREF_ALL_PROJECTS = "allProjects";
    private static final String PREF_COUNT = "count";
    private static final String PREF_ID = "id";
    private LoginHandle login;
    private final TreeListModel model = new TreeListModel();
    private static final ListModel EMPTY_MODEL = new AbstractListModel(){

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }
    };
    private RequestProcessor requestProcessor = new RequestProcessor("Kenai Dashboard");
    private final TreeList treeList = new TreeList(this.model);
    private final ArrayList<ProjectHandle> memberProjects = new ArrayList(50);
    private final ArrayList<ProjectHandle> openProjects = new ArrayList(50);
    public final JScrollPane dashboardComponent;
    private final PropertyChangeListener userListener;
    private boolean opened = false;
    private boolean memberProjectsLoaded = false;
    private boolean otherProjectsLoaded = false;
    private static final long TIMEOUT_INTERVAL_MILLIS = TreeListNode.TIMEOUT_INTERVAL_MILLIS;
    private OtherProjectsLoader otherProjectsLoader;
    private MemberProjectsLoader memberProjectsLoader;
    private final UserNode userNode;
    private final ErrorNode memberProjectsError;
    private final ErrorNode otherProjectsError;
    private final CategoryNode openProjectsNode;
    private final CategoryNode myProjectsNode;
    private final EmptyNode noOpenProjects = new EmptyNode(this, NbBundle.getMessage(DashboardImpl.class, (String)"NO_PROJECTS_OPEN"), NbBundle.getMessage(DashboardImpl.class, (String)"LBL_OpeningProjects"));
    private final EmptyNode noMyProjects = new EmptyNode(this, NbBundle.getMessage(DashboardImpl.class, (String)"NO_MY_PROJECTS"), NbBundle.getMessage(DashboardImpl.class, (String)"LBL_OpeningMyProjects"));
    private final Object LOCK = new Object();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private DashboardImpl() {
        this.dashboardComponent = new JScrollPane(){

            public void requestFocus() {
                Component component = this.getViewport().getView();
                if (component != null) {
                    component.requestFocus();
                } else {
                    super.requestFocus();
                }
            }

            public boolean requestFocusInWindow() {
                Component component = this.getViewport().getView();
                return component != null ? component.requestFocusInWindow() : super.requestFocusInWindow();
            }
        };
        this.dashboardComponent.setBorder(BorderFactory.createEmptyBorder());
        this.dashboardComponent.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.dashboardComponent.getViewport().setBackground(ColorManager.getDefault().getDefaultBackground());
        this.userListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("memberProjects".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.refreshMemberProjects();
                }
            }
        };
        Kenai kenai = Kenai.getDefault();
        kenai.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("login".equals(propertyChangeEvent.getPropertyName())) {
                    PasswordAuthentication passwordAuthentication = (PasswordAuthentication)propertyChangeEvent.getNewValue();
                    if (passwordAuthentication == null) {
                        DashboardImpl.this.setUser(null);
                    } else {
                        DashboardImpl.this.setUser(new LoginHandleImpl(passwordAuthentication.getUserName()));
                    }
                    DashboardImpl.this.loggingFinished();
                } else if ("login_started".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.loggingStarted();
                } else if ("login_failed".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.loggingFinished();
                } else if ("xmpp_login_started".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.xmppStarted();
                } else if ("xmpp_login".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                } else if ("xmpp_login_failed".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                }
            }
        });
        KenaiConnection.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("xmpp_started".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.xmppStarted();
                } else if ("xmpp_finished".equals(propertyChangeEvent.getPropertyName())) {
                    DashboardImpl.this.xmppFinsihed();
                }
            }
        });
        PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
        this.login = passwordAuthentication == null ? null : new LoginHandleImpl(passwordAuthentication.getUserName());
        this.userNode = new UserNode(this);
        this.userNode.set(this.login, false);
        this.model.addRoot(-1, this.userNode);
        this.openProjectsNode = new CategoryNode(this, NbBundle.getMessage(CategoryNode.class, (String)"LBL_OpenProjects"), null);
        this.model.addRoot(-1, this.openProjectsNode);
        this.model.addRoot(-1, this.noOpenProjects);
        this.myProjectsNode = new CategoryNode(this, NbBundle.getMessage(CategoryNode.class, (String)"LBL_MyProjects"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/bookmark.png", (boolean)true));
        if (this.login != null) {
            this.model.addRoot(-1, this.myProjectsNode);
            this.model.addRoot(-1, this.noMyProjects);
        }
        this.memberProjectsError = new ErrorNode(NbBundle.getMessage(DashboardImpl.class, (String)"ERR_OpenMemberProjects"), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DashboardImpl.this.clearError(DashboardImpl.this.memberProjectsError);
                DashboardImpl.this.refreshMemberProjects();
            }
        });
        this.otherProjectsError = new ErrorNode(NbBundle.getMessage(DashboardImpl.class, (String)"ERR_OpenProjects"), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DashboardImpl.this.clearError(DashboardImpl.this.otherProjectsError);
                DashboardImpl.this.refreshProjects();
            }
        });
    }

    public static DashboardImpl getInstance() {
        return Holder.theInstance;
    }

    @Override
    public ProjectHandle[] getOpenProjects() {
        TreeSet<ProjectHandle> treeSet = new TreeSet<ProjectHandle>();
        treeSet.addAll(this.openProjects);
        treeSet.addAll(this.memberProjects);
        return treeSet.toArray(new ProjectHandle[treeSet.size()]);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public boolean isMemberProject(ProjectHandle projectHandle) {
        return this.memberProjects.contains(projectHandle);
    }

    public void selectAndExpand(KenaiProject kenaiProject) {
        for (TreeListNode treeListNode : this.model.getRootNodes()) {
            if (!(treeListNode instanceof ProjectNode) || !((ProjectNode)treeListNode).getProject().getId().equals(kenaiProject.getName())) continue;
            this.treeList.setSelectedValue(treeListNode, true);
            treeListNode.setExpanded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(LoginHandle loginHandle) {
        Object object = this.LOCK;
        synchronized (object) {
            if (null != this.login) {
                this.login.removePropertyChangeListener(this.userListener);
            }
            this.login = loginHandle;
            if (loginHandle == null) {
                Iterator<ProjectHandle> iterator = this.openProjects.iterator();
                while (iterator.hasNext()) {
                    ProjectHandle projectHandle = iterator.next();
                    if (!projectHandle.isPrivate()) continue;
                    this.removeProjectsFromModel(Collections.singletonList(projectHandle));
                    iterator.remove();
                }
                this.removeMemberProjectsFromModel(this.memberProjects);
                this.memberProjects.clear();
                this.model.removeRoot(this.myProjectsNode);
                this.model.removeRoot(this.noMyProjects);
            } else {
                this.model.addRoot(-1, this.myProjectsNode);
                this.model.addRoot(-1, this.noMyProjects);
            }
            this.memberProjectsLoaded = false;
            this.userNode.set(loginHandle, !this.openProjects.isEmpty());
            if (this.isOpened()) {
                if (null != loginHandle) {
                    this.startLoadingMemberProjects(false);
                }
                this.switchContent();
            }
            if (null != this.login) {
                this.login.addPropertyChangeListener(this.userListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProject(final ProjectHandle projectHandle, boolean bl, boolean bl2) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.openProjects.contains(projectHandle)) {
                if (bl2) {
                    this.selectAndExpand(((ProjectHandleImpl)projectHandle).getKenaiProject());
                }
                return;
            }
            if (bl && this.memberProjectsLoaded && !this.memberProjects.contains(projectHandle)) {
                this.memberProjects.add(projectHandle);
                this.setMemberProjects(new ArrayList<ProjectHandle>(this.memberProjects));
            }
            this.openProjects.add(projectHandle);
            this.storeAllProjects();
            this.setOtherProjects(new ArrayList<ProjectHandle>(this.openProjects));
            this.userNode.set(this.login, !this.openProjects.isEmpty());
            this.switchMemberProjects();
            if (this.isOpened()) {
                this.switchContent();
                if (bl2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DashboardImpl.this.selectAndExpand(((ProjectHandleImpl)projectHandle).getKenaiProject());
                        }
                    });
                }
            }
        }
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProject(ProjectHandle projectHandle) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.openProjects.contains(projectHandle)) {
                return;
            }
            this.openProjects.remove(projectHandle);
            this.storeAllProjects();
            ArrayList<ProjectHandle> arrayList = new ArrayList<ProjectHandle>(1);
            arrayList.add(projectHandle);
            this.removeProjectsFromModel(arrayList);
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        projectHandle.firePropertyChange("close", null, null);
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    Action createLoginAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginAction.getDefault().actionPerformed(actionEvent);
            }
        };
    }

    private Action createWhatIsKenaiAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(NbBundle.getMessage(DashboardImpl.class, (String)"URL_KenaiOverview")));
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        };
    }

    boolean isOpened() {
        return this.opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshProjects() {
        this.myProjectLoadingStarted();
        this.projectLoadingStarted();
        this.changeSupport.firePropertyChange("refreshRequest", null, null);
        Object object = this.LOCK;
        synchronized (object) {
            this.removeMemberProjectsFromModel(this.memberProjects);
            this.memberProjects.clear();
            this.memberProjectsLoaded = false;
            this.removeProjectsFromModel(this.openProjects);
            this.openProjects.clear();
            this.otherProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingAllProjects(true);
                this.startLoadingMemberProjects(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNonMemberProjects() {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeProjectsFromModel(this.openProjects);
            this.openProjects.clear();
            this.otherProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingAllProjects(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMemberProjects() {
        Object object = this.LOCK;
        synchronized (object) {
            this.memberProjects.clear();
            this.memberProjectsLoaded = false;
            if (this.isOpened()) {
                this.startLoadingMemberProjects(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK;
        synchronized (object) {
            this.treeList.setModel(EMPTY_MODEL);
            this.model.clear();
            this.opened = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.opened = true;
            this.requestProcessor.post(new Runnable(){

                public void run() {
                    UIUtils.waitStartupFinished();
                    DashboardImpl.this.myProjectLoadingStarted();
                    DashboardImpl.this.projectLoadingStarted();
                    if (null != DashboardImpl.this.login && !DashboardImpl.this.memberProjectsLoaded) {
                        DashboardImpl.this.startLoadingMemberProjects(false);
                    }
                    if (!DashboardImpl.this.otherProjectsLoaded) {
                        DashboardImpl.this.startLoadingAllProjects(false);
                    }
                }
            });
            this.switchContent();
        }
        return this.dashboardComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillModel() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.model.getRootNodes().contains(this.userNode)) {
                this.model.addRoot(0, this.userNode);
                this.model.addRoot(1, this.openProjectsNode);
                if (this.login != null && !this.model.getRootNodes().contains(this.myProjectsNode)) {
                    this.model.addRoot(-1, this.myProjectsNode);
                }
            }
            if (this.login != null ? this.model.getSize() > 3 : this.model.getSize() > 2) {
                return;
            }
            this.addProjectsToModel(-1, this.openProjects);
            this.addMemberProjectsToModel(-1, this.memberProjects);
        }
    }

    private void switchContent() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl;
                boolean bl2 = true;
                Object object = DashboardImpl.this.LOCK;
                synchronized (object) {
                    bl2 = null == DashboardImpl.this.login && DashboardImpl.this.openProjects.isEmpty();
                }
                boolean bl3 = bl = DashboardImpl.this.dashboardComponent.getViewport().getView() == DashboardImpl.this.treeList;
                if (bl2) {
                    if (bl || DashboardImpl.this.dashboardComponent.getViewport().getView() == null) {
                        DashboardImpl.this.dashboardComponent.setViewportView(DashboardImpl.this.createEmptyContent());
                        DashboardImpl.this.dashboardComponent.invalidate();
                        DashboardImpl.this.dashboardComponent.revalidate();
                        DashboardImpl.this.dashboardComponent.repaint();
                    }
                } else {
                    DashboardImpl.this.fillModel();
                    DashboardImpl.this.treeList.setModel(DashboardImpl.this.model);
                    DashboardImpl.this.switchMemberProjects();
                    if (!bl) {
                        DashboardImpl.this.dashboardComponent.setViewportView(DashboardImpl.this.treeList);
                        DashboardImpl.this.dashboardComponent.invalidate();
                        DashboardImpl.this.dashboardComponent.revalidate();
                        DashboardImpl.this.dashboardComponent.repaint();
                        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, DashboardImpl.this.dashboardComponent);
                        if (topComponent != null && TopComponent.getRegistry().getActivated() == topComponent) {
                            DashboardImpl.this.treeList.requestFocus();
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private JComponent createEmptyContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        TreeLabel treeLabel = new TreeLabel(NbBundle.getMessage(DashboardImpl.class, (String)"LBL_No_Kenai_Project_Open"));
        treeLabel.setForeground(ColorManager.getDefault().getDisabledColor());
        treeLabel.setHorizontalAlignment(0);
        LinkButton linkButton = new LinkButton(NbBundle.getMessage(DashboardImpl.class, (String)"LBL_WhatIsKenai"), this.createWhatIsKenaiAction());
        this.model.removeRoot(this.userNode);
        this.model.removeRoot(this.myProjectsNode);
        this.model.removeRoot(this.openProjectsNode);
        this.userNode.set(null, false);
        jPanel.add((Component)this.userNode.getComponent(UIManager.getColor("List.foreground"), ColorManager.getDefault().getDefaultBackground(), false, false), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 4, 3, 4), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)treeLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 4, 0), 0, 0));
        jPanel.add((Component)linkButton, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(4, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 4, 3, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingAllProjects(boolean bl) {
        String string = Kenai.getDefault().getUrl().getHost();
        Preferences preferences = NbPreferences.forModule(DashboardImpl.class).node(PREF_ALL_PROJECTS + ("kenai.com".equals(string) ? "" : "-" + string));
        int n = preferences.getInt(PREF_COUNT, 0);
        if (0 == n) {
            this.projectLoadingFinished();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = preferences.get(PREF_ID + i, null);
            if (null == string2 || string2.trim().length() <= 0) continue;
            arrayList.add(string2.trim());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.otherProjectsLoader != null) {
                this.otherProjectsLoader.cancel();
            }
            if (arrayList.isEmpty()) {
                this.projectLoadingFinished();
                return;
            }
            this.otherProjectsLoader = new OtherProjectsLoader(arrayList, bl);
            this.requestProcessor.post((Runnable)this.otherProjectsLoader);
        }
    }

    private void storeAllProjects() {
        String string = Kenai.getDefault().getUrl().getHost();
        Preferences preferences = NbPreferences.forModule(DashboardImpl.class).node(PREF_ALL_PROJECTS + ("kenai.com".equals(string) ? "" : "-" + string));
        int n = 0;
        for (ProjectHandle projectHandle : this.openProjects) {
            preferences.put(PREF_ID + n++, projectHandle.getId());
        }
        preferences.putInt(PREF_COUNT, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOtherProjects(ArrayList<ProjectHandle> arrayList) {
        Object object = this.LOCK;
        synchronized (object) {
            this.removeProjectsFromModel(this.openProjects);
            if (!arrayList.isEmpty()) {
                this.model.removeRoot(this.noOpenProjects);
            }
            this.openProjects.clear();
            for (ProjectHandle projectHandle : arrayList) {
                if (this.openProjects.contains(projectHandle)) continue;
                this.openProjects.add(projectHandle);
            }
            Collections.sort(this.openProjects);
            this.otherProjectsLoaded = true;
            this.addProjectsToModel(-1, this.openProjects);
            this.userNode.set(this.login, !this.openProjects.isEmpty());
            this.storeAllProjects();
            this.switchMemberProjects();
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    private void switchMemberProjects() {
        for (TreeListNode treeListNode : this.model.getRootNodes()) {
            if (!(treeListNode instanceof ProjectNode)) continue;
            ProjectNode projectNode = (ProjectNode)treeListNode;
            projectNode.setMemberProject(this.memberProjects.contains(projectNode.getProject()));
        }
    }

    private void loggingStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_Authenticating"));
    }

    private void loggingFinished() {
        this.userNode.loadingFinished();
    }

    private void xmppStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_ConnectingXMPP"));
    }

    private void xmppFinsihed() {
        this.userNode.loadingFinished();
    }

    private void projectLoadingStarted() {
        this.noOpenProjects.loadingStarted();
    }

    private void projectLoadingFinished() {
        this.noOpenProjects.loadingFinished();
    }

    private void myProjectLoadingStarted() {
        this.noMyProjects.loadingStarted();
    }

    private void myProjectLoadingFinished() {
        this.noMyProjects.loadingFinished();
    }

    void myProjectsProgressStarted() {
        this.userNode.loadingStarted(NbBundle.getMessage(UserNode.class, (String)"LBL_LoadingIssues"));
    }

    void myProjectsProgressFinished() {
        this.userNode.loadingFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingMemberProjects(boolean bl) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.memberProjectsLoader != null) {
                this.memberProjectsLoader.cancel();
            }
            if (null == this.login) {
                return;
            }
            this.memberProjectsLoader = new MemberProjectsLoader(this.login, bl);
            this.requestProcessor.post((Runnable)this.memberProjectsLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemberProjects(ArrayList<ProjectHandle> arrayList) {
        Object object = this.LOCK;
        synchronized (object) {
            if (arrayList.isEmpty() && this.isOpened()) {
                this.switchContent();
            }
            this.removeMemberProjectsFromModel(this.memberProjects);
            if (!arrayList.isEmpty()) {
                this.model.removeRoot(this.noMyProjects);
            }
            this.memberProjects.clear();
            this.memberProjects.addAll(arrayList);
            this.memberProjectsLoaded = true;
            for (ProjectHandle projectHandle : arrayList) {
                if (this.memberProjects.contains(projectHandle)) continue;
                this.memberProjects.add(projectHandle);
            }
            Collections.sort(this.memberProjects);
            this.addMemberProjectsToModel(-1, this.memberProjects);
            this.userNode.set(this.login, !this.memberProjects.isEmpty());
            this.switchMemberProjects();
            if (this.isOpened()) {
                this.switchContent();
            }
        }
        this.changeSupport.firePropertyChange("openedProjects", null, null);
    }

    private void addProjectsToModel(int n, List<ProjectHandle> list) {
        int n2 = 2;
        for (ProjectHandle projectHandle : list) {
            this.model.addRoot(n2++, new ProjectNode(projectHandle));
        }
    }

    private void addMemberProjectsToModel(int n, List<ProjectHandle> list) {
        for (ProjectHandle projectHandle : list) {
            this.model.addRoot(n, new MyProjectNode(projectHandle));
        }
    }

    private void removeProjectsFromModel(List<ProjectHandle> list) {
        ArrayList<TreeListNode> arrayList = new ArrayList<TreeListNode>(list.size());
        int n = 0;
        for (TreeListNode treeListNode : this.model.getRootNodes()) {
            if (!(treeListNode instanceof ProjectNode)) continue;
            ProjectNode projectNode = (ProjectNode)treeListNode;
            ++n;
            if (!list.contains(projectNode.getProject())) continue;
            arrayList.add(treeListNode);
        }
        for (TreeListNode treeListNode : arrayList) {
            this.model.removeRoot(treeListNode);
        }
        if (n == list.size() && !this.model.getRootNodes().contains(this.noOpenProjects)) {
            this.model.addRoot(2, this.noOpenProjects);
        }
    }

    private void removeMemberProjectsFromModel(List<ProjectHandle> list) {
        ArrayList<TreeListNode> arrayList = new ArrayList<TreeListNode>(list.size());
        int n = 0;
        for (TreeListNode treeListNode : this.model.getRootNodes()) {
            if (!(treeListNode instanceof MyProjectNode)) continue;
            MyProjectNode myProjectNode = (MyProjectNode)treeListNode;
            ++n;
            if (!list.contains(myProjectNode.getProject())) continue;
            arrayList.add(treeListNode);
        }
        for (TreeListNode treeListNode : arrayList) {
            this.model.removeRoot(treeListNode);
        }
        if (n == list.size() && !this.model.getRootNodes().contains(this.noMyProjects) && this.login != null) {
            this.model.addRoot(-1, this.noMyProjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showError(ErrorNode errorNode) {
        Object object = this.LOCK;
        synchronized (object) {
            List<TreeListNode> list = this.model.getRootNodes();
            if (!list.contains(errorNode)) {
                this.model.addRoot(1, errorNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearError(ErrorNode errorNode) {
        Object object = this.LOCK;
        synchronized (object) {
            this.model.removeRoot(errorNode);
        }
    }

    private class MemberProjectsLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;
        private final LoginHandle user;
        private boolean forceRefresh;

        public MemberProjectsLoader(LoginHandle loginHandle, boolean bl) {
            this.user = loginHandle;
            this.forceRefresh = bl;
        }

        public void run() {
            DashboardImpl.this.myProjectLoadingStarted();
            final ArrayList[] arrayListArray = new ArrayList[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    ProjectAccessor projectAccessor = ProjectAccessor.getDefault();
                    arrayListArray[0] = new ArrayList<ProjectHandle>(projectAccessor.getMemberProjects(MemberProjectsLoader.this.user, MemberProjectsLoader.this.forceRefresh));
                }
            };
            this.t = new Thread(runnable);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DashboardImpl.this.myProjectLoadingFinished();
            DashboardImpl.this.myProjectLoadingFinished();
            if (this.cancelled) {
                return;
            }
            if (null == arrayListArray[0]) {
                DashboardImpl.this.showError(DashboardImpl.this.memberProjectsError);
                return;
            }
            DashboardImpl.this.setMemberProjects(arrayListArray[0]);
            DashboardImpl.this.clearError(DashboardImpl.this.memberProjectsError);
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OtherProjectsLoader
    implements Runnable,
    Cancellable {
        private boolean cancelled = false;
        private Thread t = null;
        private final ArrayList<String> projectIds;
        private boolean forceRefresh;

        public OtherProjectsLoader(ArrayList<String> arrayList, boolean bl) {
            this.projectIds = arrayList;
            this.forceRefresh = bl;
        }

        @Override
        public void run() {
            DashboardImpl.this.projectLoadingStarted();
            final ArrayList[] arrayListArray = new ArrayList[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    ArrayList<ProjectHandle> arrayList = new ArrayList<ProjectHandle>(OtherProjectsLoader.this.projectIds.size());
                    ProjectAccessor projectAccessor = ProjectAccessor.getDefault();
                    for (String string : OtherProjectsLoader.this.projectIds) {
                        ProjectHandle projectHandle = projectAccessor.getNonMemberProject(string, OtherProjectsLoader.this.forceRefresh);
                        if (projectHandle == null) continue;
                        arrayList.add(projectHandle);
                    }
                    arrayListArray[0] = arrayList;
                }
            };
            this.t = new Thread(runnable);
            this.t.start();
            try {
                this.t.join(TIMEOUT_INTERVAL_MILLIS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DashboardImpl.this.projectLoadingFinished();
            DashboardImpl.this.projectLoadingFinished();
            if (this.cancelled) {
                return;
            }
            if (null == arrayListArray[0]) {
                DashboardImpl.this.showError(DashboardImpl.this.otherProjectsError);
                return;
            }
            DashboardImpl.this.setOtherProjects(arrayListArray[0]);
            DashboardImpl.this.clearError(DashboardImpl.this.otherProjectsError);
        }

        public boolean cancel() {
            this.cancelled = true;
            if (null != this.t) {
                this.t.interrupt();
            }
            return true;
        }
    }

    private static class Holder {
        private static final DashboardImpl theInstance = new DashboardImpl();

        private Holder() {
        }
    }
}

