/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.ui.GetSourcesFromKenaiPanel;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.system.cvss.api.CVS;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class GetSourcesFromKenaiAction
extends AbstractAction {
    private SourceAccessorImpl.ProjectAndFeature prjAndFeature;
    private SourceHandleImpl srcHandle;
    private String dialogTitle = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiTitle");
    private String getOption = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiAction.GetFromKenai.option");
    private String cancelOption = NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"GetSourcesFromKenaiAction.Cancel.option");

    public GetSourcesFromKenaiAction(SourceAccessorImpl.ProjectAndFeature projectAndFeature, SourceHandle sourceHandle) {
        this.prjAndFeature = projectAndFeature;
        this.srcHandle = (SourceHandleImpl)sourceHandle;
    }

    public GetSourcesFromKenaiAction() {
        this((SourceAccessorImpl.ProjectAndFeature)null, (SourceHandle)null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.prjAndFeature != null && "external_repository".equals(this.prjAndFeature.feature.getService())) {
            this.tryExternalCheckout(this.prjAndFeature.feature.getLocation());
            return;
        }
        if (this.prjAndFeature != null && "subversion".equals(this.prjAndFeature.feature.getService()) && !Subversion.isClientAvailable((boolean)true)) {
            return;
        }
        Object[] objectArray = new Object[]{this.getOption, this.cancelOption};
        KenaiTopComponent.findInstance().open();
        KenaiTopComponent.findInstance().requestActive();
        GetSourcesFromKenaiPanel getSourcesFromKenaiPanel = new GetSourcesFromKenaiPanel(this.prjAndFeature);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)getSourcesFromKenaiPanel, this.dialogTitle, true, objectArray, objectArray[0], 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (objectArray[0].equals(object)) {
            final PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
            final GetSourcesFromKenaiPanel.GetSourcesInfo getSourcesInfo = getSourcesFromKenaiPanel.getSelectedSourcesInfo();
            if (getSourcesInfo == null) {
                return;
            }
            final KenaiFeature kenaiFeature = getSourcesInfo.feature;
            if ("subversion".equals(kenaiFeature.getService())) {
                if (Subversion.isClientAvailable((boolean)true)) {
                    UIUtils.logKenaiUsage("KENAI_SVN_CHECKOUT");
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                if (passwordAuthentication != null) {
                                    Subversion.checkoutRepositoryFolder((String)kenaiFeature.getLocation(), (String[])getSourcesInfo.relativePaths, (File)new File(getSourcesInfo.localFolderPath), (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (boolean)true);
                                } else {
                                    Subversion.checkoutRepositoryFolder((String)kenaiFeature.getLocation(), (String[])getSourcesInfo.relativePaths, (File)new File(getSourcesInfo.localFolderPath), (boolean)true);
                                }
                                if (GetSourcesFromKenaiAction.this.srcHandle != null) {
                                    GetSourcesFromKenaiAction.this.srcHandle.refresh();
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                            }
                            catch (IOException iOException) {
                                if ("SVN client unavailable".equals(iOException.getMessage())) {
                                    // empty if block
                                }
                            }
                        }
                    });
                }
            } else if ("mercurial".equals(kenaiFeature.getService())) {
                UIUtils.logKenaiUsage("KENAI_HG_CLONE");
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            if (passwordAuthentication != null) {
                                Mercurial.cloneRepository((String)kenaiFeature.getLocation(), (File)new File(getSourcesInfo.localFolderPath), (String)"", (String)"", (String)"", (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword()), (boolean)true);
                            } else {
                                Mercurial.cloneRepository((String)kenaiFeature.getLocation(), (File)new File(getSourcesInfo.localFolderPath), (String)"", (String)"", (String)"", (boolean)true);
                            }
                            if (GetSourcesFromKenaiAction.this.srcHandle != null) {
                                GetSourcesFromKenaiAction.this.srcHandle.refresh();
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                    }
                });
            }
        }
    }

    private void tryExternalCheckout(String string) {
        block6: {
            try {
                if ("subversion".equals(this.prjAndFeature.externalScmType)) {
                    Subversion.openCheckoutWizard((String)string);
                    return;
                }
                if ("cvs".equals(this.prjAndFeature.externalScmType)) {
                    CVS.openCheckoutWizard((String)string);
                    return;
                }
                if ("mercurial".equals(this.prjAndFeature.externalScmType)) {
                    Mercurial.openCloneWizard((String)string);
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(GetSourcesFromKenaiAction.class.getName()).log(Level.INFO, "Cannot checkout external repository " + string, malformedURLException);
            }
            catch (IOException iOException) {
                if (!"SVN client unavailable".equals(iOException.getMessage())) break block6;
                return;
            }
        }
        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"MSG_ScmNotRecognized", (Object)string), NbBundle.getMessage(GetSourcesFromKenaiAction.class, (String)"MSG_ScmNotRecognizedTitle"), 1);
    }
}

