/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.actions.AttachWindowAction;
import org.netbeans.jellytools.actions.CloneViewAction;
import org.netbeans.jellytools.actions.CloseAllDocumentsAction;
import org.netbeans.jellytools.actions.CloseViewAction;
import org.netbeans.jellytools.actions.MaximizeWindowAction;
import org.netbeans.jellytools.actions.RestoreWindowAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightDriver;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class TopComponentOperator
extends JComponentOperator {
    private static final String closeWindowItem = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_CloseWindowAction");
    private static final String closeAllDocumentsItem = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_CloseAllDocumentsAction");

    public TopComponentOperator(ContainerOperator containerOperator, String string, int n) {
        super(TopComponentOperator.waitTopComponent(containerOperator, string, n, null));
        this.copyEnvironment((Operator)containerOperator);
        this.makeComponentVisible();
    }

    public TopComponentOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public TopComponentOperator(ContainerOperator containerOperator, int n) {
        this(containerOperator, null, n);
    }

    public TopComponentOperator(ContainerOperator containerOperator) {
        this(containerOperator, null, 0);
    }

    public TopComponentOperator(String string, int n) {
        this(TopComponentOperator.waitTopComponent(string, n));
    }

    public TopComponentOperator(String string) {
        this(string, 0);
    }

    public TopComponentOperator(JComponent jComponent) {
        super(jComponent);
        this.makeComponentVisible();
    }

    public void makeComponentVisible() {
        super.makeComponentVisible();
        if (this.getSource() instanceof TopComponent) {
            this.runMapping(new Operator.MapVoidAction("requestActive"){

                public void map() {
                    ((TopComponent)TopComponentOperator.this.getSource()).requestActive();
                }
            });
        }
    }

    public void attachTo(String string, String string2) {
        new AttachWindowAction(string, string2).perform((ComponentOperator)this);
    }

    public void attachTo(TopComponentOperator topComponentOperator, String string) {
        new AttachWindowAction(topComponentOperator, string).perform((ComponentOperator)this);
    }

    public void maximize() {
        new MaximizeWindowAction().perform((ComponentOperator)this);
    }

    public void restore() {
        new RestoreWindowAction().perform((ComponentOperator)this);
    }

    public void cloneDocument() {
        new CloneViewAction().perform((ComponentOperator)this);
    }

    public void closeWindow() {
        if (this.isModified()) {
            new Thread(new Runnable(){

                public void run() {
                    TopComponentOperator.this.pushMenuOnTab(closeWindowItem);
                }
            }, "thread to close TopComponent").start();
        } else {
            new CloseViewAction().perform((ComponentOperator)this);
            this.waitComponentShowing(false);
        }
    }

    public void closeDiscard() {
        this.setUnmodified();
        this.close();
    }

    public void setUnmodified() {
        TopComponentOperator topComponentOperator;
        Node[] nodeArray = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodeArray == null && (topComponentOperator = this.findParentTopComponent()) != null) {
            topComponentOperator.setUnmodified();
        }
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                dataObject.setModified(false);
            }
        }
    }

    public boolean isModified() {
        TopComponentOperator topComponentOperator;
        Node[] nodeArray = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodeArray == null && (topComponentOperator = this.findParentTopComponent()) != null) {
            return topComponentOperator.isModified();
        }
        boolean bl = false;
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
                if (dataObject == null) continue;
                bl = bl || dataObject.isModified();
            }
        }
        return bl;
    }

    public void save() {
        TopComponentOperator topComponentOperator;
        Node[] nodeArray = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodeArray == null && (topComponentOperator = this.findParentTopComponent()) != null) {
            topComponentOperator.save();
        }
        if (nodeArray != null) {
            for (int i = 0; i < nodeArray.length; ++i) {
                SaveCookie saveCookie = (SaveCookie)nodeArray[i].getCookie(SaveCookie.class);
                if (saveCookie == null) continue;
                try {
                    saveCookie.save();
                    continue;
                }
                catch (IOException iOException) {
                    throw new JemmyException("Exception while saving this TopComponent.", (Throwable)iOException);
                }
            }
        }
    }

    public void close() {
        if (this.isModified()) {
            this.closeWindow();
        } else {
            if (this.isOpened()) {
                this.runMapping(new Operator.MapVoidAction("close"){

                    public void map() {
                        ((TopComponent)TopComponentOperator.this.getSource()).close();
                    }
                });
            } else {
                TopComponentOperator topComponentOperator = this.findParentTopComponent();
                if (topComponentOperator != null) {
                    topComponentOperator.close();
                }
            }
            this.waitComponentShowing(false);
        }
    }

    public void closeAllDocuments() {
        DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
        if (dataObjectArray.length != 0) {
            new Thread(new Runnable(){

                public void run() {
                    TopComponentOperator.this.pushMenuOnTab(closeAllDocumentsItem);
                }
            }, "thread to closeAllDocuments").start();
        } else {
            new CloseAllDocumentsAction().perform((ComponentOperator)this);
            this.waitComponentShowing(false);
        }
    }

    public void saveDocument() {
        String string = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_SaveDocumentAction");
        this.pushMenuOnTab(string);
    }

    public static JComponent findTopComponent(String string, int n) {
        return TopComponentOperator.findTopComponent(null, string, n, null);
    }

    protected static JComponent findTopComponent(final ContainerOperator containerOperator, final String string, final int n, final ComponentChooser componentChooser) {
        return (JComponent)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findTopComponent"){

            public Object launch() {
                JComponent jComponent;
                TopComponent topComponent;
                int n3;
                int n2 = n;
                Object[] objectArray = TopComponent.getRegistry().getOpened().toArray();
                Operator.StringComparator stringComparator = containerOperator == null ? Operator.getDefaultStringComparator() : containerOperator.getComparator();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    topComponent = (TopComponent)objectArray[n3];
                    if (!topComponent.isShowing() || !stringComparator.equals(topComponent.getName(), string) && !stringComparator.equals(topComponent.getDisplayName(), string) || !TopComponentOperator.isUnder(containerOperator, (Component)topComponent) || (jComponent = TopComponentOperator.checkSubchooser(topComponent, componentChooser)) == null || --n2 >= 0) continue;
                    return jComponent;
                }
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    topComponent = (TopComponent)objectArray[n3];
                    if (topComponent.isShowing() || !TopComponentOperator.isParentShowing((Component)topComponent) || !stringComparator.equals(topComponent.getName(), string) && !stringComparator.equals(topComponent.getDisplayName(), string) || !TopComponentOperator.isUnder(containerOperator, (Component)topComponent) || (jComponent = TopComponentOperator.checkSubchooser(topComponent, componentChooser)) == null || --n2 >= 0) continue;
                    return jComponent;
                }
                return null;
            }
        });
    }

    private static JComponent checkSubchooser(TopComponent topComponent, ComponentChooser componentChooser) {
        if (componentChooser == null) {
            return topComponent;
        }
        boolean bl = false;
        try {
            bl = TopComponentOperator.isMultyView(topComponent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (bl) {
            TopComponentOperator topComponentOperator = new TopComponentOperator((JComponent)topComponent);
            topComponentOperator.setOutput(TestOut.getNullOutput());
            return (JComponent)topComponentOperator.findSubComponent(componentChooser);
        }
        if (componentChooser.checkComponent((Component)topComponent)) {
            return topComponent;
        }
        return null;
    }

    private static boolean isMultyView(TopComponent topComponent) {
        Class<?> clazz = topComponent.getClass();
        do {
            if (!clazz.getName().equals("org.netbeans.core.multiview.MultiViewCloneableTopComponent")) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    private static boolean isParentShowing(Component component) {
        while (component != null) {
            if (component.isShowing()) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private static boolean isUnder(ContainerOperator containerOperator, Component component) {
        if (containerOperator == null) {
            return true;
        }
        Component component2 = containerOperator.getSource();
        while (component2 != component && component != null) {
            component = component.getParent();
        }
        return component2 == component;
    }

    protected static JComponent waitTopComponent(String string, int n) {
        return TopComponentOperator.waitTopComponent(null, string, n, null);
    }

    protected static JComponent waitTopComponent(final ContainerOperator containerOperator, final String string, final int n, final ComponentChooser componentChooser) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return TopComponentOperator.findTopComponent(containerOperator, string, n, componentChooser);
                }

                public String getDescription() {
                    return "Wait TopComponent with name=" + string + " index=" + String.valueOf(n) + (componentChooser == null ? "" : " subchooser=" + componentChooser.getDescription()) + " loaded";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void pushMenuOnTab(String string) {
        if (this.isOpened()) {
            this.makeComponentVisible();
            TabbedContainer tabbedContainer = this.findTabbedAdapter();
            int n = tabbedContainer.indexOf((Component)((TopComponent)this.getSource()));
            Rectangle rectangle = new Rectangle();
            tabbedContainer.getTabRect(n, rectangle);
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            Component component = tabbedContainer.getComponentAt(point);
            new JPopupMenuOperator(JPopupMenuOperator.callPopup((Component)component, (int)point.x, (int)point.y)).pushMenu(string);
        } else {
            TopComponentOperator topComponentOperator = this.findParentTopComponent();
            if (topComponentOperator != null) {
                topComponentOperator.pushMenuOnTab(string);
            }
        }
    }

    public TabbedContainer findTabbedAdapter() {
        for (Container container = this.getSource().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof TabbedContainer)) continue;
            return (TabbedContainer)container;
        }
        return null;
    }

    public Container findTabDisplayer() {
        return ContainerOperator.findContainer((Container)this.findTabbedAdapter(), (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component.getClass().getName().endsWith("TabDisplayer");
            }

            public String getDescription() {
                return "org.netbeans.swing.tabcontrol.TabDisplayer";
            }
        });
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait topcomponent to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait topcomponent to be closed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return !component.isVisible();
            }

            public String getDescription() {
                return "Closed topcomponent";
            }
        });
    }

    protected boolean isOpened() {
        return this.runMapping(new Operator.MapBooleanAction("isOpened"){

            public boolean map() {
                return ((TopComponent)TopComponentOperator.this.getSource()).isOpened();
            }
        });
    }

    protected TopComponentOperator findParentTopComponent() {
        for (Container container = this.getSource().getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof TopComponent)) continue;
            return new TopComponentOperator((JComponent)container);
        }
        return null;
    }

    static {
        JellyVersion.checkJemmyVersion();
        JemmyProperties.getCurrentTimeouts();
        Timeouts.initDefault((String)"EventDispatcher.RobotAutoDelay", (long)0L);
        DriverManager.setDriver((String)"drivers.mouse", (LightDriver)new MouseRobotDriver(JemmyProperties.getCurrentTimeouts().create("EventDispatcher.RobotAutoDelay"), new String[]{TopComponentOperator.class.getName()}));
    }
}

