/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.actions;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultEditorKit;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.modules.editor.lib2.actions.EditorActionUtilities;
import org.netbeans.modules.editor.lib2.actions.SearchableEditorKit;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class SearchableEditorKitImpl
extends DefaultEditorKit
implements SearchableEditorKit {
    private static final Logger LOG = Logger.getLogger(SearchableEditorKitImpl.class.getName());
    private final String mimeType;
    private final Map<String, Action> name2Action = new HashMap<String, Action>();
    private Action[] actions;
    private LookupListener actionsListener;
    private ListenerList<ChangeListener> listenerList = new ListenerList();

    SearchableEditorKitImpl(String string) {
        this.mimeType = string;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("SearchableEditorKitImpl created for \"" + string + "\"\n");
        }
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action getAction(String string) {
        Map<String, Action> map = this.name2Action;
        synchronized (map) {
            return this.name2Action.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActions() {
        Map<String, Action> map = this.name2Action;
        synchronized (map) {
            Lookup.Result<Action> result = EditorActionUtilities.createActionsLookupResult(this.mimeType);
            Collection collection = result.allInstances();
            this.actions = new Action[collection.size()];
            collection.toArray(this.actions);
            this.name2Action.clear();
            for (Action action : this.actions) {
                String string;
                if (action == null || (string = (String)action.getValue("Name")) == null) continue;
                this.name2Action.put(string, action);
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.finer("Mime-type: \"" + this.mimeType + "\", registerAction(\"" + string + "\", " + action + ")\n");
            }
            if (this.actionsListener == null) {
                this.actionsListener = new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        SearchableEditorKitImpl.this.updateActions();
                    }
                };
                result.addLookupListener(this.actionsListener);
            }
        }
        this.fireActionsChange();
    }

    public String getContentType() {
        return this.mimeType;
    }

    public void addActionsChangeListener(ChangeListener changeListener) {
        this.listenerList.add((EventListener)changeListener);
    }

    public void removeActionsChangeListener(ChangeListener changeListener) {
        this.listenerList.remove((EventListener)changeListener);
    }

    private void fireActionsChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listenerList.getListeners()) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

