/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.lib2.actions.SearchableEditorKit;
import org.netbeans.modules.editor.lib2.actions.SearchableEditorKitImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorActionUtilities {
    private static final Logger LOG = Logger.getLogger(EditorActionUtilities.class.getName());
    private static Map<String, Map<String, KeyStroke>> mimeType2actionName2KeyStroke;
    private static Map<String, Boolean> mimeType2ListenerPresent;
    private static SearchableEditorKit globalActionsKit;
    private static final Map<EditorKit, SearchableEditorKit> kit2searchable;

    private EditorActionUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchableEditorKit getGlobalActionsKit() {
        Class<EditorActionUtilities> clazz = EditorActionUtilities.class;
        synchronized (EditorActionUtilities.class) {
            if (globalActionsKit == null) {
                globalActionsKit = new SearchableEditorKitImpl("");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalActionsKit;
        }
    }

    public static EditorKit getKit(String string) {
        Lookup.Result result = MimeLookup.getLookup((String)string).lookupResult(EditorKit.class);
        Iterator iterator = result.allInstances().iterator();
        EditorKit editorKit = iterator.hasNext() ? (EditorKit)iterator.next() : null;
        return editorKit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSearchableKit(EditorKit editorKit, SearchableEditorKit searchableEditorKit) {
        Map<EditorKit, SearchableEditorKit> map = kit2searchable;
        synchronized (map) {
            kit2searchable.put(editorKit, searchableEditorKit);
        }
    }

    public static Action getAction(EditorKit editorKit, String string) {
        return EditorActionUtilities.getSearchableKit(editorKit).getAction(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchableEditorKit getSearchableKit(EditorKit editorKit) {
        SearchableEditorKit searchableEditorKit;
        if (editorKit instanceof SearchableEditorKit) {
            searchableEditorKit = (SearchableEditorKit)((Object)editorKit);
        } else {
            Map<EditorKit, SearchableEditorKit> map = kit2searchable;
            synchronized (map) {
                searchableEditorKit = kit2searchable.get(editorKit);
                if (searchableEditorKit == null) {
                    searchableEditorKit = new DefaultSearchableKit(editorKit);
                    EditorActionUtilities.registerSearchableKit(editorKit, searchableEditorKit);
                }
            }
        }
        return searchableEditorKit;
    }

    public static Lookup.Result<Action> createActionsLookupResult(String string) {
        if (!MimePath.validate((CharSequence)string)) {
            throw new IllegalArgumentException("\u00cfnvalid mimeType=\"" + string + "\"");
        }
        Lookup lookup = Lookups.forPath((String)EditorActionUtilities.getPath(string, "Actions"));
        return lookup.lookupResult(Action.class);
    }

    private static String getPath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("Editors/");
        if (string.length() > 0) {
            stringBuilder.append('/').append(string);
        }
        if (string2.length() > 0) {
            stringBuilder.append('/').append(string2);
        }
        return stringBuilder.toString();
    }

    public static Preferences getGlobalPreferences() {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.EMPTY);
        return lookup != null ? (Preferences)lookup.lookup(Preferences.class) : null;
    }

    public static KeyStroke getAccelerator(FileObject fileObject) {
        if (fileObject == null) {
            throw new IllegalArgumentException("Must be called with non-null fileObject");
        }
        boolean bl = LOG.isLoggable(Level.FINE);
        String string = fileObject.getParent().getPath();
        String string2 = (String)fileObject.getAttribute("Name");
        KeyStroke keyStroke = null;
        if (string.startsWith("Editors/")) {
            if ((string = string.substring(7)).endsWith("/Actions")) {
                String string3;
                if ((string = string.substring(0, string.length() - 8)).startsWith("/")) {
                    string = string.substring(1);
                }
                if (!MimePath.validate((CharSequence)(string3 = string))) {
                    LOG.info("Invalid mime-type='" + string3 + "' of action's fileObject=" + fileObject);
                }
                keyStroke = EditorActionUtilities.getAccelerator(string3, string2);
            } else if (bl) {
                LOG.fine("No \"/Actions\" at end of mime-type='" + string + "' of action's fileObject=" + fileObject);
            }
        } else if (bl) {
            LOG.fine("No \"Editors/\" at begining of mime-type='" + string + "' of action's fileObject=" + fileObject);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Accelerator for action \"" + string2 + "\" is " + keyStroke);
        }
        return keyStroke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStroke getAccelerator(String string, String string2) {
        KeyStroke keyStroke = null;
        if (string2 == null) return keyStroke;
        Class<EditorActionUtilities> clazz = EditorActionUtilities.class;
        synchronized (EditorActionUtilities.class) {
            Map<String, KeyStroke> map;
            if (mimeType2actionName2KeyStroke == null) {
                mimeType2actionName2KeyStroke = new HashMap<String, Map<String, KeyStroke>>();
            }
            if ((map = mimeType2actionName2KeyStroke.get(string)) != null) return map.get(string2);
            map = new HashMap<String, KeyStroke>();
            Lookup.Result result = MimeLookup.getLookup((String)string).lookupResult(KeyBindingSettings.class);
            Collection collection = result.allInstances();
            if (!collection.isEmpty()) {
                KeyBindingSettings keyBindingSettings = (KeyBindingSettings)collection.iterator().next();
                for (MultiKeyBinding multiKeyBinding : keyBindingSettings.getKeyBindings()) {
                    if (map.containsKey(multiKeyBinding.getActionName()) || multiKeyBinding.getKeyStrokeCount() != 1) continue;
                    map.put(multiKeyBinding.getActionName(), multiKeyBinding.getKeyStroke(0));
                }
            }
            mimeType2actionName2KeyStroke.put(string, map);
            if (Boolean.TRUE.equals(mimeType2ListenerPresent.get(string))) return map.get(string2);
            mimeType2ListenerPresent.put(string, true);
            result.addLookupListener((LookupListener)KeyBindingSettingsListener.INSTANCE);
            return map.get(string2);
        }
    }

    static {
        mimeType2ListenerPresent = new HashMap<String, Boolean>();
        kit2searchable = new WeakHashMap<EditorKit, SearchableEditorKit>();
    }

    private static final class DefaultSearchableKit
    implements SearchableEditorKit {
        private final Map<String, Reference<Action>> name2actionRef = new WeakHashMap<String, Reference<Action>>();

        DefaultSearchableKit(EditorKit editorKit) {
            for (Action action : editorKit.getActions()) {
                if (action == null) continue;
                this.name2actionRef.put((String)action.getValue("Name"), new WeakReference<Action>(action));
            }
        }

        public Action getAction(String string) {
            Reference<Action> reference = this.name2actionRef.get(string);
            return reference != null ? reference.get() : null;
        }

        public void addActionsChangeListener(ChangeListener changeListener) {
        }

        public void removeActionsChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class KeyBindingSettingsListener
    implements LookupListener {
        static final KeyBindingSettingsListener INSTANCE = new KeyBindingSettingsListener();

        private KeyBindingSettingsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            Class<EditorActionUtilities> clazz = EditorActionUtilities.class;
            synchronized (EditorActionUtilities.class) {
                mimeType2actionName2KeyStroke = null;
                LOG.fine("mimeType2actionName2KeyStroke cleared.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

