/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.Repository;

final class NbfsUtil {
    private static final char SEPARATOR = '/';

    NbfsUtil() {
    }

    static URL getURL(FileObject fileObject) throws FileStateInvalidException {
        String string = NbfsUtil.encodeFsPart(fileObject);
        String string2 = NbfsUtil.encodeFoPart(fileObject);
        final String string3 = NbfsUtil.combine(string, string2);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return new URL("nbfs", "nbhost", -1, string3, new FileURL.Handler());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IllegalStateException illegalStateException = new IllegalStateException(privilegedActionException.toString());
            ExternalUtil.annotate((Throwable)illegalStateException, privilegedActionException);
            throw illegalStateException;
        }
    }

    private static String combine(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('/').append(string);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private static String[] split(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf("/", 1);
        String string2 = "";
        String string3 = string;
        if (n > 1) {
            string2 = string.substring(1, n);
            string3 = string.substring(n + 1);
        }
        return new String[]{string2, string3};
    }

    static FileObject getFileObject(URL uRL) {
        if (!uRL.getProtocol().equals("nbfs")) {
            return null;
        }
        if (NbfsUtil.isOldEncoding(uRL)) {
            return NbfsUtil.oldDecode(uRL);
        }
        String[] stringArray = NbfsUtil.split(uRL);
        String string = NbfsUtil.decodeFsPart(stringArray[0]);
        String string2 = NbfsUtil.decodeFoPart(stringArray[1]);
        FileSystem fileSystem = Repository.getDefault().findFileSystem(string);
        return fileSystem == null ? null : fileSystem.findResource(string2);
    }

    private static String encodeFsPart(FileObject fileObject) throws FileStateInvalidException {
        FileSystem fileSystem = fileObject.getFileSystem();
        return NbfsUtil.encoder(fileSystem.getSystemName());
    }

    private static String encodeFoPart(FileObject fileObject) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(fileObject.getPath(), String.valueOf('/'));
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append('/');
            stringBuffer.append(NbfsUtil.encoder((String)stringTokenizer.nextElement()));
        }
        String string = stringBuffer.toString();
        if (string.length() == 0 || fileObject.isFolder() && string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        return string;
    }

    private static String decodeFsPart(String string) {
        return NbfsUtil.decoder(string);
    }

    private static String decodeFoPart(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf('/'));
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append('/');
            stringBuffer.append(NbfsUtil.decoder((String)stringTokenizer.nextElement()));
        }
        return stringBuffer.toString();
    }

    private static String encoder(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    private static String decoder(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    private static boolean isOldEncoding(URL uRL) {
        String string = uRL.getHost();
        return string == null || string.length() == 0;
    }

    private static FileObject oldDecode(URL uRL) {
        int n;
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(47)) == -1) {
            return null;
        }
        String string2 = NbfsUtil.oldDecodeFSName(string.substring(0, n));
        string = string.substring(n);
        FileSystem fileSystem = Repository.getDefault().findFileSystem(string2);
        return fileSystem == null ? null : fileSystem.findResource(string);
    }

    private static String oldDecodeFSName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        block6: while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) == 'Q' && n < n2) {
                switch (string.charAt(n++)) {
                    case 'B': {
                        stringBuffer.append('/');
                        continue block6;
                    }
                    case 'C': {
                        stringBuffer.append(':');
                        continue block6;
                    }
                    case 'D': {
                        stringBuffer.append('\\');
                        continue block6;
                    }
                    case 'E': {
                        stringBuffer.append('#');
                        continue block6;
                    }
                }
                stringBuffer.append('Q');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

