/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventControl {
    private int requests;
    private int priorityRequests;
    private AtomicActionLink currentAtomAction;
    private LinkedList<FileSystem.EventDispatcher> requestsQueue;

    EventControl() {
    }

    void dispatchEvent(FileSystem.EventDispatcher eventDispatcher) {
        if (this.postponeFiring(eventDispatcher)) {
            return;
        }
        eventDispatcher.run();
    }

    void beginAtomicAction(FileSystem.AtomicAction atomicAction) {
        this.enterAtomicAction(atomicAction, true);
    }

    void finishAtomicAction() {
        this.exitAtomicAction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAtomicAction(FileSystem.AtomicAction atomicAction) throws IOException {
        try {
            this.enterAtomicAction(atomicAction, false);
            atomicAction.run();
        }
        finally {
            this.exitAtomicAction(false);
        }
    }

    private synchronized void enterAtomicAction(Object object, boolean bl) {
        AtomicActionLink atomicActionLink = new AtomicActionLink(object);
        atomicActionLink.setPreviousLink(this.currentAtomAction);
        this.currentAtomAction = atomicActionLink;
        if (bl) {
            ++this.priorityRequests;
        }
        if (this.requests++ == 0) {
            this.requestsQueue = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAtomicAction(boolean bl) {
        LinkedList<FileSystem.EventDispatcher> linkedList;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this;
        synchronized (object) {
            this.currentAtomAction = this.currentAtomAction.getPreviousLink();
            --this.requests;
            if (bl) {
                --this.priorityRequests;
            }
            if (this.requests == 0) {
                bl2 = true;
            }
            if (!bl2 && bl && this.priorityRequests == 0) {
                bl3 = true;
            }
            if (!bl2 && !bl3) {
                return;
            }
            linkedList = this.requestsQueue;
            this.requestsQueue = null;
            this.priorityRequests = 0;
        }
        if (bl2) {
            this.invokeDispatchers(false, linkedList);
            return;
        }
        if (bl3) {
            this.requestsQueue = new LinkedList();
            object = this.invokeDispatchers(true, linkedList);
            EventControl eventControl = this;
            synchronized (eventControl) {
                while (this.requestsQueue != null && !this.requestsQueue.isEmpty()) {
                    FileSystem.EventDispatcher eventDispatcher = this.requestsQueue.removeFirst();
                    ((LinkedList)object).add(eventDispatcher);
                }
                this.requestsQueue = object;
            }
        }
    }

    private LinkedList<FileSystem.EventDispatcher> invokeDispatchers(boolean bl, LinkedList<FileSystem.EventDispatcher> linkedList) {
        LinkedList<FileSystem.EventDispatcher> linkedList2 = new LinkedList<FileSystem.EventDispatcher>();
        LinkedHashSet<Runnable> linkedHashSet = new LinkedHashSet<Runnable>();
        while (linkedList != null && !linkedList.isEmpty()) {
            FileSystem.EventDispatcher eventDispatcher = linkedList.removeFirst();
            eventDispatcher.dispatch(bl, linkedHashSet);
            if (!bl) continue;
            linkedList2.add(eventDispatcher);
        }
        for (Runnable runnable : linkedHashSet) {
            runnable.run();
        }
        return linkedList2;
    }

    private synchronized boolean postponeFiring(FileSystem.EventDispatcher eventDispatcher) {
        if (this.priorityRequests == 0) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            eventDispatcher.dispatch(true, null);
        }
        if (this.requestsQueue != null) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            this.requestsQueue.add(eventDispatcher);
            return true;
        }
        return false;
    }

    static final class AtomicActionLink {
        private AtomicActionLink upper;
        private Object propagationID;

        AtomicActionLink(Object object) {
            this.propagationID = object;
        }

        Object getAtomicAction() {
            return this.propagationID;
        }

        void setPreviousLink(AtomicActionLink atomicActionLink) {
            this.upper = atomicActionLink;
        }

        AtomicActionLink getPreviousLink() {
            return this.upper;
        }
    }
}

