/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.diff.options.ColorValue;

class ColorComboBoxRenderer
extends JComponent
implements ListCellRenderer,
ComboBoxEditor {
    private int SIZE = 9;
    private ColorValue value;
    private JComboBox comboBox;

    ColorComboBoxRenderer(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.setPreferredSize(new Dimension(50, jComboBox.getFontMetrics(jComboBox.getFont()).getHeight() + 2));
        this.setOpaque(true);
        this.setFocusable(true);
    }

    public void paint(Graphics graphics) {
        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            ((Graphics2D)graphics).setRenderingHints(map);
        }
        Color color = graphics.getColor();
        Dimension dimension = this.getSize();
        if (this.isFocusOwner()) {
            graphics.setColor(SystemColor.textHighlight);
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = (dimension.height - this.SIZE) / 2;
        if (this.value.color != null) {
            graphics.setColor(Color.black);
            graphics.drawRect(n, n, this.SIZE, this.SIZE);
            graphics.setColor(this.value.color);
            graphics.fillRect(n + 1, n + 1, this.SIZE - 1, this.SIZE - 1);
        }
        if (this.value.text != null) {
            if (this.isFocusOwner()) {
                graphics.setColor(SystemColor.textHighlightText);
            } else {
                graphics.setColor(this.getForeground());
            }
            if (this.value.color != null) {
                graphics.drawString(this.value.text, n + this.SIZE + 5, n + this.SIZE);
            } else {
                graphics.drawString(this.value.text, 5, n + this.SIZE);
            }
        }
        graphics.setColor(color);
    }

    public void setEnabled(boolean bl) {
        this.setBackground(bl ? SystemColor.text : SystemColor.control);
        super.setEnabled(bl);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.value = (ColorValue)object;
        this.setEnabled(jList.isEnabled());
        this.setBackground(bl ? SystemColor.textHighlight : SystemColor.text);
        this.setForeground(bl ? SystemColor.textHighlightText : SystemColor.textText);
        return this;
    }

    public Component getEditorComponent() {
        this.setEnabled(this.comboBox.isEnabled());
        this.setBackground(this.comboBox.isFocusOwner() ? SystemColor.textHighlight : SystemColor.text);
        this.setForeground(this.comboBox.isFocusOwner() ? SystemColor.textHighlightText : SystemColor.textText);
        return this;
    }

    public void setItem(Object object) {
        ColorValue colorValue = this.value;
        this.value = (ColorValue)object;
        this.firePropertyChange("color", colorValue, object);
    }

    public Object getItem() {
        return this.value;
    }

    public void selectAll() {
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public void removeActionListener(ActionListener actionListener) {
    }
}

