/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;

public class LabelBracketTableCellRenderer
extends EnhancedTableCellRenderer {
    private JLabel label1;
    private JLabel label2;
    private int digitsWidth = -1;

    public LabelBracketTableCellRenderer() {
        this(10);
    }

    public LabelBracketTableCellRenderer(int n) {
        this(n, "(99.9%)");
    }

    public LabelBracketTableCellRenderer(int n, final String string) {
        this.setHorizontalAlignment(n);
        this.label1 = new JLabel("", n);
        this.label2 = new JLabel("", n){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (LabelBracketTableCellRenderer.this.digitsWidth == -1) {
                    LabelBracketTableCellRenderer.this.digitsWidth = this.getFontMetrics(this.getFont()).stringWidth(string);
                }
                if (dimension.width < LabelBracketTableCellRenderer.this.digitsWidth) {
                    return new Dimension(LabelBracketTableCellRenderer.this.digitsWidth, dimension.height);
                }
                return dimension;
            }
        };
        Font font = this.label2.getFont();
        this.label2.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
        this.setLayout(new BorderLayout());
        if (n == 10) {
            this.add((Component)this.label1, "West");
            this.add((Component)this.label2, "Center");
        } else {
            this.add((Component)this.label1, "Center");
            this.add((Component)this.label2, "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return new LabelBracketTableCellRenderer(this.label1.getHorizontalAlignment()).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    protected void setRowForeground(Color color) {
        super.setRowForeground(color);
        this.label1.setForeground(color);
        this.label2.setForeground(color.equals(Color.BLACK) ? Color.GRAY : color.brighter());
    }

    protected void setValue(JTable jTable, Object object, int n, int n2) {
        if (jTable != null) {
            this.setFont(jTable.getFont());
        }
        if (object != null) {
            String string = object.toString();
            int n3 = string.lastIndexOf(40);
            if (n3 != -1) {
                this.label1.setText(string.substring(0, n3));
                this.label2.setText(string.substring(n3));
            } else {
                this.label1.setText(string);
                this.label2.setText("");
            }
        } else {
            this.label1.setText("");
            this.label2.setText("");
        }
    }
}

