/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.netbeans.lib.profiler.ui.UIUtils;

public class FlatToolBar
extends JToolBar {
    public static final int BUTTON_STYLE_HORIZONTAL = 1;
    public static final int BUTTON_STYLE_VERICAL = 2;
    int buttonStyle = 1;

    public FlatToolBar() {
        this(0, 1);
    }

    public FlatToolBar(int n) {
        this(n, 1);
    }

    public FlatToolBar(int n, int n2) {
        super(n);
        this.buttonStyle = n2;
        if (!UIUtils.isGTKLookAndFeel()) {
            this.setUI(new MyToolBarUI());
        }
        this.setFloatable(false);
        this.setOpaque(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setContentAreaFilled(false);
            abstractButton.setMargin(new Insets(3, 3, 3, 3));
            if (this.buttonStyle == 2) {
                abstractButton.setVerticalTextPosition(3);
                abstractButton.setHorizontalTextPosition(0);
            }
        }
        super.addImpl(component, object, n);
    }

    protected JButton createActionComponent(Action action) {
        JButton jButton = super.createActionComponent(action);
        if (this.buttonStyle == 2) {
            jButton.putClientProperty("hideActionText", Boolean.FALSE);
            String string = (String)action.getValue("iconBase");
            if (string != null) {
                try {
                    System.err.println("URL for: " + FlatToolBar.insertBeforeSuffix(string, "32"));
                    URL uRL = action.getClass().getResource(FlatToolBar.insertBeforeSuffix(string, "32"));
                    System.err.println("is: " + uRL);
                    jButton.setIcon(new ImageIcon(uRL));
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
        return jButton;
    }

    static String insertBeforeSuffix(String string, String string2) {
        String string3 = string;
        String string4 = "";
        if (string.lastIndexOf(46) >= 0) {
            string3 = string.substring(0, string.lastIndexOf(46));
            string4 = string.substring(string.lastIndexOf(46), string.length());
        }
        return string3 + string2 + string4;
    }

    private static class MyToolBarUI
    extends BasicToolBarUI {
        private AbstractBorder myRolloverBorder = new CompoundBorder(new FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatMarginBorder());

        protected void setBorderToRollover(Component component) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                if (abstractButton.getBorder() instanceof UIResource) {
                    abstractButton.setBorder(this.myRolloverBorder);
                }
                abstractButton.setRolloverEnabled(true);
            }
        }
    }

    public static class FlatRolloverButtonBorder
    extends AbstractBorder {
        private Color normal;
        private Color pressed;
        private Color roll;
        private boolean borderPainted = false;

        public FlatRolloverButtonBorder(Color color, Color color2) {
            this.pressed = color;
            this.roll = color2;
            this.borderPainted = false;
        }

        public FlatRolloverButtonBorder(Color color, Color color2, Color color3) {
            this.pressed = color;
            this.roll = color2;
            this.normal = color3;
            this.borderPainted = true;
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed()) || buttonModel.isSelected()) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(this.pressed);
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                } else {
                    graphics.setColor(this.roll);
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                }
                graphics.translate(-n, -n2);
                graphics.setColor(color);
            } else if (this.borderPainted) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                graphics.setColor(this.normal);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.translate(-n, -n2);
                graphics.setColor(color);
            }
        }
    }

    public static class FlatMarginBorder
    extends AbstractBorder {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                insets2 = abstractButton.getMargin();
            }
            insets.top = insets2 != null ? insets2.top : 0;
            insets.left = insets2 != null ? insets2.left : 0;
            insets.bottom = insets2 != null ? insets2.bottom : 0;
            insets.right = insets2 != null ? insets2.right : 0;
            return insets;
        }
    }
}

