/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.components.ImageBlenderPanel;

public class ComponentMorpher2
extends JComponent {
    private Image endComponentImage;
    private Image startComponentImage;
    private ImageBlenderPanel blenderPanel;
    private JComponent component1;
    private JComponent component2;
    private JComponent currentComponent;
    private JComponent endComponent;
    private JComponent startComponent;
    private boolean isMorphing = false;
    private float heightDelta;
    private int morphingDelay;
    private int morphingStep;
    private int morphingSteps;

    public ComponentMorpher2(JComponent jComponent, JComponent jComponent2) {
        this(jComponent, jComponent2, 10, 15);
    }

    public ComponentMorpher2(JComponent jComponent, JComponent jComponent2, int n, int n2) {
        this.component1 = jComponent;
        this.component2 = jComponent2;
        this.setMorphingSteps(n);
        this.setMorphingDelay(n2);
        this.setLayout(new BorderLayout());
        this.setCurrentComponent(jComponent);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    public boolean isExpanded() {
        return this.currentComponent == this.component2;
    }

    public boolean isMorphing() {
        return this.isMorphing;
    }

    public void setMorphingDelay(int n) {
        this.morphingDelay = n;
    }

    public int getMorphingDelay() {
        return this.morphingDelay;
    }

    public void setMorphingSteps(int n) {
        this.morphingSteps = n;
    }

    public int getMorphingSteps() {
        return this.morphingSteps;
    }

    public void morph() {
        if (!this.isMorphing()) {
            new MorpherThread().start();
        }
    }

    public void morphingStep() {
        if (this.morphingStep > this.morphingSteps) {
            return;
        }
        if (this.morphingStep == 0) {
            this.setCurrentComponent(this.blenderPanel);
        } else if (this.morphingStep == this.morphingSteps) {
            this.setCurrentComponent(this.endComponent);
            this.isMorphing = false;
        } else {
            Dimension dimension = new Dimension(this.getClientSize().width, this.startComponentImage.getHeight(null) + (int)((float)this.morphingStep * this.heightDelta));
            this.blenderPanel.setBlendAlpha((float)this.morphingStep / (float)this.morphingSteps);
            this.blenderPanel.setSize(dimension);
            this.setClientPreferredSize(dimension);
        }
        this.refresh();
        ++this.morphingStep;
    }

    public void refresh() {
        this.revalidate();
        this.repaint();
    }

    public void setupMorphing() {
        this.startComponent = this.currentComponent == this.component1 ? this.component1 : this.component2;
        this.endComponent = this.currentComponent == this.component1 ? this.component2 : this.component1;
        this.startComponentImage = this.getComponentImage(this.startComponent);
        this.endComponentImage = this.getComponentImage(this.endComponent);
        this.heightDelta = (float)(this.endComponentImage.getHeight(null) - this.startComponentImage.getHeight(null)) / (float)this.morphingSteps;
        this.blenderPanel = new ImageBlenderPanel(this.startComponentImage, this.endComponentImage, this.component1.getBackground(), 0.0f);
        this.blenderPanel.setPreferredSize(new Dimension(this.startComponentImage.getWidth(null), this.startComponentImage.getHeight(null)));
        this.morphingStep = 0;
        this.isMorphing = true;
    }

    private void setClientPreferredSize(Dimension dimension) {
        Insets insets = this.getInsets();
        this.setPreferredSize(new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom));
    }

    private Dimension getClientSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        return new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
    }

    private Image getComponentImage(JComponent jComponent) {
        jComponent.setSize(this.getClientSize().width == 0 ? jComponent.getPreferredSize() : this.getClientSize());
        jComponent.doLayout();
        jComponent.setSize(new Dimension(this.getClientSize().width, jComponent.getPreferredSize().height));
        jComponent.doLayout();
        jComponent.setSize(new Dimension(this.getClientSize().width, jComponent.getPreferredSize().height));
        jComponent.doLayout();
        BufferedImage bufferedImage = new BufferedImage(jComponent.getSize().width, jComponent.getSize().height, 1);
        jComponent.printAll(bufferedImage.getGraphics());
        return bufferedImage;
    }

    private void setCurrentComponent(JComponent jComponent) {
        if (this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = jComponent;
        this.add((Component)this.currentComponent, "Center");
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    private class MorpherThread
    extends Thread {
        private MorpherThread() {
        }

        public void run() {
            ComponentMorpher2.this.setupMorphing();
            while (ComponentMorpher2.this.isMorphing()) {
                ComponentMorpher2.this.morphingStep();
                try {
                    Thread.sleep(ComponentMorpher2.this.morphingDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

