/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;

public class DynamicPieChartModel
extends AbstractPieChartModel {
    protected Color[] itemColors;
    protected String[] itemNames;
    protected double[] itemValues;
    protected double[] itemValuesRel;
    protected boolean hasData = false;
    protected int itemCount = 0;

    public Color getItemColor(int n) {
        return this.itemColors[n];
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public String getItemName(int n) {
        return this.itemNames[n];
    }

    public double getItemValue(int n) {
        return this.itemValues[n];
    }

    public double getItemValueRel(int n) {
        return this.itemValuesRel[n];
    }

    public void setItemValues(double[] dArray) {
        if (dArray.length != this.itemCount) {
            this.hasData = false;
            throw new RuntimeException("Unexpected number of values.");
        }
        this.itemValues = dArray;
        this.updateItemValuesRel();
        this.fireChartDataChanged();
    }

    public boolean isSelectable(int n) {
        return true;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public void setupModel(String[] stringArray, Color[] colorArray) {
        this.itemNames = stringArray;
        this.itemColors = colorArray;
        if (stringArray.length != colorArray.length) {
            this.itemCount = 0;
            throw new RuntimeException("Counts of item names and item colors don't match.");
        }
        this.itemCount = stringArray.length;
        this.itemValues = null;
        this.itemValuesRel = new double[this.itemCount];
        this.hasData = false;
    }

    private void updateItemValuesRel() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.itemValues.length; ++n) {
            d += this.itemValues[n];
        }
        if (d == 0.0) {
            for (n = 0; n < this.itemValues.length; ++n) {
                this.itemValuesRel[n] = 0.0;
            }
            this.hasData = false;
        } else {
            for (n = 0; n < this.itemValues.length; ++n) {
                this.itemValuesRel[n] = this.itemValues[n] / d;
            }
            this.hasData = true;
        }
    }
}

