/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowEdgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.model.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowEdgePresenter
extends FlowPresenter
implements FlowPresenter.FlowUIResolver {
    private FlowPresenter.FlowUIResolver resolver = new FlowPresenter.FlowUIResolver(){

        public FlowDescriptor.Decorator getDecorator() {
            return FlowEdgePresenter.this.getDynamicPinDecorator();
        }

        public FlowDescriptor.Behaviour getBehaviour() {
            return FlowEdgePresenter.this.getDynamicPinBehaviour();
        }
    };
    private FlowEdgeDescriptor edge = null;
    private FlowEdgeDescriptor newEdge;
    private boolean removeAdd;

    @Override
    public final void resolveRemoveBadge() {
    }

    @Override
    public final void resolveRemoveEdge() {
        this.newEdge = this.isVisible() ? this.getEdgeDescriptor() : null;
        boolean bl = this.removeAdd = !FlowEdgePresenter.equals(this.edge, this.newEdge);
        if (this.removeAdd && this.edge != null) {
            this.removeDettachSourcePin(this.edge);
            this.removeDettachTargetPin(this.edge);
            FlowScene flowScene = this.getScene();
            flowScene.removeEdge(this.edge);
            flowScene.unregisterUI(this.edge, (FlowPresenter.FlowUIResolver)this);
        }
    }

    @Override
    public final void resolveRemovePin() {
    }

    @Override
    public final void resolveRemoveNode() {
    }

    @Override
    public final void resolveAddNode() {
    }

    @Override
    public final void resolveAddPin() {
    }

    @Override
    public final void resolveAddEdge() {
        if (this.removeAdd) {
            this.edge = this.newEdge;
            if (this.edge != null) {
                FlowScene flowScene = this.getScene();
                flowScene.registerUI(this.edge, (FlowPresenter.FlowUIResolver)this);
                flowScene.addEdge(this.edge);
                flowScene.updateBadges(this.edge);
                this.createAssignSourcePin(this.edge);
                this.createAssignTargetPin(this.edge);
            }
        } else if (this.edge != null && this.newEdge != null) {
            boolean bl;
            boolean bl2 = !FlowEdgePresenter.equals(this.edge.getSourcePinDescriptor(), this.newEdge.getSourcePinDescriptor()) || this.edge.isDynamicSourcePin() != this.newEdge.isDynamicSourcePin();
            boolean bl3 = bl = !FlowEdgePresenter.equals(this.edge.getTargetPinDescriptor(), this.newEdge.getTargetPinDescriptor()) || this.edge.isDynamicTargetPin() != this.newEdge.isDynamicTargetPin();
            if (bl2) {
                this.removeDettachSourcePin(this.edge);
            }
            if (bl) {
                this.removeDettachTargetPin(this.edge);
            }
            this.edge.update(this.newEdge);
            this.createAssignSourcePin(this.edge);
            this.createAssignTargetPin(this.edge);
        }
        this.newEdge = null;
    }

    @Override
    public final void resolveAddBadge() {
    }

    @Override
    public final void resolveUpdate() {
        FlowScene flowScene = this.getScene();
        if (this.edge != null) {
            FlowPinDescriptor flowPinDescriptor;
            flowScene.getDecorator(this.edge).update(this.edge, flowScene);
            if (this.edge.isDynamicSourcePin()) {
                flowPinDescriptor = this.edge.getSourcePinDescriptor();
                flowScene.getDecorator(flowPinDescriptor).update(flowPinDescriptor, flowScene);
            }
            if (this.edge.isDynamicTargetPin()) {
                flowPinDescriptor = this.edge.getTargetPinDescriptor();
                flowScene.getDecorator(flowPinDescriptor).update(flowPinDescriptor, flowScene);
            }
        }
    }

    private void createAssignSourcePin(FlowEdgeDescriptor flowEdgeDescriptor) {
        FlowScene flowScene = this.getScene();
        FlowPinDescriptor flowPinDescriptor = flowEdgeDescriptor.getSourcePinDescriptor();
        if (flowPinDescriptor != null) {
            if (flowEdgeDescriptor.isDynamicSourcePin()) {
                if (!flowScene.isObject(flowPinDescriptor)) {
                    FlowNodeDescriptor flowNodeDescriptor = this.getSourceNodeDescriptor(flowPinDescriptor);
                    assert (flowNodeDescriptor != null);
                    flowScene.registerUI(flowPinDescriptor, this.resolver);
                    flowScene.addPin(flowNodeDescriptor, flowPinDescriptor);
                    flowScene.updateBadges(flowPinDescriptor);
                } else {
                    FlowPinDescriptor flowPinDescriptor2 = flowPinDescriptor;
                    if ((flowPinDescriptor = (FlowPinDescriptor)flowScene.findStoredObject(flowPinDescriptor)) == null) {
                        Debug.warning((Object[])new Object[]{"Source pin not found", flowEdgeDescriptor, flowPinDescriptor2});
                    }
                }
            } else {
                FlowPinDescriptor flowPinDescriptor3 = flowPinDescriptor;
                if ((flowPinDescriptor = (FlowPinDescriptor)flowScene.findStoredObject(flowPinDescriptor)) == null) {
                    Debug.warning((Object[])new Object[]{"Source pin not found", flowEdgeDescriptor, flowPinDescriptor3});
                }
            }
        }
        flowScene.setEdgeSource(flowEdgeDescriptor, flowPinDescriptor);
    }

    private void createAssignTargetPin(FlowEdgeDescriptor flowEdgeDescriptor) {
        FlowScene flowScene = this.getScene();
        FlowPinDescriptor flowPinDescriptor = flowEdgeDescriptor.getTargetPinDescriptor();
        if (flowPinDescriptor != null) {
            if (flowEdgeDescriptor.isDynamicTargetPin()) {
                if (!flowScene.isObject(flowPinDescriptor)) {
                    FlowNodeDescriptor flowNodeDescriptor = this.getTargetNodeDescriptor(flowPinDescriptor);
                    assert (flowNodeDescriptor != null);
                    flowScene.registerUI(flowPinDescriptor, this.resolver);
                    flowScene.addPin(flowNodeDescriptor, flowPinDescriptor);
                } else {
                    FlowPinDescriptor flowPinDescriptor2 = flowPinDescriptor;
                    if ((flowPinDescriptor = (FlowPinDescriptor)flowScene.findStoredObject(flowPinDescriptor)) == null) {
                        Debug.warning((Object[])new Object[]{"Target pin not found", flowEdgeDescriptor, flowPinDescriptor2});
                    }
                }
            } else {
                FlowPinDescriptor flowPinDescriptor3 = flowPinDescriptor;
                if ((flowPinDescriptor = (FlowPinDescriptor)flowScene.findStoredObject(flowPinDescriptor)) == null) {
                    Debug.warning((Object[])new Object[]{"Target pin not found", flowEdgeDescriptor, flowPinDescriptor3});
                }
            }
        }
        flowScene.setEdgeTarget(flowEdgeDescriptor, flowPinDescriptor);
    }

    private void removeDettachSourcePin(FlowEdgeDescriptor flowEdgeDescriptor) {
        if (!flowEdgeDescriptor.isDynamicSourcePin()) {
            return;
        }
        FlowScene flowScene = this.getScene();
        FlowPinDescriptor flowPinDescriptor = (FlowPinDescriptor)flowScene.getEdgeSource(flowEdgeDescriptor);
        flowScene.removePin(flowPinDescriptor);
        flowScene.unregisterUI(flowPinDescriptor, this.resolver);
    }

    private void removeDettachTargetPin(FlowEdgeDescriptor flowEdgeDescriptor) {
        if (!flowEdgeDescriptor.isDynamicTargetPin()) {
            return;
        }
        FlowScene flowScene = this.getScene();
        FlowPinDescriptor flowPinDescriptor = (FlowPinDescriptor)flowScene.getEdgeTarget(flowEdgeDescriptor);
        flowScene.removePin(flowPinDescriptor);
        flowScene.unregisterUI(flowPinDescriptor, this.resolver);
    }

    @Override
    public final Collection<? extends FlowDescriptor> getFlowDescriptors() {
        return this.edge != null ? Collections.singleton(this.edge) : Collections.emptySet();
    }

    protected abstract FlowNodeDescriptor getSourceNodeDescriptor(FlowPinDescriptor var1);

    protected abstract FlowNodeDescriptor getTargetNodeDescriptor(FlowPinDescriptor var1);

    public abstract FlowEdgeDescriptor getEdgeDescriptor();

    @Override
    public abstract FlowEdgeDescriptor.EdgeDecorator getDecorator();

    @Override
    public abstract FlowEdgeDescriptor.EdgeBehaviour getBehaviour();

    public abstract FlowPinDescriptor.PinDecorator getDynamicPinDecorator();

    public abstract FlowPinDescriptor.PinBehaviour getDynamicPinBehaviour();
}

