/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsOverriddenVisitor
extends CancellableTreePathScanner<Void, Tree> {
    private CompilationInfo info;
    private Document doc;
    Map<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>> type2Declaration;
    Map<ElementHandle<ExecutableElement>, MethodTree> declaration2Tree;
    Map<ElementHandle<TypeElement>, ClassTree> declaration2Class;
    private Map<TypeElement, ElementHandle<TypeElement>> type2Handle;
    private ElementHandle<TypeElement> currentClass;

    IsOverriddenVisitor(Document document, CompilationInfo compilationInfo) {
        this.doc = document;
        this.info = compilationInfo;
        this.type2Declaration = new HashMap<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>>();
        this.declaration2Tree = new HashMap<ElementHandle<ExecutableElement>, MethodTree>();
        this.declaration2Class = new HashMap<ElementHandle<TypeElement>, ClassTree>();
        this.type2Handle = new HashMap<TypeElement, ElementHandle<TypeElement>>();
    }

    private ElementHandle<TypeElement> getHandle(TypeElement typeElement) {
        ElementHandle elementHandle = this.type2Handle.get(typeElement);
        if (elementHandle == null) {
            elementHandle = ElementHandle.create((Element)typeElement);
            this.type2Handle.put(typeElement, (ElementHandle<TypeElement>)elementHandle);
        }
        return elementHandle;
    }

    public Void visitMethod(MethodTree methodTree, Tree tree) {
        Element element;
        if (this.currentClass != null && (element = this.info.getTrees().getElement(this.getCurrentPath())) != null && element.getKind() == ElementKind.METHOD && !element.getModifiers().contains((Object)Modifier.PRIVATE) && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            ExecutableElement executableElement = (ExecutableElement)element;
            List<ElementHandle<ExecutableElement>> list = this.type2Declaration.get(this.currentClass);
            if (list == null) {
                list = new ArrayList<ElementHandle<ExecutableElement>>();
                this.type2Declaration.put(this.currentClass, list);
            }
            ElementHandle elementHandle = ElementHandle.create((Element)executableElement);
            list.add((ElementHandle<ExecutableElement>)elementHandle);
            this.declaration2Tree.put((ElementHandle<ExecutableElement>)elementHandle, methodTree);
        }
        super.visitMethod(methodTree, (Object)methodTree);
        return null;
    }

    public Void visitClass(ClassTree classTree, Tree tree) {
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        if (element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
            ElementHandle<TypeElement> elementHandle = this.currentClass;
            this.currentClass = this.getHandle((TypeElement)element);
            this.declaration2Class.put(this.currentClass, classTree);
            super.visitClass(classTree, (Object)tree);
            this.currentClass = elementHandle;
        } else {
            super.visitClass(classTree, (Object)tree);
        }
        return null;
    }
}

