/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.ImportClassPanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FastImportAction
extends BaseAction {
    public static final String NAME = "fast-import";

    public FastImportAction() {
        super(NAME);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            final Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
            final Font font = jTextComponent.getFont();
            final Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            final int n = jTextComponent.getCaretPosition();
            final String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            FileObject fileObject = this.getFile(jTextComponent.getDocument());
            if (string == null || fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final AtomicBoolean atomicBoolean = new AtomicBoolean();
            Task<CompilationController> task = new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    if (atomicBoolean.get()) {
                        return;
                    }
                    final JavaSource javaSource = compilationController.getJavaSource();
                    ComputeImports.Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> pair = new ComputeImports().computeCandidates((CompilationInfo)compilationController, Collections.singleton(string));
                    final List list = (List)((Map)pair.a).get(string);
                    if (list == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final ArrayList arrayList = new ArrayList((Collection)((Map)pair.b).get(string));
                    arrayList.removeAll(list);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ImportClassPanel importClassPanel = new ImportClassPanel(list, arrayList, font, javaSource, n);
                            PopupUtil.showPopup(importClassPanel, "", point.x, point.y, true, rectangle.height);
                        }
                    });
                }
            };
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable((Task)task){
                final /* synthetic */ Task val$task;
                {
                    this.val$task = task;
                }

                public void run() {
                    try {
                        javaSource.runUserActionTask(this.val$task, true);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }, (String)NbBundle.getMessage(FastImportAction.class, (String)"LBL_Fast_Import"), (AtomicBoolean)atomicBoolean, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private FileObject getFile(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

