/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.EqualsHashCodePanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHashCodeGenerator
implements CodeGenerator {
    private static final String ERROR = "<error>";
    private JTextComponent component;
    final ElementNode.Description description;
    final boolean generateEquals;
    final boolean generateHashCode;
    static int randomNumber = -1;
    private static final Map<KindOfType, String> EQUALS_PATTERNS = new EnumMap<KindOfType, String>(KindOfType.class);
    private static final Map<KindOfType, String> HASH_CODE_PATTERNS;

    private EqualsHashCodeGenerator(JTextComponent jTextComponent, ElementNode.Description description, boolean bl, boolean bl2) {
        this.component = jTextComponent;
        this.description = description;
        this.generateEquals = bl;
        this.generateHashCode = bl2;
    }

    public String getDisplayName() {
        if (this.generateEquals && this.generateHashCode) {
            return NbBundle.getMessage(EqualsHashCodeGenerator.class, (String)"LBL_equals_and_hashcode");
        }
        if (!this.generateEquals) {
            return NbBundle.getMessage(EqualsHashCodeGenerator.class, (String)"LBL_hashcode");
        }
        return NbBundle.getMessage(EqualsHashCodeGenerator.class, (String)"LBL_equals");
    }

    static EqualsHashCodeGenerator createEqualsHashCodeGenerator(JTextComponent jTextComponent, CompilationController compilationController, Element element) throws IOException {
        if (element.getKind() != ElementKind.CLASS) {
            return null;
        }
        if (element.getSimpleName() == null || element.getSimpleName().length() == 0) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        ExecutableElement[] executableElementArray = EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)compilationController, typeElement, null);
        ArrayList<ElementNode.Description> arrayList = new ArrayList<ElementNode.Description>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (ERROR.contentEquals(variableElement.getSimpleName()) || variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            arrayList.add(ElementNode.Description.create(variableElement, null, true, EqualsHashCodeGenerator.isUsed((CompilationInfo)compilationController, variableElement, executableElementArray)));
        }
        if (arrayList.isEmpty() || executableElementArray[0] != null && executableElementArray[1] != null) {
            return null;
        }
        return new EqualsHashCodeGenerator(jTextComponent, ElementNode.Description.create(typeElement, arrayList, false, false), executableElementArray[0] == null, executableElementArray[1] == null);
    }

    private static boolean isUsed(CompilationInfo compilationInfo, VariableElement variableElement, ExecutableElement ... executableElementArray) {
        for (ExecutableElement executableElement : executableElementArray) {
            if (executableElement == null) continue;
            Trees trees = compilationInfo.getTrees();
            TreePath treePath = trees.getPath(executableElement);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Used
            extends TreePathScanner<Void, VariableElement> {
                boolean found;

                Used() {
                }

                @Override
                public Void visitIdentifier(IdentifierTree identifierTree, VariableElement variableElement) {
                    if (((Object)identifierTree.getName()).equals(variableElement.getSimpleName())) {
                        this.found = true;
                    }
                    return (Void)super.visitIdentifier(identifierTree, variableElement);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree memberSelectTree, VariableElement variableElement) {
                    if (((Object)memberSelectTree.getIdentifier()).equals(variableElement.getSimpleName())) {
                        this.found = true;
                    }
                    return (Void)super.visitMemberSelect(memberSelectTree, variableElement);
                }
            }
            Used used = new Used();
            used.scan(treePath, variableElement);
            if (!used.found) continue;
            return true;
        }
        return false;
    }

    public static ExecutableElement[] overridesHashCodeAndEquals(CompilationInfo compilationInfo, Element element, boolean[] blArray) {
        ExecutableElement[] executableElementArray = new ExecutableElement[2];
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Object");
        if (typeElement == null) {
            return executableElementArray;
        }
        if (element == null || element.getKind() != ElementKind.CLASS) {
            return executableElementArray;
        }
        TypeMirror typeMirror = typeElement.asType();
        if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) {
            return executableElementArray;
        }
        ExecutableElement object = null;
        ExecutableElement object2 = null;
        for (ExecutableElement object3 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (blArray != null && blArray[0]) {
                return executableElementArray;
            }
            if (object3.getSimpleName().contentEquals("equals") && object3.getParameters().size() == 1 && !object3.getModifiers().contains((Object)Modifier.STATIC) && compilationInfo.getTypes().isSameType(typeMirror, object3.getParameters().get(0).asType())) {
                assert (object2 == null);
                object2 = object3;
            }
            if (!object3.getSimpleName().contentEquals("hashCode") || !object3.getParameters().isEmpty() || object3.getModifiers().contains((Object)Modifier.STATIC)) continue;
            assert (object == null);
            object = object3;
        }
        if (object == null || object2 == null) {
            return executableElementArray;
        }
        TypeElement typeElement2 = (TypeElement)element;
        for (Element element2 : element.getEnclosedElements()) {
            if (blArray != null && blArray[0]) {
                return executableElementArray;
            }
            if (element2.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element2;
            if (compilationInfo.getElements().overrides(executableElement, object, typeElement2)) {
                executableElementArray[1] = executableElement;
            }
            if (!compilationInfo.getElements().overrides(executableElement, object2, typeElement2)) continue;
            executableElementArray[0] = executableElement;
        }
        return executableElementArray;
    }

    public static void invokeEqualsHashCode(final TreePathHandle treePathHandle, final JTextComponent jTextComponent) {
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource != null) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class FillIn
            implements Task<CompilationController> {
                EqualsHashCodeGenerator gen;

                FillIn() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                    this.gen = EqualsHashCodeGenerator.createEqualsHashCodeGenerator(jTextComponent, compilationController, element);
                }

                public void invoke() {
                    if (this.gen != null) {
                        this.gen.invoke();
                    }
                }
            }
            FillIn fillIn = new FillIn();
            try {
                javaSource.runUserActionTask((Task)fillIn, true);
                fillIn.invoke();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void invoke() {
        JavaSource javaSource;
        final EqualsHashCodePanel equalsHashCodePanel = new EqualsHashCodePanel(this.description, this.generateEquals, this.generateHashCode);
        String string = NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_equals_and_hashcode");
        if (!this.generateEquals) {
            string = NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_hashcode");
        } else if (!this.generateHashCode) {
            string = NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_equals");
        }
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(equalsHashCodePanel, string);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue() && (javaSource = JavaSource.forDocument((Document)this.component.getDocument())) != null) {
            try {
                final int n = this.component.getCaretPosition();
                ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = GeneratorUtils.findClassMemberIndex(workingCopy, (ClassTree)treePath.getLeaf(), n);
                        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                        if (EqualsHashCodeGenerator.this.generateEquals) {
                            for (ElementHandle object : equalsHashCodePanel.getEqualsVariables()) {
                                arrayList.add((VariableElement)object.resolve((CompilationInfo)workingCopy));
                            }
                        }
                        ArrayList arrayList2 = new ArrayList();
                        if (EqualsHashCodeGenerator.this.generateHashCode) {
                            for (ElementHandle<? extends Element> elementHandle : equalsHashCodePanel.getHashCodeVariables()) {
                                arrayList2.add((VariableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                            }
                        }
                        EqualsHashCodeGenerator.generateEqualsAndHashCode(workingCopy, treePath, EqualsHashCodeGenerator.this.generateEquals ? arrayList : null, (Iterable<? extends VariableElement>)(EqualsHashCodeGenerator.this.generateHashCode ? arrayList2 : null), n2);
                    }
                });
                GeneratorUtils.guardedCommit(this.component, modificationResult);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static void generateEqualsAndHashCode(WorkingCopy workingCopy, TreePath treePath) {
        ExecutableElement[] executableElementArray = EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)workingCopy, workingCopy.getTrees().getElement(treePath), null);
        Set set = executableElementArray[0] == null ? Collections.emptySet() : null;
        Set set2 = executableElementArray[1] == null ? Collections.emptySet() : null;
        EqualsHashCodeGenerator.generateEqualsAndHashCode(workingCopy, treePath, set, set2, -1);
    }

    static void generateEqualsAndHashCode(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, Iterable<? extends VariableElement> iterable2, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            Scope scope = workingCopy.getTrees().getScope(treePath);
            if (iterable2 != null) {
                classTree = n >= 0 ? treeMaker.insertClassMember(classTree, n, (Tree)EqualsHashCodeGenerator.createHashCodeMethod(workingCopy, iterable2, (DeclaredType)typeElement.asType(), scope)) : treeMaker.addClassMember(classTree, (Tree)EqualsHashCodeGenerator.createHashCodeMethod(workingCopy, iterable2, (DeclaredType)typeElement.asType(), scope));
            }
            if (iterable != null) {
                classTree = n >= 0 ? treeMaker.insertClassMember(classTree, n, (Tree)EqualsHashCodeGenerator.createEqualsMethod(workingCopy, iterable, (DeclaredType)typeElement.asType(), scope)) : treeMaker.addClassMember(classTree, (Tree)EqualsHashCodeGenerator.createEqualsMethod(workingCopy, iterable, (DeclaredType)typeElement.asType(), scope));
            }
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    private static MethodTree createEqualsMethod(WorkingCopy workingCopy, Iterable<? extends VariableElement> iterable, DeclaredType declaredType, Scope scope) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        List<VariableTree> list = Collections.singletonList(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"obj", treeMaker.Type(workingCopy.getElements().getTypeElement("java.lang.Object").asType()), null));
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
        arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)treeMaker.Identifier((CharSequence)"obj"), (ExpressionTree)treeMaker.Identifier((CharSequence)"null")), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        arrayList.add(treeMaker.If((ExpressionTree)treeMaker.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"getClass"), Collections.emptyList()), (ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"obj"), (CharSequence)"getClass"), Collections.emptyList())), (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"other", treeMaker.Type((TypeMirror)declaredType), (ExpressionTree)treeMaker.TypeCast(treeMaker.Type((TypeMirror)declaredType), (ExpressionTree)treeMaker.Identifier((CharSequence)"obj"))));
        for (VariableElement object2 : iterable) {
            TypeMirror typeMirror = object2.asType();
            ExpressionTree expressionTree = EqualsHashCodeGenerator.prepareExpression(workingCopy, EQUALS_PATTERNS, typeMirror, object2, scope);
            arrayList.add(treeMaker.If(expressionTree, (StatementTree)treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"false")), null));
        }
        arrayList.add(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"true")));
        BlockTree blockTree = treeMaker.Block(arrayList, false);
        ModifiersTree modifiersTree = EqualsHashCodeGenerator.prepareModifiers(workingCopy, enumSet, treeMaker);
        return treeMaker.Method(modifiersTree, (CharSequence)"equals", (Tree)treeMaker.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), list, Collections.emptyList(), blockTree, null);
    }

    private static MethodTree createHashCodeMethod(WorkingCopy workingCopy, Iterable<? extends VariableElement> iterable, DeclaredType declaredType, Scope scope) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
        int n = EqualsHashCodeGenerator.generatePrimeNumber(2, 10);
        int n2 = EqualsHashCodeGenerator.generatePrimeNumber(10, 100);
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>();
        arrayList.add(treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"hash", (Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Literal((Object)n)));
        for (VariableElement object2 : iterable) {
            ExpressionTree expressionTree;
            TypeMirror typeMirror = object2.asType();
            switch (typeMirror.getKind()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: {
                    expressionTree = treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName());
                    break;
                }
                case LONG: {
                    expressionTree = treeMaker.TypeCast((Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.XOR, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName()), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName()), (ExpressionTree)treeMaker.Literal((Object)32))))));
                    break;
                }
                case FLOAT: {
                    expressionTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"Float"), (CharSequence)"floatToIntBits"), Collections.singletonList(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName())));
                    break;
                }
                case DOUBLE: {
                    MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"Double"), (CharSequence)"doubleToLongBits"), Collections.singletonList(treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName())));
                    expressionTree = treeMaker.TypeCast((Tree)treeMaker.PrimitiveType(TypeKind.INT), (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.XOR, (ExpressionTree)methodInvocationTree, (ExpressionTree)treeMaker.Parenthesized((ExpressionTree)treeMaker.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)methodInvocationTree, (ExpressionTree)treeMaker.Literal((Object)32))))));
                    break;
                }
                case BOOLEAN: {
                    expressionTree = treeMaker.Parenthesized((ExpressionTree)treeMaker.ConditionalExpression((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)object2.getSimpleName()), (ExpressionTree)treeMaker.Literal((Object)1), (ExpressionTree)treeMaker.Literal((Object)0)));
                    break;
                }
                default: {
                    expressionTree = EqualsHashCodeGenerator.prepareExpression(workingCopy, HASH_CODE_PATTERNS, typeMirror, object2, scope);
                }
            }
            arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)"hash"), (ExpressionTree)treeMaker.Binary(Tree.Kind.PLUS, (ExpressionTree)treeMaker.Binary(Tree.Kind.MULTIPLY, (ExpressionTree)treeMaker.Literal((Object)n2), (ExpressionTree)treeMaker.Identifier((CharSequence)"hash")), expressionTree))));
        }
        arrayList.add(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"hash")));
        BlockTree blockTree = treeMaker.Block(arrayList, false);
        ModifiersTree modifiersTree = EqualsHashCodeGenerator.prepareModifiers(workingCopy, enumSet, treeMaker);
        return treeMaker.Method(modifiersTree, (CharSequence)"hashCode", (Tree)treeMaker.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), blockTree, null);
    }

    private static boolean isPrimeNumber(int n) {
        int n2 = (int)Math.sqrt(n) + 1;
        if (n % 2 == 0) {
            return false;
        }
        for (int i = 3; i < n2; ++i) {
            if (n % i != 0) continue;
            return false;
        }
        return true;
    }

    private static int generatePrimeNumber(int n, int n2) {
        if (randomNumber > 0) {
            return randomNumber;
        }
        Random random = new Random(System.currentTimeMillis());
        int n3 = random.nextInt(n2 - n) + n;
        while (!EqualsHashCodeGenerator.isPrimeNumber(n3)) {
            ++n3;
        }
        if (n3 > n2) {
            --n3;
            while (!EqualsHashCodeGenerator.isPrimeNumber(n3)) {
                --n3;
            }
        }
        return n3;
    }

    private static ModifiersTree prepareModifiers(WorkingCopy workingCopy, Set<Modifier> set, TreeMaker treeMaker) {
        Object object;
        LinkedList<AnnotationTree> linkedList = new LinkedList<AnnotationTree>();
        if (GeneratorUtils.supportsOverride((CompilationInfo)workingCopy) && (object = workingCopy.getElements().getTypeElement("java.lang.Override")) != null) {
            linkedList.add(workingCopy.getTreeMaker().Annotation((Tree)workingCopy.getTreeMaker().QualIdent((Element)object), Collections.emptyList()));
        }
        object = treeMaker.Modifiers(set, linkedList);
        return object;
    }

    private static KindOfType detectKind(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return KindOfType.PRIMITIVE;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)typeMirror).getComponentType().getKind().isPrimitive() ? KindOfType.ARRAY_PRIMITIVE : KindOfType.ARRAY;
        }
        if (typeMirror.getKind().equals((Object)TypeKind.DECLARED) && ((DeclaredType)typeMirror).asElement().getKind().isClass() && ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
            return KindOfType.STRING;
        }
        return KindOfType.OTHER;
    }

    private static ExpressionTree prepareExpression(WorkingCopy workingCopy, Map<KindOfType, String> map, TypeMirror typeMirror, VariableElement variableElement, Scope scope) {
        KindOfType kindOfType = EqualsHashCodeGenerator.detectKind((CompilationInfo)workingCopy, typeMirror);
        String string = map.get((Object)kindOfType);
        assert (string != null);
        String string2 = MapFormat.format((String)string, Collections.singletonMap("VAR", variableElement.getSimpleName().toString()));
        ExpressionTree expressionTree = workingCopy.getTreeUtilities().parseExpression(string2, new SourcePositions[1]);
        expressionTree = (ExpressionTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)expressionTree);
        workingCopy.getTreeUtilities().attributeTree((Tree)expressionTree, scope);
        return expressionTree;
    }

    static {
        EQUALS_PATTERNS.put(KindOfType.PRIMITIVE, "this.{VAR} != other.{VAR}");
        EQUALS_PATTERNS.put(KindOfType.ARRAY_PRIMITIVE, "! java.util.Arrays.equals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(KindOfType.ARRAY, "! java.util.Arrays.deepEquals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(KindOfType.STRING, "(this.{VAR} == null) ? (other.{VAR} != null) : !this.{VAR}.equals(other.{VAR})");
        EQUALS_PATTERNS.put(KindOfType.OTHER, "this.{VAR} != other.{VAR} && (this.{VAR} == null || !this.{VAR}.equals(other.{VAR}))");
        HASH_CODE_PATTERNS = new EnumMap<KindOfType, String>(KindOfType.class);
        HASH_CODE_PATTERNS.put(KindOfType.PRIMITIVE, "this.{VAR}.hashCode()");
        HASH_CODE_PATTERNS.put(KindOfType.ARRAY_PRIMITIVE, "java.util.Arrays.hashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(KindOfType.ARRAY, "java.util.Arrays.deepHashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(KindOfType.STRING, "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        HASH_CODE_PATTERNS.put(KindOfType.OTHER, "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum KindOfType {
        PRIMITIVE,
        ARRAY_PRIMITIVE,
        ARRAY,
        STRING,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<EqualsHashCodeGenerator> arrayList = new ArrayList<EqualsHashCodeGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList;
            }
            try {
                EqualsHashCodeGenerator equalsHashCodeGenerator;
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = compilationController.getTrees().getElement(treePath);
                if (element != null && (equalsHashCodeGenerator = EqualsHashCodeGenerator.createEqualsHashCodeGenerator(jTextComponent, compilationController, element)) != null) {
                    arrayList.add(equalsHashCodeGenerator);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return arrayList;
        }
    }
}

