/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferencesStorage
implements StorageDescription<String, TypedValue> {
    private static final Logger LOG = Logger.getLogger(PreferencesStorage.class.getName());
    public static final String ID = "Preferences";
    private static final String E_ROOT = "editor-preferences";
    private static final String E_ENTRY = "entry";
    private static final String E_VALUE = "value";
    private static final String A_NAME = "name";
    private static final String A_VALUE = "value";
    private static final String A_VALUE_ID = "valueId";
    private static final String A_JAVA_TYPE = "javaType";
    private static final String A_CATEGORY = "category";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Preferences 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorPreferences-1_0.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-preferences";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isUsingProfiles() {
        return false;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getLegacyFileName() {
        return "properties.xml";
    }

    @Override
    public StorageReader<String, TypedValue> createReader(FileObject fileObject, String string) {
        if (MIME_TYPE.equals(fileObject.getMIMEType())) {
            return new Reader(fileObject, string);
        }
        return new LegacyReader(fileObject, string);
    }

    @Override
    public StorageWriter<String, TypedValue> createWriter(FileObject fileObject, String string) {
        return new Writer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Writer
    extends StorageWriter<String, TypedValue> {
        @Override
        public Document getDocument() {
            Object object;
            Object object2;
            Object object32;
            Document document = XMLUtil.createDocument((String)PreferencesStorage.E_ROOT, null, (String)PreferencesStorage.PUBLIC_ID, (String)PreferencesStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(PreferencesStorage.E_ROOT).item(0);
            TreeMap treeMap = new TreeMap(this.getAdded());
            for (Object object32 : treeMap.keySet()) {
                String string;
                Object object4;
                object2 = document.createElement(PreferencesStorage.E_ENTRY);
                node.appendChild((Node)object2);
                object2.setAttribute(PreferencesStorage.A_NAME, (String)object32);
                object = ((TypedValue)this.getAdded().get(object32)).getValue();
                if (((String)object).length() > 0) {
                    object4 = document.createElement("value");
                    object4.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)object)));
                    object2.appendChild((Node)object4);
                } else {
                    object2.setAttribute((String)object32, (String)object);
                }
                object4 = ((TypedValue)this.getAdded().get(object32)).getJavaType();
                if (object4 != null && ((String)object4).length() > 0) {
                    object2.setAttribute(PreferencesStorage.A_JAVA_TYPE, (String)object4);
                }
                if ((string = ((TypedValue)this.getAdded().get(object32)).getApiCategory()) != null && string.length() > 0) {
                    object2.setAttribute(PreferencesStorage.A_CATEGORY, string);
                }
                object2.setAttribute(PreferencesStorage.A_XML_SPACE, PreferencesStorage.V_PRESERVE);
            }
            ArrayList arrayList = new ArrayList(this.getRemoved());
            Collections.sort(arrayList);
            object32 = arrayList.iterator();
            while (object32.hasNext()) {
                object2 = (String)object32.next();
                object = document.createElement(PreferencesStorage.E_ENTRY);
                node.appendChild((Node)object);
                object.setAttribute(PreferencesStorage.A_NAME, (String)object2);
                object.setAttribute(PreferencesStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return document;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LegacyReader
    extends PreferencesReader {
        private static final String EL_ROOT = "properties";
        private static final String EL_PROPERTY = "property";
        private static final String AL_NAME = "name";
        private static final String AL_CLASS = "class";
        private static final String AL_VALUE = "value";
        private Map<String, TypedValue> entriesMap = new HashMap<String, TypedValue>();
        private String name = null;
        private String value = null;
        private String javaType = null;

        public LegacyReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, TypedValue> getAdded() {
            return this.entriesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_PROPERTY)) {
                this.name = attributes.getValue("name");
                this.value = attributes.getValue("value");
                this.javaType = attributes.getValue(AL_CLASS);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_PROPERTY)) {
                if (this.name != null && this.value != null) {
                    this.entriesMap.put(this.name, new TypedValue(this.value, this.javaType));
                } else {
                    LOG.warning("Ignoring editor preferences legacy entry {'" + this.name + "', '" + this.value + "'}!");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reader
    extends PreferencesReader {
        private Map<String, TypedValue> entriesMap = new HashMap<String, TypedValue>();
        private Set<String> removedEntries = new HashSet<String>();
        private String name = null;
        private String value = null;
        private String javaType = null;
        private String apiCategory = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;
        private static final String[] ALL_API_CATEGORIES = new String[]{"private", "stable", "devel", "friend", "deprecated"};

        public Reader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, TypedValue> getAdded() {
            return this.entriesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedEntries;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
                if (this.insideCdata) {
                    this.cdataText.append(cArray, n, n2);
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(PreferencesStorage.E_ROOT)) {
                if (string3.equals(PreferencesStorage.E_ENTRY)) {
                    boolean bl = Boolean.valueOf(attributes.getValue(PreferencesStorage.A_REMOVE));
                    this.name = null;
                    this.value = null;
                    this.javaType = null;
                    this.text = null;
                    this.cdataText = null;
                    if (bl) {
                        String string4 = attributes.getValue(PreferencesStorage.A_NAME);
                        this.removedEntries.add(string4);
                    } else {
                        String string5;
                        this.name = attributes.getValue(PreferencesStorage.A_NAME);
                        String string6 = attributes.getValue(PreferencesStorage.A_VALUE_ID);
                        if (string6 != null && (string5 = StorageSupport.getLocalizingBundleMessage(this.getProcessedFile(), string6, null)) != null) {
                            this.value = string5;
                        }
                        if ((string5 = attributes.getValue("value")) != null) {
                            if (this.value == null) {
                                this.value = string5;
                            } else {
                                LOG.warning("The 'valueId' attribute specified valid resource bundle key, ignoring the 'value' attribute!");
                            }
                        }
                        this.javaType = attributes.getValue(PreferencesStorage.A_JAVA_TYPE);
                        this.apiCategory = attributes.getValue(PreferencesStorage.A_CATEGORY);
                    }
                } else if (this.name != null && string3.equals("value")) {
                    if (this.value == null) {
                        this.text = new StringBuilder();
                        this.cdataText = new StringBuilder();
                        this.insideCdata = false;
                    } else {
                        LOG.warning("The 'value' or 'valueId' attribute was specified, ignoring the <value/> element!");
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(PreferencesStorage.E_ROOT)) {
                if (string3.equals(PreferencesStorage.E_ENTRY)) {
                    if (this.name != null) {
                        if (this.value != null) {
                            if (!this.entriesMap.containsKey(this.name)) {
                                TypedValue typedValue = new TypedValue(CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.value), this.javaType);
                                if (this.apiCategory != null && this.apiCategory.length() > 0) {
                                    typedValue.setApiCategory(Reader.checkApiCategory(this.apiCategory));
                                }
                                this.entriesMap.put(this.name, typedValue);
                            } else {
                                LOG.warning("Ignoring duplicate editor preferences entry '" + this.name + "'!");
                            }
                        } else {
                            LOG.warning("Ignoring editor preferences entry '" + this.name + "' that does not specify any value!");
                        }
                    }
                } else if (string3.equals("value") && this.text != null) {
                    this.value = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                }
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }

        private static String checkApiCategory(String string) {
            for (String string2 : ALL_API_CATEGORIES) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            return ALL_API_CATEGORIES[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PreferencesReader
    extends StorageReader<String, TypedValue> {
        protected PreferencesReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public abstract Map<String, TypedValue> getAdded();

        @Override
        public abstract Set<String> getRemoved();
    }
}

