/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.weblogic9.WLBaseDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.util.WLOutputManager;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class WLStartServer
extends StartServer {
    private static final Logger LOGGER = Logger.getLogger(WLStartServer.class.getName());
    private static final int SERVER_CHECK_TIMEOUT = 10000;
    private static final int AVERAGE_SERVER_INSTANCES = 2;
    private static Set<String> debuggingUris;
    private final WLBaseDeploymentManager dm;
    private Process serverProcess;

    private static synchronized void addDebugModeUri(String string) {
        if (debuggingUris == null) {
            debuggingUris = new HashSet<String>(2);
        }
        debuggingUris.add(string);
    }

    private static synchronized void removeDebugModeUri(String string) {
        if (debuggingUris == null) {
            return;
        }
        debuggingUris.remove(string);
    }

    private static synchronized boolean existsDebugModeUri(String string) {
        return debuggingUris != null && debuggingUris.contains(string);
    }

    public WLStartServer(DeploymentManager deploymentManager) {
        this.dm = (WLBaseDeploymentManager)deploymentManager;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINER, "Starting server in debug mode");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)string));
        RequestProcessor.getDefault().post((Runnable)new WLStartDebugRunnable(wLServerProgress), 0, 5);
        WLStartServer.addDebugModeUri(this.dm.getURI());
        return wLServerProgress;
    }

    public boolean isDebuggable(Target target) {
        if (!WLStartServer.existsDebugModeUri(this.dm.getURI())) {
            return false;
        }
        return this.isRunning();
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), new Integer(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINER, "Stopping server");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string));
        RequestProcessor.getDefault().post((Runnable)new WLStopRunnable(wLServerProgress), 0, 5);
        WLStartServer.removeDebugModeUri(this.dm.getURI());
        return wLServerProgress;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINER, "Starting server");
        WLServerProgress wLServerProgress = new WLServerProgress((Object)this);
        String string = this.dm.getInstanceProperties().getProperty("displayName");
        wLServerProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)string));
        RequestProcessor.getDefault().post((Runnable)new WLStartRunnable(wLServerProgress), 0, 5);
        WLStartServer.removeDebugModeUri(this.dm.getURI());
        return wLServerProgress;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean isRunning() {
        return this.isRunning(true);
    }

    public boolean isRunning(boolean bl) {
        block4: {
            Process process = this.dm.getServerProcess();
            if (process != null) {
                try {
                    process.exitValue();
                    return false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (bl) break block4;
                    return true;
                }
            }
        }
        if (bl) {
            String string = this.dm.getHost();
            int n = Integer.parseInt(this.dm.getPort().trim());
            return WLStartServer.ping(string, n, 10000);
        }
        return false;
    }

    private boolean isStopped() {
        int n;
        Process process = this.dm.getServerProcess();
        if (process != null) {
            try {
                process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
        String string = this.dm.getHost();
        return !WLStartServer.ping(string, n = new Integer(this.dm.getPort()).intValue(), 10000);
    }

    /*
     * Exception decompiling
     */
    public static boolean ping(String var0, int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    private static class WLDeploymentStatus
    implements DeploymentStatus {
        private ActionType action;
        private CommandType command;
        private StateType state;
        private String message;

        public WLDeploymentStatus(ActionType actionType, CommandType commandType, StateType stateType, String string) {
            this.action = actionType;
            this.command = commandType;
            this.state = stateType;
            this.message = string;
        }

        public ActionType getAction() {
            return this.action;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public String getMessage() {
            return this.message;
        }

        public StateType getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return StateType.COMPLETED.equals(this.state);
        }

        public boolean isFailed() {
            return StateType.FAILED.equals(this.state);
        }

        public boolean isRunning() {
            return StateType.RUNNING.equals(this.state);
        }
    }

    private static class WLServerProgress
    implements ProgressObject {
        private Vector listeners = new Vector();
        private DeploymentStatus deploymentStatus;
        private Object source;

        public WLServerProgress(Object object) {
            this.source = object;
        }

        public void notifyStart(StateType stateType, String string) {
            this.notify(new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, string));
        }

        public void notifyStop(StateType stateType, String string) {
            this.notify(new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, stateType, string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(DeploymentStatus deploymentStatus) {
            ProgressEvent progressEvent = new ProgressEvent(this.source, null, deploymentStatus);
            this.deploymentStatus = deploymentStatus;
            Vector vector = null;
            WLServerProgress wLServerProgress = this;
            synchronized (wLServerProgress) {
                if (this.listeners != null) {
                    vector = (Vector)this.listeners.clone();
                }
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ProgressListener progressListener = (ProgressListener)vector.elementAt(i);
                    progressListener.handleProgressEvent(progressEvent);
                }
            }
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.listeners.remove(progressListener);
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.listeners.add(progressListener);
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[0];
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }
    }

    private class WLStopRunnable
    implements Runnable {
        private String domainHome;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 900000;
        private static final int DELAY = 1000;
        private static final String SHUTDOWN_SH = "stopWebLogic.sh";
        private static final String SHUTDOWN_BAT = "stopWebLogic.cmd";

        public WLStopRunnable(WLServerProgress wLServerProgress) {
            this.serverProgress = wLServerProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WLOutputManager wLOutputManager = null;
            try {
                long l = System.currentTimeMillis();
                Process process = Runtime.getRuntime().exec(this.domainHome + "/bin/" + (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH));
                wLOutputManager = new WLOutputManager(process, WLStartServer.this.dm.getURI());
                wLOutputManager.start();
                String string = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - l < 900000L) {
                    if (WLStartServer.this.isStopped()) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        long l2 = (System.currentTimeMillis() - l) / 4L;
                        try {
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.serverProgress.notifyStop(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STOPPED", (Object)string));
                        return;
                    }
                    this.serverProgress.notifyStop(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)string));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StopServerTimeout"));
                process.destroy();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
            finally {
                if (WLStartServer.this.dm.getOutputManager() != null) {
                    WLStartServer.this.dm.getOutputManager().finish();
                }
                if (wLOutputManager != null) {
                    wLOutputManager.finish();
                }
            }
        }
    }

    private class WLStartDebugRunnable
    implements Runnable {
        private String domainHome;
        private String debuggerPort;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 900000;
        private static final int DELAY = 1000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";

        public WLStartDebugRunnable(WLServerProgress wLServerProgress) {
            this.serverProgress = wLServerProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
            this.debuggerPort = WLStartServer.this.dm.getInstanceProperties().getProperty("debuggerPort");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                File file = new File(this.domainHome);
                assert (file.isDirectory()) : "Working directory for weblogic does not exist:" + this.domainHome;
                NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(this.domainHome + "/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH), "");
                String[] stringArray = new String[]{"JAVA_OPTIONS=-Xdebug -Xnoagent -Djava.compiler=none -Xrunjdwp:server=y,suspend=n,transport=dt_socket,address=" + this.debuggerPort};
                WLStartServer.this.serverProcess = nbProcessDescriptor.exec(null, stringArray, true, file);
                WLStartServer.this.dm.setServerProcess(WLStartServer.this.serverProcess);
                WLOutputManager wLOutputManager = new WLOutputManager(WLStartServer.this.serverProcess, WLStartServer.this.dm.getURI());
                WLStartServer.this.dm.setOutputManager(wLOutputManager);
                wLOutputManager.start();
                String string = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - l < 900000L) {
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)string));
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StartServerTimeout"));
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }

    private class WLStartRunnable
    implements Runnable {
        private String domainHome;
        private WLServerProgress serverProgress;
        private static final int TIMEOUT = 900000;
        private static final int DELAY = 5000;
        private static final String STARTUP_SH = "startWebLogic.sh";
        private static final String STARTUP_BAT = "startWebLogic.cmd";

        public WLStartRunnable(WLServerProgress wLServerProgress) {
            this.serverProgress = wLServerProgress;
            this.domainHome = WLStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                WLStartServer.this.serverProcess = Runtime.getRuntime().exec(this.domainHome + "/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH));
                WLStartServer.this.dm.setServerProcess(WLStartServer.this.serverProcess);
                WLOutputManager wLOutputManager = new WLOutputManager(WLStartServer.this.serverProcess, WLStartServer.this.dm.getURI());
                WLStartServer.this.dm.setOutputManager(wLOutputManager);
                wLOutputManager.start();
                String string = WLStartServer.this.dm.getInstanceProperties().getProperty("displayName");
                while (System.currentTimeMillis() - l < 900000L) {
                    if (WLStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)string));
                        return;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_StartServerTimeout"));
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }
}

