/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.modules.web.debug.watchesfiltering.WatchPanel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JspWatchesActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_WATCH_ACTION = new AbstractAction(NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_AddNew")){

        public void actionPerformed(ActionEvent actionEvent) {
            JspWatchesActionsProvider.newWatch();
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_DeleteAll")){

        public void actionPerformed(ActionEvent actionEvent) {
            DebuggerManager.getDebuggerManager().removeAllWatches();
        }
    };
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ((JspElWatch)objectArray[i]).getWatch().remove();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action CUSTOMIZE_ACTION;

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof JspElWatch) {
            return new Action[]{NEW_WATCH_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null, CUSTOMIZE_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof JspElWatch) {
            JspWatchesActionsProvider.customize(((JspElWatch)object).getWatch());
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static void customize(Watch watch) {
        WatchPanel watchPanel = new WatchPanel(watch.getExpression());
        JComponent jComponent = watchPanel.getPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, NbBundle.getMessage(JspWatchesActionsProvider.class, (String)"CTL_Edit_Watch_Dialog_Title", (Object)watch.getExpression()));
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.add.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        watch.setExpression(watchPanel.getExpression());
    }

    private static void newWatch() {
        WatchPanel watchPanel = new WatchPanel("");
        JComponent jComponent = watchPanel.getPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, NbBundle.getMessage(JspWatchesActionsProvider.class, (String)"CTL_New_Watch_Dialog_Title"));
        dialogDescriptor.setHelpCtx(new HelpCtx("debug.new.watch"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
            return;
        }
        DebuggerManager.getDebuggerManager().createWatch(watchPanel.getExpression());
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getBundle(JspWatchesActionsProvider.class).getString("CTL_WatchAction_Customize"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                JspWatchesActionsProvider.customize(((JspElWatch)objectArray[0]).getWatch());
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }
}

