/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.variablesfilterring;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.web.debug.variablesfilterring.JSPVariablesFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class JSPVariablesNodeModelFilter
implements ExtendedNodeModelFilter {
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private RequestProcessor evaluationRP;
    private final Map<ObjectVariable, String> shortDescriptionMap = new IdentityHashMap<ObjectVariable, String>();
    private final Collection modelListeners = new HashSet();

    public JSPVariablesNodeModelFilter(ContextProvider contextProvider) {
        this.evaluationRP = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        String string = "";
        if (object instanceof JSPVariablesFilter.ImplicitLocals) {
            string = NbBundle.getMessage(JSPVariablesFilter.class, (String)"LBL_IMPLICIT_LOCALS");
        } else if (object instanceof JSPVariablesFilter.AttributeMap) {
            String string2 = "";
            String string3 = ((JSPVariablesFilter.AttributeMap)object).getOwnerName();
            if (string3.equals("request")) {
                string2 = "LBL_REQUEST_ATTRIBUTES";
            } else if (string3.equals("session")) {
                string2 = "LBL_SESSION_ATTRIBUTES";
            } else if (string3.equals("application")) {
                string2 = "LBL_APPLICATION_ATTRIBUTES";
            }
            string = NbBundle.getMessage(JSPVariablesFilter.class, (String)string2);
        } else {
            string = object instanceof JSPVariablesFilter.AttributeMap.Attribute ? ((JSPVariablesFilter.AttributeMap.Attribute)object).getName() : nodeModel.getDisplayName(object);
        }
        return string;
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        throw new IllegalStateException("getIconBaseWithExtension should be always called instead");
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        String string = "";
        string = object instanceof JSPVariablesFilter.ImplicitLocals ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_IMPLICIT_LOCALS_GROUP") : (object instanceof JSPVariablesFilter.AttributeMap ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_ATTRIBUTES_GROUP") : (object instanceof JSPVariablesFilter.AttributeMap.Attribute ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_ATTRIBUTE_VALUE") : extendedNodeModel.getIconBaseWithExtension(object)));
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        String string = "";
        if (object instanceof JSPVariablesFilter.ImplicitLocals) {
            string = NbBundle.getMessage(JSPVariablesFilter.class, (String)"TLT_IMPLICIT_LOCALS");
        } else if (object instanceof JSPVariablesFilter.AttributeMap) {
            String string2;
            String string3 = ((JSPVariablesFilter.AttributeMap)object).getOwnerName();
            if (string3.equals("request")) {
                string2 = "TLT_REQUEST_ATTRIBUTES";
            } else if (string3.equals("session")) {
                string2 = "TLT_SESSION_ATTRIBUTES";
            } else if (string3.equals("application")) {
                string2 = "TLT_APPLICATION_ATTRIBUTES";
            } else {
                throw new JSPVariablesFilter.AttributeMap.UnknownOwnerNameException(string3);
            }
            string = NbBundle.getMessage(JSPVariablesFilter.class, (String)string2);
        } else if (object instanceof JSPVariablesFilter.AttributeMap.Attribute) {
            Variable variable = ((JSPVariablesFilter.AttributeMap.Attribute)object).getValue();
            String string4 = variable.getType();
            String string5 = variable.getValue();
            if (variable instanceof ObjectVariable) {
                final ObjectVariable objectVariable = (ObjectVariable)variable;
                Map<ObjectVariable, String> map = this.shortDescriptionMap;
                synchronized (map) {
                    String string6 = this.shortDescriptionMap.remove(objectVariable);
                    if (string6 != null) {
                        return "(" + string4 + ") " + string6;
                    }
                }
                this.evaluationRP.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        String string = JSPVariablesNodeModelFilter.this.getShortDescriptionSynch(objectVariable);
                        if (string != null && !"".equals(string)) {
                            Map map = JSPVariablesNodeModelFilter.this.shortDescriptionMap;
                            synchronized (map) {
                                JSPVariablesNodeModelFilter.this.shortDescriptionMap.put(objectVariable, string);
                            }
                            JSPVariablesNodeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)JSPVariablesNodeModelFilter.this, (Object)objectVariable, 4));
                        }
                    }
                });
                return "";
            }
            string = "(" + string4 + ") " + string5;
        } else {
            string = nodeModel.getShortDescription(object);
        }
        return string;
    }

    private static String getLimitedToString(ObjectVariable objectVariable) throws InvalidExpressionException {
        String string = null;
        try {
            Method method = objectVariable.getClass().getMethod("getToStringValue", Integer.TYPE);
            method.setAccessible(true);
            string = (String)method.invoke((Object)objectVariable, 10000);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            string = objectVariable.getToStringValue();
        }
        return string;
    }

    private String getShortDescriptionSynch(ObjectVariable objectVariable) {
        try {
            return JSPVariablesNodeModelFilter.getLimitedToString(objectVariable);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            return invalidExpressionException.getLocalizedMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("not supported");
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("not supported");
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        return new PasteType[0];
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
    }
}

