/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage.api;

import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCoverageSummary
implements Comparable<FileCoverageSummary> {
    private final FileObject file;
    private final String displayName;
    private final int lineCount;
    private final int executedLineCount;
    private final int inferredCount;
    private final int partialCount;

    public FileCoverageSummary(FileObject fileObject, String string, int n, int n2, int n3, int n4) {
        this.file = fileObject;
        this.displayName = string;
        this.lineCount = n;
        this.executedLineCount = n2;
        this.inferredCount = n3;
        this.partialCount = n4;
    }

    public float getCoveragePercentage() {
        if (this.lineCount == 0) {
            return 0.0f;
        }
        return 100.0f * (float)this.executedLineCount / (float)this.lineCount;
    }

    @Override
    public int compareTo(FileCoverageSummary fileCoverageSummary) {
        float f;
        float f2 = this.getCoveragePercentage();
        if (f2 == (f = fileCoverageSummary.getCoveragePercentage())) {
            return 0;
        }
        return f2 < f ? -1 : 1;
    }

    public FileObject getFile() {
        return this.file;
    }

    public int getExecutedLineCount() {
        return this.executedLineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getInferredCount() {
        return this.inferredCount;
    }

    public int getPartialCount() {
        return this.partialCount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName + ": " + this.getCoveragePercentage() + "%";
    }
}

