/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.gsf.codecoverage.CoverageHighlightsContainer;
import org.netbeans.modules.gsf.codecoverage.CoverageHighlightsLayerFactory;
import org.netbeans.modules.gsf.codecoverage.CoverageReportTopComponent;
import org.netbeans.modules.gsf.codecoverage.CoverageSideBar;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class CoverageManagerImpl
implements CoverageManager {
    public static final String COVERAGE_INSTANCE_FILE = "coverage.instance";
    private static final String MIME_TYPE = "mimeType";
    private static final String COVERAGE_DOC_PROPERTY = "coverage";
    private static final String PREF_EDITOR_BAR = "editorBar";
    private Set<String> enabledMimeTypes = new HashSet<String>();
    private Map<Project, CoverageReportTopComponent> showingReports = new HashMap<Project, CoverageReportTopComponent>();
    private Boolean showEditorBar;

    static CoverageManagerImpl getInstance() {
        return (CoverageManagerImpl)CoverageManager.INSTANCE;
    }

    public void setEnabled(final Project project, final boolean bl) {
        final CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider == null) {
            return;
        }
        Set<String> set = coverageProvider.getMimeTypes();
        if (bl) {
            this.enabledMimeTypes.addAll(set);
        } else {
            this.enabledMimeTypes.removeAll(set);
        }
        coverageProvider.setEnabled(bl);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoverageManagerImpl.this.resultsUpdated(project, coverageProvider);
                if (!bl) {
                    for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
                        Document document = jTextComponent.getDocument();
                        CoverageSideBar coverageSideBar = CoverageSideBar.getSideBar(document);
                        if (coverageSideBar == null) continue;
                        coverageSideBar.showCoveragePanel(false);
                    }
                }
            }
        });
    }

    public boolean isAggregating(Project project) {
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider != null) {
            return coverageProvider.isAggregating();
        }
        return false;
    }

    public void setAggregating(Project project, boolean bl) {
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider == null) {
            return;
        }
        coverageProvider.setAggregating(bl);
    }

    void focused(FileObject fileObject, JTextComponent jTextComponent) {
        CoverageProvider coverageProvider;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (coverageProvider = CoverageManagerImpl.getProvider(project)) != null && coverageProvider.isEnabled()) {
            try {
                EditorCookie editorCookie = (EditorCookie)DataLoadersBridge.getDefault().getCookie(fileObject, EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.getDocument();
                    if (styledDocument == null) {
                        return;
                    }
                    styledDocument.putProperty(COVERAGE_DOC_PROPERTY, null);
                    CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsLayerFactory.getContainer(styledDocument);
                    if (coverageHighlightsContainer != null) {
                        coverageHighlightsContainer.refresh();
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    void showFile(Project project, FileCoverageSummary fileCoverageSummary) {
        FileObject fileObject = fileCoverageSummary.getFile();
        if (fileObject == null) {
            String string = fileCoverageSummary.getDisplayName();
            File file = new File(string);
            fileObject = file.exists() ? FileUtil.toFileObject((File)file) : project.getProjectDirectory().getFileObject(string.replace('\\', '/'));
        }
        if (fileObject != null) {
            GsfUtilities.open((FileObject)fileObject, (int)-1, null);
        }
    }

    static CoverageProvider getProvider(Project project) {
        if (project != null) {
            return (CoverageProvider)project.getLookup().lookup(CoverageProvider.class);
        }
        return null;
    }

    public boolean isEnabled(Project project) {
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider != null) {
            return coverageProvider.isEnabled();
        }
        return false;
    }

    public boolean isEnabled(String string) {
        return this.enabledMimeTypes.contains(string);
    }

    FileCoverageDetails getDetails(Project project, FileObject fileObject, Document document) {
        CoverageProvider coverageProvider;
        if (project != null && (coverageProvider = CoverageManagerImpl.getProvider(project)) != null && coverageProvider.isEnabled()) {
            FileCoverageDetails fileCoverageDetails = (FileCoverageDetails)document.getProperty(COVERAGE_DOC_PROPERTY);
            if (fileCoverageDetails == null) {
                CoverageSideBar coverageSideBar;
                fileCoverageDetails = coverageProvider.getDetails(fileObject, document);
                document.putProperty(COVERAGE_DOC_PROPERTY, fileCoverageDetails);
                if (this.getShowEditorBar() && (coverageSideBar = CoverageSideBar.getSideBar(document)) != null) {
                    coverageSideBar.showCoveragePanel(true);
                    coverageSideBar.setCoverage(fileCoverageDetails);
                }
                return fileCoverageDetails;
            }
            return fileCoverageDetails;
        }
        return null;
    }

    public void resultsUpdated(Project project, CoverageProvider coverageProvider) {
        Set<String> set = coverageProvider.getMimeTypes();
        for (Object object2 : EditorRegistry.componentList()) {
            FileObject fileObject;
            Document document = ((JTextComponent)object2).getDocument();
            String string = (String)document.getProperty(MIME_TYPE);
            if (string == null || !set.contains(string) || (fileObject = GsfUtilities.findFileObject((Document)document)) == null || FileOwnerQuery.getOwner((FileObject)fileObject) != project) continue;
            FileCoverageDetails fileCoverageDetails = (FileCoverageDetails)document.getProperty(COVERAGE_DOC_PROPERTY);
            if (fileCoverageDetails == null) {
                document.putProperty(COVERAGE_DOC_PROPERTY, null);
            }
            if (this.isEnabled(project)) {
                this.focused(fileObject, (JTextComponent)object2);
                continue;
            }
            CoverageHighlightsContainer coverageHighlightsContainer = CoverageHighlightsLayerFactory.getContainer(document);
            if (coverageHighlightsContainer == null) continue;
            coverageHighlightsContainer.refresh();
        }
        Object object = this.showingReports.get(project);
        if (object != null) {
            Object object2;
            object2 = coverageProvider.getResults();
            ((CoverageReportTopComponent)((Object)object)).updateData((List<FileCoverageSummary>)object2);
        }
    }

    public void clear(Project project) {
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider != null) {
            coverageProvider.clear();
            this.resultsUpdated(project, coverageProvider);
        }
    }

    void closedReport(Project project) {
        this.showingReports.remove(project);
    }

    public void showReport(Project project) {
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider != null) {
            List<FileCoverageSummary> list = coverageProvider.getResults();
            CoverageReportTopComponent coverageReportTopComponent = this.showingReports.get(project);
            if (coverageReportTopComponent == null) {
                coverageReportTopComponent = new CoverageReportTopComponent(project, list);
                this.showingReports.put(project, coverageReportTopComponent);
                coverageReportTopComponent.open();
            }
            coverageReportTopComponent.toFront();
            coverageReportTopComponent.requestVisible();
        }
    }

    public boolean getShowEditorBar() {
        if (this.showEditorBar == null) {
            this.showEditorBar = NbPreferences.forModule(CoverageManager.class).getBoolean(PREF_EDITOR_BAR, true);
        }
        return this.showEditorBar == Boolean.TRUE;
    }

    public void setShowEditorBar(boolean bl) {
        this.showEditorBar = bl;
        NbPreferences.forModule(CoverageManager.class).putBoolean(PREF_EDITOR_BAR, bl);
        for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
            Document document = jTextComponent.getDocument();
            CoverageSideBar coverageSideBar = CoverageSideBar.getSideBar(document);
            if (coverageSideBar == null) continue;
            coverageSideBar.showCoveragePanel(bl);
        }
    }
}

