/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class WatchesNodeModel
extends VariablesNodeModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";

    public WatchesNodeModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public static boolean isEmptyWatch(Object object) {
        return "EmptyWatch".equals(object.getClass().getSimpleName());
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(WatchesNodeModel.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModel.isEmptyWatch(object)) {
                return "<_html><font color=\"#808080\">&lt;" + NbBundle.getBundle(WatchesNodeModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint") + "&gt;</font></html>";
            }
            return ((JPDAWatch)object).getExpression();
        }
        return super.getDisplayName(object);
    }

    protected String getShortDescriptionSynch(Object object) {
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModel.isEmptyWatch(object)) {
                return NbBundle.getMessage(WatchesNodeModel.class, (String)"TTP_NewWatch");
            }
            JPDAWatch jPDAWatch = (JPDAWatch)object;
            boolean bl = VariablesTreeModelFilter.isEvaluated(object);
            if (!bl) {
                return jPDAWatch.getExpression();
            }
            String string = jPDAWatch.getExceptionDescription();
            if (string != null) {
                return jPDAWatch.getExpression() + " = >" + string + "<";
            }
            String string2 = jPDAWatch.getType();
            if (string2 == null) {
                return jPDAWatch.getExpression() + " = " + jPDAWatch.getValue();
            }
            try {
                return jPDAWatch.getExpression() + " = (" + jPDAWatch.getType() + ") " + jPDAWatch.getToStringValue();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return super.getShortDescriptionSynch(object);
    }

    protected void testKnown(Object object) throws UnknownTypeException {
        if (object instanceof JPDAWatch) {
            return;
        }
        super.testKnown(object);
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return object instanceof JPDAWatch;
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return object instanceof JPDAWatch && !WatchesNodeModel.isEmptyWatch(object);
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return object instanceof JPDAWatch && !WatchesNodeModel.isEmptyWatch(object);
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        return new StringSelection(((JPDAWatch)object).getExpression());
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        return new StringSelection(((JPDAWatch)object).getExpression());
    }

    public PasteType[] getPasteTypes(final Object object, final Transferable transferable) throws UnknownTypeException {
        if (object != "Root" && !(object instanceof JPDAWatch)) {
            return null;
        }
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        final DataFlavor dataFlavor = DataFlavor.selectBestTextFlavor(dataFlavorArray);
        if (dataFlavor != null) {
            return new PasteType[]{new PasteType(){

                public Transferable paste() {
                    try {
                        Reader reader = dataFlavor.getReaderForText(transferable);
                        CharBuffer charBuffer = CharBuffer.allocate(1000);
                        reader.read(charBuffer);
                        charBuffer.flip();
                        if (object instanceof JPDAWatch) {
                            ((JPDAWatch)object).setExpression(charBuffer.toString());
                            WatchesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)WatchesNodeModel.this, object));
                        } else {
                            DebuggerManager.getDebuggerManager().createWatch(charBuffer.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            }};
        }
        return null;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        ((JPDAWatch)object).setExpression(string);
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WATCH;
        }
        if (object instanceof JPDAWatch) {
            if (WatchesNodeModel.isEmptyWatch(object)) {
                return null;
            }
            return WATCH;
        }
        return super.getIconBaseWithExtension(object);
    }
}

