/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.modules.debugger.jpda.ui.debugging.KeyboardPopupSwitcher;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadsHistoryAction
extends AbstractAction {
    public ThreadsHistoryAction() {
        this.putValue("Name", NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_ThreadsHistoryAction"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        KeyStroke keyStroke;
        List<JPDAThread> list = ThreadsHistoryAction.getThreads();
        int n = list.size();
        if (n < 1) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!"immediately".equals(actionEvent.getActionCommand()) && !(actionEvent.getSource() instanceof JMenuItem) && (keyStroke = Utilities.stringToKey((String)actionEvent.getActionCommand())) != null) {
            int n2 = keyStroke.getKeyCode();
            int n3 = 0;
            int n4 = keyStroke.getModifiers();
            if ((2 & n4) != 0) {
                n3 = 17;
            } else if ((8 & n4) != 0) {
                n3 = 18;
            } else if ((4 & n4) != 0) {
                n3 = 4;
            }
            if (n3 != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    KeyboardPopupSwitcher.selectItem(ThreadsHistoryAction.createSwitcherItems(list), n3, n2, true, true);
                }
                return;
            }
        }
        if (n == 1) {
            list.get(0).makeCurrent();
        } else {
            int n5 = (actionEvent.getModifiers() & 1) == 0 ? 1 : n - 1;
            list.get(n5).makeCurrent();
        }
    }

    public static SwitcherTableItem[] createSwitcherItems(List<JPDAThread> list) {
        Set set;
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        JPDADebugger jPDADebugger = threadsListener.getDebugger();
        JPDAThread jPDAThread = jPDADebugger != null ? jPDADebugger.getCurrentThread() : null;
        Set set2 = set = jPDADebugger != null ? jPDADebugger.getThreadsCollector().getDeadlockDetector().getDeadlocks() : Collections.EMPTY_SET;
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet();
        for (DeadlockDetector.Deadlock deadlock : set) {
            hashSet.addAll(deadlock.getThreads());
        }
        SwitcherTableItem[] switcherTableItemArray = new SwitcherTableItem[list.size()];
        int n = 0;
        for (JPDAThread jPDAThread2 : list) {
            Object object;
            Image image;
            String string;
            Object object2;
            String string2;
            try {
                string2 = DebuggingNodeModel.getDisplayName(jPDAThread2, false);
                object2 = jPDAThread2.getClass().getMethod("getDebugger", new Class[0]);
                string = (JPDADebugger)((Method)object2).invoke((Object)jPDAThread2, new Object[0]);
                object2 = string.getClass().getMethod("getSession", new Class[0]);
                image = (Session)((Method)object2).invoke((Object)string, new Object[0]);
                object = DebuggerManager.getDebuggerManager().getCurrentSession();
                if (image != object) {
                    String string3 = NbBundle.getMessage(ThreadsHistoryAction.class, (String)"CTL_Session", (Object)image.getName());
                    string2 = string2.charAt(0) + string3 + ", " + string2.substring(1);
                }
            }
            catch (Exception exception) {
                string2 = jPDAThread2.getName();
            }
            object2 = string2;
            string = "";
            image = ImageUtilities.loadImage((String)DebuggingNodeModel.getIconBase(jPDAThread2));
            object = null;
            if (image != null) {
                boolean bl = jPDAThread2 == jPDAThread;
                boolean bl2 = threadsListener.isBreakpointHit(jPDAThread2);
                boolean bl3 = hashSet.contains(jPDAThread2);
                object = new ThreadStatusIcon(image, bl, bl2, bl3);
            }
            switcherTableItemArray[n] = new SwitcherTableItem(new ActivatableElement(jPDAThread2), string2, (String)object2, (Icon)object, false, string != null ? string : string2);
            ++n;
        }
        return switcherTableItemArray;
    }

    public static List<JPDAThread> getThreads() {
        ThreadsListener threadsListener = ThreadsListener.getDefault();
        if (threadsListener == null) {
            return Collections.emptyList();
        }
        List<JPDAThread> list = threadsListener.getCurrentThreadsHistory();
        List<JPDAThread> list2 = threadsListener.getThreads();
        HashSet<JPDAThread> hashSet = new HashSet<JPDAThread>();
        for (JPDAThread object2 : threadsListener.getHits()) {
            hashSet.add(object2);
        }
        HashSet<JPDAThread> hashSet2 = new HashSet<JPDAThread>(list);
        LinkedList<JPDAThread> linkedList = new LinkedList<JPDAThread>();
        linkedList.addAll(list);
        for (JPDAThread n2 : list2) {
            if (hashSet2.contains(n2) || !n2.isSuspended()) continue;
            linkedList.add(n2);
        }
        if (linkedList.size() > 1 && hashSet.size() > 0) {
            int n = 1;
            int n2 = linkedList.size();
            for (int i = 1; i < n2; ++i) {
                JPDAThread jPDAThread = (JPDAThread)linkedList.get(i);
                if (!hashSet.contains(jPDAThread)) continue;
                if (i > n) {
                    linkedList.remove(i);
                    linkedList.add(n, jPDAThread);
                }
                ++n;
            }
        }
        return linkedList;
    }

    private static class ThreadStatusIcon
    implements Icon {
        private Image image;
        private ImageIcon iconBase;
        private boolean isCurrent;
        private boolean isAtBreakpoint;
        private boolean isInDeadlock;

        ThreadStatusIcon(Image image, boolean bl, boolean bl2, boolean bl3) {
            this.image = image;
            this.isCurrent = bl;
            this.isAtBreakpoint = bl2;
            this.isInDeadlock = bl3;
            this.iconBase = new ImageIcon(image);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.iconBase.getIconWidth();
            int n4 = this.iconBase.getIconHeight();
            Color color = null;
            Color color2 = null;
            if (this.isInDeadlock) {
                color = DebuggingView.deadlockColor;
            } else if (this.isCurrent) {
                color = DebuggingView.greenBarColor;
            } else if (this.isAtBreakpoint) {
                color = DebuggingView.hitsBarColor;
            }
            if (this.isCurrent && this.isInDeadlock) {
                color2 = DebuggingView.greenBarColor;
            }
            Color color3 = graphics.getColor();
            graphics.setColor(component.getBackground());
            graphics.fillRect(n, n2, n3, n4);
            graphics.drawImage(this.image, n + n3, n2, this.iconBase.getImageObserver());
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(n, n2, 8, n4);
            }
            if (color2 != null) {
                graphics.setColor(color2);
                int n5 = 5;
                graphics.fillRect(n + 8 - n5, n2, n5, n4);
            }
            graphics.setColor(color3);
        }

        public int getIconWidth() {
            return 2 * this.iconBase.getIconWidth();
        }

        public int getIconHeight() {
            return this.iconBase.getIconHeight();
        }
    }

    private static class ActivatableElement
    implements SwitcherTableItem.Activatable {
        JPDAThread thread;

        private ActivatableElement(JPDAThread jPDAThread) {
            this.thread = jPDAThread;
        }

        public void activate() {
            this.thread.makeCurrent();
        }
    }
}

