/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class J2seJaxWsLookupProvider
implements LookupProvider {
    private String JAX_WS_XML_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml";
    private String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-j2se.xsl";
    private String JAXWS_EXTENSION = "jaxws";
    private String COMPILE_ON_SAVE_UNSUPPORTED = "compile.on.save.unsupported.jaxws";

    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            return null;
        }
        final JaxWsModel jaxWsModel = this.getJaxWsModel(project);
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(){
            private FileChangeListener jaxWsListener;
            private ChangeListener jaxWsCreationListener;

            protected void projectOpened() {
                AntBuildExtender antBuildExtender;
                if (jaxWsModel != null && (antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class)) != null) {
                    AntBuildExtender.Extension extension;
                    FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                    try {
                        extension = antBuildExtender.getExtension(J2seJaxWsLookupProvider.this.JAXWS_EXTENSION);
                        if (fileObject == null || extension == null) {
                            if (jaxWsModel.getClients().length > 0) {
                                J2seJaxWsLookupProvider.this.addJaxWsExtension(project, J2seJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender);
                            }
                        } else if (jaxWsModel.getClients().length == 0) {
                            J2seJaxWsLookupProvider.this.removeJaxWsExtension(project, fileObject, antBuildExtender);
                        } else {
                            FileObject fileObject2 = project.getProjectDirectory().getFileObject("nbproject/project.xml");
                            if (fileObject2 != null) {
                                J2seJaxWsLookupProvider.this.removeCompileDependencies(project, fileObject2, antBuildExtender);
                            }
                            J2seJaxWsLookupProvider.this.addJaxWsApiEndorsed(project);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    extension = jaxWsModel.getJaxWsFile();
                    if (extension != null) {
                        this.jaxWsListener = new FileChangeAdapter(){

                            public void fileChanged(FileEvent fileEvent) {
                                this.handleJaxsClientBuildScript();
                            }
                        };
                        extension.addFileChangeListener(this.jaxWsListener);
                    } else {
                        this.jaxWsCreationListener = new ChangeListener(){

                            public void stateChanged(ChangeEvent changeEvent) {
                                FileObject fileObject = jaxWsModel.getJaxWsFile();
                                if (fileObject != null) {
                                    jaxWsListener = (FileChangeListener)new FileChangeAdapter(){

                                        public void fileChanged(FileEvent fileEvent) {
                                            this.handleJaxsClientBuildScript();
                                        }
                                    };
                                    fileObject.addFileChangeListener(jaxWsListener);
                                }
                            }
                        };
                        jaxWsModel.addChangeListener(this.jaxWsCreationListener);
                    }
                }
            }

            protected void projectClosed() {
                if (jaxWsModel != null) {
                    jaxWsModel.removeChangeListener(this.jaxWsCreationListener);
                    FileObject fileObject = jaxWsModel.getJaxWsFile();
                    if (fileObject != null) {
                        fileObject.removeFileChangeListener(this.jaxWsListener);
                    }
                }
            }

            private void handleJaxsClientBuildScript() {
                AntBuildExtender antBuildExtender = (AntBuildExtender)project.getLookup().lookup(AntBuildExtender.class);
                if (antBuildExtender != null) {
                    FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
                    try {
                        if (jaxWsModel.getClients().length == 0) {
                            J2seJaxWsLookupProvider.this.removeJaxWsExtension(project, fileObject, antBuildExtender);
                        } else {
                            J2seJaxWsLookupProvider.this.addJaxWsExtension(project, J2seJaxWsLookupProvider.this.JAX_WS_STYLESHEET_RESOURCE, antBuildExtender);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        return Lookups.fixed((Object[])new Object[]{projectOpenedHook, jaxWsModel});
    }

    private JaxWsModel getJaxWsModel(Project project) {
        try {
            FileObject fileObject = this.findJaxWsFileObject(project);
            if (fileObject == null) {
                return JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream(this.JAX_WS_XML_RESOURCE));
            }
            JaxWsModel jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(fileObject);
            return jaxWsModel;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
    }

    private void addJaxWsExtension(Project project, String string, AntBuildExtender antBuildExtender) throws IOException {
        TransformerUtils.transformClients(project.getProjectDirectory(), string);
        FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension == null) {
            extension = antBuildExtender.addExtension(this.JAXWS_EXTENSION, fileObject);
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            this.disableCompileOnSave(project);
            ProjectManager.getDefault().saveProject(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJaxWsExtension(Project project, FileObject fileObject, final AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    antBuildExtender.removeExtension(J2seJaxWsLookupProvider.this.JAXWS_EXTENSION);
                }
            });
            this.enableCompileOnSave(project);
            ProjectManager.getDefault().saveProject(project);
        }
        if (fileObject != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    private void removeCompileDependencies(Project project, FileObject fileObject, AntBuildExtender antBuildExtender) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.contains("wsimport-client-compile")) continue;
            bl = true;
            break;
        }
        bufferedReader.close();
        if (bl) {
            TransformerUtils.transformClients(project.getProjectDirectory(), this.JAX_WS_STYLESHEET_RESOURCE);
            AntBuildExtender.Extension extension = antBuildExtender.getExtension(this.JAXWS_EXTENSION);
            if (extension != null) {
                extension.removeDependency("-do-compile", "wsimport-client-compile");
                extension.removeDependency("-do-compile-single", "wsimport-client-compile");
                ProjectManager.getDefault().saveProject(project);
            }
        }
    }

    private void disableCompileOnSave(Project project) throws IOException {
        EditableProperties editableProperties = WSUtils.getEditableProperties(project, "nbproject/project.properties");
        editableProperties.put(this.COMPILE_ON_SAVE_UNSUPPORTED, "true");
        WSUtils.storeEditableProperties(project, "nbproject/project.properties", editableProperties);
    }

    private void enableCompileOnSave(Project project) throws IOException {
        EditableProperties editableProperties = WSUtils.getEditableProperties(project, "nbproject/project.properties");
        editableProperties.remove((Object)this.COMPILE_ON_SAVE_UNSUPPORTED);
        WSUtils.storeEditableProperties(project, "nbproject/project.properties", editableProperties);
    }

    private void addJaxWsApiEndorsed(Project project) throws IOException {
        String string;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0 && (string = System.getProperty("java.version")).compareTo("1.6") >= 0) {
            WSUtils.addJaxWsApiEndorsed(project, sourceGroupArray[0].getRootFolder());
        }
    }
}

