/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.wizards.TemplatePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class TemplateIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private TemplatePanel templatePanel;
    private transient SourceGroup[] sourceGroups;
    private static final String CSS_FOLDER = "css";
    private static final String CSS_FOLDER2 = "resources/css";
    private static final String CSS_EXT = "css";
    private static final String XHTML_EXT = "xhtml";
    private static final String ENCODING = "UTF-8";
    private static String TEMPLATE_XHTML = "template.xhtml";
    private static String TEMPLATE_XHTML2 = "template-jsf2.xhtml";
    private static String FL_RESOURCE_FOLDER = "org/netbeans/modules/web/jsf/facelets/resources/templates/";

    static FileObject createTemplate(Project project, FileObject fileObject, boolean bl) throws IOException {
        FileObject fileObject2 = null;
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            FileObject fileObject3 = webModule.getDocumentBase();
            if (fileObject3.getFileObject(TEMPLATE_XHTML) != null) {
                return null;
            }
            if (bl && !JSFConfigUtilities.hasJsfFramework(fileObject3)) {
                JSFConfigUtilities.extendJsfFramework(fileObject3, false);
            }
            boolean bl2 = TemplateIterator.isJSF20(webModule);
            String string = TEMPLATE_XHTML;
            if (bl2) {
                string = TEMPLATE_XHTML2;
            }
            String string2 = JSFFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(FL_RESOURCE_FOLDER + string), ENCODING);
            fileObject2 = FileUtil.createData((FileObject)fileObject, (String)TEMPLATE_XHTML);
            JSFFrameworkProvider.createFile(fileObject2, string2, ENCODING);
        }
        return fileObject2;
    }

    private static boolean isJSF20(WebModule webModule) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        boolean bl = classPath.findResource("javax.faces.application.ProjectStage".replace('.', '/') + ".class") != null;
        return bl;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        WebModule webModule;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        final String string = Templates.getTargetName((WizardDescriptor)templateWizard);
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        if (dataFolder != null && (webModule = WebModule.getWebModule((FileObject)dataFolder.getPrimaryFile())) != null) {
            final FileObject fileObject2 = webModule.getDocumentBase();
            if (!JSFConfigUtilities.hasJsfFramework(fileObject2)) {
                JSFConfigUtilities.extendJsfFramework(fileObject, false);
            }
            final boolean bl = TemplateIterator.isJSF20(webModule);
            dataFolder.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    InputStream inputStream;
                    String string6;
                    FileObject fileObject;
                    FileObject fileObject22 = dataFolder.getPrimaryFile().createData(string, TemplateIterator.XHTML_EXT);
                    String string2 = bl ? TemplateIterator.CSS_FOLDER2 : "css";
                    FileObject fileObject3 = fileObject2.getFileObject(string2);
                    if (fileObject3 == null) {
                        fileObject3 = FileUtil.createFolder((FileObject)fileObject2, (String)string2);
                    }
                    if ((fileObject = fileObject3.getFileObject(string6 = TemplateIterator.this.templatePanel.getLayoutFileName(), "css")) == null) {
                        fileObject = fileObject3.createData(string6, "css");
                        inputStream = TemplateIterator.this.templatePanel.getLayoutCSS();
                        JSFFrameworkProvider.createFile(fileObject, JSFFrameworkProvider.readResource(inputStream, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
                    }
                    String string3 = JSFUtils.getRelativePath(fileObject22, fileObject);
                    fileObject = fileObject3.getFileObject("default", "css");
                    if (fileObject == null) {
                        fileObject = fileObject3.createData("default", "css");
                        inputStream = TemplateIterator.this.templatePanel.getDefaultCSS();
                        JSFFrameworkProvider.createFile(fileObject, JSFFrameworkProvider.readResource(inputStream, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
                    }
                    String string4 = JSFUtils.getRelativePath(fileObject22, fileObject);
                    inputStream = TemplateIterator.this.templatePanel.getTemplate();
                    String string5 = JSFFrameworkProvider.readResource(inputStream, TemplateIterator.ENCODING);
                    if (!bl) {
                        string5 = string5.replaceAll("h:head", "head").replaceAll("h:body", "body");
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("LAYOUT_CSS_PATH", string3);
                    hashMap.put("DEFAULT_CSS_PATH", string4);
                    MapFormat mapFormat = new MapFormat(hashMap);
                    mapFormat.setLeftBrace("__");
                    mapFormat.setRightBrace("__");
                    mapFormat.setExactMatch(false);
                    string5 = mapFormat.format((Object)string5);
                    JSFFrameworkProvider.createFile(fileObject22, string5, TemplateIterator.ENCODING);
                }
            });
            FileObject fileObject3 = dataFolder.getPrimaryFile().getFileObject(string, XHTML_EXT);
            return Collections.singleton(DataObject.find((FileObject)fileObject3));
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
        SourceGroup[] sourceGroupArray2 = sourceGroupArray.length < 2 ? new SourceGroup[]{sourceGroupArray[0], sourceGroupArray[0]} : sourceGroupArray;
        this.templatePanel = new TemplatePanel((WizardDescriptor)templateWizard);
        WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray2, (WizardDescriptor.Panel)this.templatePanel);
        JComponent jComponent = (JComponent)panel.getComponent();
        Dimension dimension = jComponent.getPreferredSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + 65.0);
        jComponent.setPreferredSize(dimension);
        return new WizardDescriptor.Panel[]{panel};
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }
}

