/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.awt.Dialog;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerUtil;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.EntityClass;
import org.netbeans.modules.web.jsf.palette.items.ManagedBeanCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromEntityBase {
    private static final String ITEM_VAR = "item";
    private boolean readOnly = false;
    private static final String INDENT = "            ";

    protected abstract boolean isCollectionComponent();

    protected abstract boolean showReadOnlyFormFlag();

    protected abstract String getDialogTitle();

    protected abstract String getTemplate();

    protected final boolean isReadOnlyForm() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleTransfer(JTextComponent jTextComponent) {
        Project project = null;
        FileObject fileObject = JSFPaletteUtilities.getFileObject(jTextComponent);
        if (fileObject != null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        if (project == null) {
            return false;
        }
        ManagedBeanCustomizer managedBeanCustomizer = new ManagedBeanCustomizer(project, this.isCollectionComponent(), this.showReadOnlyFormFlag());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)managedBeanCustomizer, this.getDialogTitle(), true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = null;
        try {
            dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            managedBeanCustomizer.setDialog(dialog, dialogDescriptor);
            dialog.setVisible(true);
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
        boolean bl = dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && !managedBeanCustomizer.isCancelled();
        this.readOnly = managedBeanCustomizer.isReadOnly();
        if (bl) {
            try {
                boolean bl2 = FromEntityBase.isInViewTag(jTextComponent);
                String string = managedBeanCustomizer.getManagedBeanProperty();
                if (string != null && string.lastIndexOf(".") != -1) {
                    string = string.substring(0, string.lastIndexOf("."));
                }
                String string2 = this.expandTemplate(jTextComponent, !bl2, FileEncodingQuery.getEncoding((FileObject)fileObject), managedBeanCustomizer.getBeanClass(), string, managedBeanCustomizer.getManagedBeanProperty());
                JSFPaletteUtilities.insert(string2, jTextComponent);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                bl = false;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isInViewTag(JTextComponent jTextComponent) {
        try {
            Caret caret = jTextComponent.getCaret();
            int n = Math.min(caret.getDot(), caret.getMark());
            int n2 = Math.max(caret.getDot(), caret.getMark());
            int n3 = jTextComponent.getDocument().getLength() - n2;
            return jTextComponent.getText(0, n).contains("<f:view>") && jTextComponent.getText(n2, n3).contains("</f:view>");
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return true;
        }
    }

    public void insert(JTextComponent jTextComponent) {
        this.handleTransfer(jTextComponent);
    }

    private String expandTemplate(JTextComponent jTextComponent, boolean bl, Charset charset, String string, String string2, String string3) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("<f:view>\n");
        }
        FileObject fileObject = EntityClass.getFO(jTextComponent);
        Map<String, Object> map = FromEntityBase.createFieldParameters(fileObject, string, string2, string3, this.isCollectionComponent(), false);
        FileObject fileObject2 = FileUtil.getConfigRoot().getFileObject(this.getTemplate());
        StringWriter stringWriter = new StringWriter();
        JSFPaletteUtilities.expandJSFTemplate(fileObject2, map, charset, stringWriter);
        stringBuffer.append(stringWriter.toString());
        if (bl) {
            stringBuffer.append("</f:view>\n");
        }
        return stringBuffer.toString();
    }

    public static Map<String, Object> createFieldParameters(FileObject fileObject, final String string, String string2, final String string3, final boolean bl, final boolean bl2) throws IOException {
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)EntityClass.createClasspathInfo(fileObject), (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                FromEntityBase.enumerateEntityFields(hashMap, compilationController, typeElement, string3, bl, bl2);
            }
        }, true);
        hashMap.put("managedBean", string2);
        hashMap.put("managedBeanProperty", string3);
        String string4 = string;
        if (string4.lastIndexOf(".") != -1) {
            string4 = string4.substring(string.lastIndexOf(".") + 1);
        }
        hashMap.put("entityName", string4);
        return hashMap;
    }

    private static void enumerateEntityFields(Map<String, Object> map, CompilationController compilationController, TypeElement typeElement, String string, boolean bl, boolean bl2) {
        ArrayList<TemplateData> arrayList = new ArrayList<TemplateData>();
        ArrayList<FieldDesc> arrayList2 = new ArrayList<FieldDesc>();
        if (typeElement != null) {
            ExecutableElement[] executableElementArray = JpaControllerUtil.getEntityMethods((TypeElement)typeElement);
            JpaControllerUtil.EmbeddedPkSupport embeddedPkSupport = null;
            for (ExecutableElement executableElement : executableElementArray) {
                FieldDesc fieldDesc = new FieldDesc(compilationController, executableElement, typeElement, bl2);
                if (!fieldDesc.isValid()) continue;
                int n = fieldDesc.getRelationship();
                if (EntityClass.isId(compilationController, executableElement, fieldDesc.isFieldAccess())) {
                    fieldDesc.setPrimaryKey();
                    TypeMirror typeMirror = executableElement.getReturnType();
                    if (TypeKind.DECLARED != typeMirror.getKind()) continue;
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    TypeElement typeElement2 = (TypeElement)declaredType.asElement();
                    if (JpaControllerUtil.isEmbeddableClass((TypeElement)typeElement2)) {
                        if (embeddedPkSupport == null) {
                            embeddedPkSupport = new JpaControllerUtil.EmbeddedPkSupport();
                        }
                        String string2 = fieldDesc.getPropertyName();
                        for (ExecutableElement executableElement2 : embeddedPkSupport.getPkAccessorMethods(compilationController, typeElement)) {
                            if (embeddedPkSupport.isRedundantWithRelationshipField(compilationController, typeElement, executableElement2)) continue;
                            String string3 = executableElement2.getSimpleName().toString();
                            fieldDesc = new FieldDesc(compilationController, executableElement2, typeElement);
                            fieldDesc.setLabel(string3.substring(3));
                            fieldDesc.setPropertyName(string2 + "." + JpaControllerUtil.getPropNameFromMethod((String)string3));
                            arrayList2.add(fieldDesc);
                        }
                        continue;
                    }
                    arrayList2.add(fieldDesc);
                    continue;
                }
                if (fieldDesc.getDateTimeFormat().length() > 0) {
                    arrayList2.add(fieldDesc);
                    continue;
                }
                if (n != 0 && n != 1) continue;
                arrayList2.add(fieldDesc);
            }
        }
        FromEntityBase.processFields(map, arrayList, compilationController, typeElement, arrayList2, string, bl);
        map.put("entityDescriptors", arrayList);
        map.put(ITEM_VAR, ITEM_VAR);
        map.put("comment", Boolean.FALSE);
    }

    private static ExecutableElement findPrimaryKeyGetter(CompilationController compilationController, TypeElement typeElement) {
        ExecutableElement[] executableElementArray;
        for (ExecutableElement executableElement : executableElementArray = JpaControllerUtil.getEntityMethods((TypeElement)typeElement)) {
            FieldDesc fieldDesc = new FieldDesc(compilationController, executableElement, typeElement, false);
            if (!fieldDesc.isValid() || !EntityClass.isId(compilationController, executableElement, fieldDesc.isFieldAccess())) continue;
            return executableElement;
        }
        return null;
    }

    private static void processFields(Map<String, Object> map, List<TemplateData> list, CompilationController compilationController, TypeElement typeElement, List<FieldDesc> list2, String string, boolean bl) {
        for (FieldDesc fieldDesc : list2) {
            list.add(new TemplateData(fieldDesc, (bl ? ITEM_VAR : string) + "."));
        }
    }

    public static void createParamsForConverterTemplate(final Map<String, Object> map, FileObject fileObject, final String string) throws IOException {
        JavaSource javaSource = JavaSource.create((ClasspathInfo)EntityClass.createClasspathInfo(fileObject), (FileObject[])new FileObject[0]);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                FromEntityBase.createParamsForConverterTemplate((Map<String, Object>)map, compilationController, typeElement);
            }
        }, true);
    }

    private static void createParamsForConverterTemplate(Map<String, Object> map, CompilationController compilationController, TypeElement typeElement) throws IOException {
        ExecutableElement executableElement = FromEntityBase.findPrimaryKeyGetter(compilationController, typeElement);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (executableElement != null) {
            String string;
            TypeMirror typeMirror = executableElement.getReturnType();
            if (TypeKind.DECLARED == typeMirror.getKind()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement typeElement2 = (TypeElement)declaredType.asElement();
                boolean bl = typeElement2 != null && JpaControllerUtil.isEmbeddableClass((TypeElement)typeElement2);
                String string2 = typeElement2.getSimpleName().toString();
                string = typeElement2.getQualifiedName().toString();
                if (bl) {
                    map.put("keyEmbedded", Boolean.TRUE);
                    int n = 0;
                    for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                        if (!executableElement2.getSimpleName().toString().startsWith("set")) continue;
                        FromEntityBase.addParam(stringBuffer, stringBuffer2, executableElement2.getSimpleName().toString(), n, string2, string, executableElement2.getParameters().get(0).asType());
                        ++n;
                    }
                    if (n == 0) {
                        stringBuffer.append(NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_SETTERS", (Object[])new String[]{INDENT, string, "Converter.getKey()"}));
                        stringBuffer2.append(NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_SETTERS", (Object[])new String[]{INDENT, string, "Converter.getKey()"}));
                    }
                } else {
                    map.put("keyEmbedded", Boolean.FALSE);
                    FromEntityBase.addParam(stringBuffer, stringBuffer2, null, -1, string2, string, typeMirror);
                }
            } else {
                String string3;
                map.put("keyEmbedded", Boolean.FALSE);
                string = string3 = ((Object)typeMirror).toString();
                FromEntityBase.addParam(stringBuffer, stringBuffer2, null, -1, string3, string, typeMirror);
            }
            map.put("keyType", string);
            if (stringBuffer.toString().endsWith("\n")) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            map.put("keyBody", stringBuffer.toString());
            if (stringBuffer2.toString().endsWith("\n")) {
                stringBuffer2.setLength(stringBuffer2.length() - 1);
            }
            map.put("keyStringBody", stringBuffer2.toString());
            map.put("keyGetter", executableElement.getSimpleName().toString());
        } else {
            map.put("keyBody", NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_GETTERS", (Object[])new String[]{INDENT, typeElement.getQualifiedName().toString(), "Converter.getKey()"}));
            map.put("keyStringBody", NbBundle.getMessage(FromEntityBase.class, (String)"ERR_NO_GETTERS", (Object[])new String[]{INDENT, typeElement.getQualifiedName().toString(), "Converter.getKey()"}));
            map.put("keyGetter", "UNDEFINED");
            map.put("keyType", "UNDEFINED");
            map.put("keyEmbedded", Boolean.FALSE);
        }
    }

    private static void addParam(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string, int n, String string2, String string3, TypeMirror typeMirror) {
        if (n == 0) {
            stringBuffer.append("            String values[] = value.split(SEPARATOR_ESCAPED);\n");
            stringBuffer.append("            key = new " + string3 + "();\n");
        }
        if (n > 0) {
            stringBuffer2.append("            sb.append(SEPARATOR);\n");
        }
        String string4 = FromEntityBase.getConversionFromString(typeMirror, n, string2);
        if (string != null) {
            stringBuffer.append("            key." + string + "(" + string4 + ");\n");
            stringBuffer2.append("            sb.append(value.g" + string.substring(1) + "());\n");
        } else {
            stringBuffer.append("            key = " + string4 + ";\n");
            stringBuffer2.append("            sb.append(value);\n");
        }
    }

    private static String getConversionFromString(TypeMirror typeMirror, int n, String string) {
        String string2;
        String string3 = string2 = n == -1 ? "value" : "values[" + n + "]";
        if (TypeKind.BOOLEAN == typeMirror.getKind()) {
            return "Boolean.parseBoolean(" + string2 + ")";
        }
        if (TypeKind.BYTE == typeMirror.getKind()) {
            return "Byte.parseByte(" + string2 + ")";
        }
        if (TypeKind.CHAR == typeMirror.getKind()) {
            return string2 + ".charAt(0)";
        }
        if (TypeKind.DOUBLE == typeMirror.getKind()) {
            return "Double.parseDouble(" + string2 + ")";
        }
        if (TypeKind.FLOAT == typeMirror.getKind()) {
            return "Float.parseFloat(" + string2 + ")";
        }
        if (TypeKind.INT == typeMirror.getKind()) {
            return "Integer.parseInt(" + string2 + ")";
        }
        if (TypeKind.LONG == typeMirror.getKind()) {
            return "Long.parseLong(" + string2 + ")";
        }
        if (TypeKind.SHORT == typeMirror.getKind()) {
            return "Short.parseShort(" + string2 + ")";
        }
        if (TypeKind.DECLARED == typeMirror.getKind()) {
            if ("Boolean".equals(((Object)typeMirror).toString()) || "java.lang.Boolean".equals(((Object)typeMirror).toString())) {
                return "Boolean.valueOf(" + string2 + ")";
            }
            if ("Byte".equals(((Object)typeMirror).toString()) || "java.lang.Byte".equals(((Object)typeMirror).toString())) {
                return "Byte.valueOf(" + string2 + ")";
            }
            if ("Character".equals(((Object)typeMirror).toString()) || "java.lang.Character".equals(((Object)typeMirror).toString())) {
                return "new Character(" + string2 + ".charAt(0))";
            }
            if ("Double".equals(((Object)typeMirror).toString()) || "java.lang.Double".equals(((Object)typeMirror).toString())) {
                return "Double.valueOf(" + string2 + ")";
            }
            if ("Float".equals(((Object)typeMirror).toString()) || "java.lang.Float".equals(((Object)typeMirror).toString())) {
                return "Float.valueOf(" + string2 + ")";
            }
            if ("Integer".equals(((Object)typeMirror).toString()) || "java.lang.Integer".equals(((Object)typeMirror).toString())) {
                return "Integer.valueOf(" + string2 + ")";
            }
            if ("Long".equals(((Object)typeMirror).toString()) || "java.lang.Long".equals(((Object)typeMirror).toString())) {
                return "Long.valueOf(" + string2 + ")";
            }
            if ("Short".equals(((Object)typeMirror).toString()) || "java.lang.Short".equals(((Object)typeMirror).toString())) {
                return "Short.valueOf(" + string2 + ")";
            }
        }
        return string2;
    }

    public static final class TemplateData {
        private FieldDesc fd;
        private String prefix;

        private TemplateData(FieldDesc fieldDesc, String string) {
            this.fd = fieldDesc;
            this.prefix = string;
        }

        public String getLabel() {
            return this.fd.getLabel();
        }

        public String getName() {
            return this.prefix + this.fd.getPropertyName();
        }

        public String getDateTimeFormat() {
            return this.fd.getDateTimeFormat();
        }

        public boolean isBlob() {
            return this.fd.isBlob();
        }

        public boolean isRelationshipOne() {
            return this.fd.getRelationship() == 1;
        }

        public boolean isRelationshipMany() {
            return this.fd.getRelationship() == 2;
        }

        public String getId() {
            return this.fd.getPropertyName();
        }

        public boolean isRequired() {
            return this.fd.isRequired();
        }

        public String getValuesGetter() {
            return this.fd.getValuesGetter();
        }

        public String toString() {
            return "TemplateData[fd=" + this.fd + ",prefix=" + this.prefix + "]";
        }
    }

    public static final class FieldDesc {
        private ExecutableElement method;
        private String methodName;
        private String propertyName;
        private String label;
        private Boolean fieldAccess = null;
        private Integer relationship = null;
        private TypeElement bean;
        private CompilationController controller;
        private String dateTimeFormat = null;
        private String valuesGetter = "fixme";
        private boolean primaryKey;

        private FieldDesc(CompilationController compilationController, ExecutableElement executableElement, TypeElement typeElement, boolean bl) {
            this(compilationController, executableElement, typeElement);
            if (bl) {
                this.valuesGetter = null;
            }
        }

        private FieldDesc(CompilationController compilationController, ExecutableElement executableElement, TypeElement typeElement) {
            this.controller = compilationController;
            this.method = executableElement;
            this.bean = typeElement;
            this.methodName = executableElement.getSimpleName().toString();
            this.label = this.methodName.substring(3);
            this.propertyName = JpaControllerUtil.getPropNameFromMethod((String)this.getMethodName());
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey() {
            this.primaryKey = true;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String string) {
            this.propertyName = string;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        private boolean isFieldAccess() {
            if (this.fieldAccess == null) {
                this.fieldAccess = JpaControllerUtil.isFieldAccess((TypeElement)this.bean);
            }
            return this.fieldAccess;
        }

        public boolean isValid() {
            return this.getMethodName().startsWith("get");
        }

        public int getRelationship() {
            if (this.relationship == null) {
                this.relationship = JpaControllerUtil.isRelationship((CompilationController)this.controller, (ExecutableElement)this.method, (boolean)this.isFieldAccess());
            }
            return this.relationship;
        }

        public String getDateTimeFormat() {
            if (this.dateTimeFormat == null) {
                String string;
                this.dateTimeFormat = "";
                TypeMirror typeMirror = this.controller.getElements().getTypeElement("java.util.Date").asType();
                if (this.controller.getTypes().isSameType(typeMirror, this.method.getReturnType()) && (string = EntityClass.getTemporal(this.controller, this.method, this.isFieldAccess())) != null) {
                    this.dateTimeFormat = EntityClass.getDateTimeFormat(string);
                }
            }
            return this.dateTimeFormat;
        }

        private boolean isBlob() {
            ExecutableElement executableElement;
            Element element = executableElement = this.isFieldAccess() ? JpaControllerUtil.guessField((CompilationController)this.controller, (ExecutableElement)this.method) : this.method;
            if (executableElement == null) {
                executableElement = this.method;
            }
            return JpaControllerUtil.isAnnotatedWith((Element)executableElement, (String)"javax.persistence.Lob");
        }

        public String toString() {
            return "Field[methodName=" + this.getMethodName() + ",propertyName=" + this.getPropertyName() + ",label=" + this.label + ",valid=" + this.isValid() + ",field=" + this.isFieldAccess() + ",relationship=" + this.getRelationship() + ",datetime=" + this.getDateTimeFormat() + ",valuesGetter=" + this.getValuesGetter() + "]";
        }

        private String getRelationClassName(CompilationController compilationController, ExecutableElement executableElement, boolean bl) {
            TypeMirror typeMirror = executableElement.getReturnType();
            if (TypeKind.DECLARED != typeMirror.getKind() || !(typeMirror instanceof DeclaredType)) {
                return null;
            }
            Types types = compilationController.getTypes();
            TypeMirror typeMirror2 = JpaControllerUtil.stripCollection((TypeMirror)((DeclaredType)typeMirror), (Types)types);
            if (typeMirror2 == null) {
                return null;
            }
            TypeElement typeElement = (TypeElement)types.asElement(typeMirror2);
            return typeElement.getSimpleName().toString();
        }

        public String getValuesGetter() {
            if (this.getRelationship() == 0) {
                return null;
            }
            if (this.valuesGetter == null) {
                String string = this.getRelationClassName(this.controller, this.method, this.isFieldAccess());
                if (string == null) {
                    this.valuesGetter = "";
                } else {
                    string = string.substring(0, 1).toLowerCase() + string.substring(1);
                    this.valuesGetter = string + "Controller." + (this.getRelationship() == 1 ? "itemsAvailableSelectOne" : "itemsAvailableSelectMany");
                }
            }
            return this.valuesGetter;
        }

        private boolean isRequired() {
            return !JpaControllerUtil.isFieldOptionalAndNullable((CompilationController)this.controller, (ExecutableElement)this.method, (boolean)this.isFieldAccess());
        }
    }
}

