/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.swing.plaf.AllLFCustoms;
import org.netbeans.swing.plaf.LFCustoms;
import org.netbeans.swing.plaf.aqua.AquaLFCustoms;
import org.netbeans.swing.plaf.gtk.GtkLFCustoms;
import org.netbeans.swing.plaf.metal.MetalLFCustoms;
import org.netbeans.swing.plaf.nimbus.NimbusLFCustoms;
import org.netbeans.swing.plaf.util.NbTheme;
import org.netbeans.swing.plaf.util.RelativeColor;
import org.netbeans.swing.plaf.util.UIBootstrapValue;
import org.netbeans.swing.plaf.util.UIUtils;
import org.netbeans.swing.plaf.winclassic.WindowsLFCustoms;
import org.netbeans.swing.plaf.winvista.VistaLFCustoms;
import org.netbeans.swing.plaf.winxp.XPLFCustoms;

public final class Startup {
    private static final String FORCED_CUSTOMS = System.getProperty("nb.forceui");
    private static final boolean NO_CUSTOMIZATIONS = Boolean.getBoolean("netbeans.plaf.disable.ui.customizations");
    private static final String NIMBUS = "Nimbus";
    private static Startup instance = null;
    private LFCustoms curCustoms = null;
    private LFCustoms globalCustoms = null;
    private static URL themeURL = null;
    private static Class uiClass = null;
    private boolean installed = false;
    private LFListener listener = null;

    private Startup() {
        this.initialize();
    }

    private void initialize() {
        LookAndFeel lookAndFeel = this.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            this.installTheme(lookAndFeel);
        }
        try {
            if (lookAndFeel != UIManager.getLookAndFeel()) {
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not install look and feel " + lookAndFeel);
        }
    }

    private LookAndFeel getLookAndFeel() {
        Object object;
        Object object2;
        if (uiClass != null && uiClass.getName().contains(NIMBUS)) {
            Logger.getLogger(this.getClass().getName()).warning("L&F Warning: Nimbus L&F is not supported L&F yet and system may exhibit various drawing problems. Please use for experimental purposes only.");
        }
        if (uiClass == null) {
            if (this.isWindows()) {
                object2 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (this.isMac()) {
                object2 = "apple.laf.AquaLookAndFeel";
            } else if (this.shouldUseMetal()) {
                object2 = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else {
                object2 = UIManager.getSystemLookAndFeelClassName();
                object = System.getProperty("java.version");
                if ("1.6.0_01".compareTo((String)object) > 0 && System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").indexOf("OpenJDK") < 0) {
                    if (((String)object2).indexOf("gtk") >= 0 && !Boolean.getBoolean("useGtk")) {
                        object2 = "javax.swing.plaf.metal.MetalLookAndFeel";
                    }
                } else if (((String)object2).indexOf("gtk") >= 0 && System.getProperty("useGtk") != null && !Boolean.getBoolean("useGtk")) {
                    object2 = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
                if (((String)object2).contains(NIMBUS)) {
                    object2 = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
            }
            try {
                uiClass = Class.forName((String)object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Custom UI class " + (String)object2 + " not on classpath.");
                try {
                    uiClass = Class.forName("javax.swing.plaf.metal.MetalLookAndFeel");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                System.err.println("While loading: " + (String)object2);
                exception.printStackTrace();
            }
        }
        object2 = null;
        if (uiClass != null) {
            try {
                object = UIManager.getLookAndFeel();
                object2 = uiClass != object.getClass() ? (LookAndFeel)uiClass.newInstance() : UIManager.getLookAndFeel();
            }
            catch (Exception exception) {
                System.err.println("Cannot load custom UI class " + uiClass);
                exception.printStackTrace();
                object2 = UIManager.getLookAndFeel();
            }
        }
        return object2;
    }

    private void installTheme(LookAndFeel lookAndFeel) {
        if (themeURL != null) {
            NbTheme nbTheme = new NbTheme(themeURL, lookAndFeel);
            MetalLookAndFeel.setCurrentTheme(nbTheme);
        }
    }

    private void install() {
        if (this.installed) {
            return;
        }
        if (this.globalCustoms == null) {
            this.globalCustoms = new AllLFCustoms();
            this.installLFCustoms(this.globalCustoms);
        }
        this.installPerLFDefaults();
        this.installTheme(UIManager.getLookAndFeel());
        this.attachListener();
    }

    private void installPerLFDefaults() {
        boolean bl = this.curCustoms != null;
        this.curCustoms = this.findCustoms();
        if (this.curCustoms != null) {
            Integer n = (Integer)UIManager.get("customFontSize");
            if (n == null && UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class) {
                n = new Integer(11);
            }
            if (n != null && !UIUtils.isGtkLF()) {
                AllLFCustoms.initCustomFontSize(n);
            }
            this.installLFCustoms(this.curCustoms);
            if (bl) {
                this.loadAllLazyValues(this.curCustoms);
            }
            this.curCustoms.disposeValues();
        }
    }

    private void loadAllLazyValues(LFCustoms lFCustoms) {
        if (this.globalCustoms != null) {
            this.loadLazy(this.globalCustoms.getApplicationSpecificKeysAndValues());
            this.loadLazy(this.globalCustoms.getGuaranteedKeysAndValues());
            this.loadLazy(this.globalCustoms.getLookAndFeelCustomizationKeysAndValues());
        }
        this.loadLazy(lFCustoms.getApplicationSpecificKeysAndValues());
        this.loadLazy(lFCustoms.getGuaranteedKeysAndValues());
        this.loadLazy(lFCustoms.getLookAndFeelCustomizationKeysAndValues());
    }

    private void loadLazy(Object[] objectArray) {
        if (objectArray.length > 0) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            for (int i = 1; i < objectArray.length; i += 2) {
                if (objectArray[i] instanceof UIBootstrapValue.Lazy) {
                    ((UIBootstrapValue.Lazy)objectArray[i]).createValue(uIDefaults);
                }
                if (!(objectArray[i] instanceof RelativeColor)) continue;
                ((RelativeColor)objectArray[i]).clear();
            }
        }
    }

    private void uninstallPerLFDefaults() {
        assert (this.globalCustoms != null);
        if (this.curCustoms != null) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(this.globalCustoms.allKeys()));
            Object[] objectArray = this.curCustoms.allKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (hashSet.contains(object)) continue;
                UIManager.put(object, null);
            }
        }
    }

    private void attachListener() {
        assert (this.listener == null);
        this.listener = new LFListener();
        UIManager.addPropertyChangeListener(this.listener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", this.listener);
    }

    private void installLFCustoms(LFCustoms lFCustoms) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put("ClassLoader", new CLValue());
        uIDefaults.putDefaults(lFCustoms.getGuaranteedKeysAndValues());
        uIDefaults.putDefaults(lFCustoms.getApplicationSpecificKeysAndValues());
        if (!NO_CUSTOMIZATIONS) {
            uIDefaults.putDefaults(lFCustoms.getLookAndFeelCustomizationKeysAndValues());
        }
    }

    private LFCustoms findCustoms() {
        if (FORCED_CUSTOMS != null) {
            System.err.println("Using explicitly set UI customizations: " + FORCED_CUSTOMS);
            if ("Vista".equals(FORCED_CUSTOMS)) {
                return new VistaLFCustoms();
            }
            if ("XP".equals(FORCED_CUSTOMS)) {
                return new XPLFCustoms();
            }
            if ("Aqua".equals(FORCED_CUSTOMS)) {
                return new AquaLFCustoms();
            }
            if ("Metal".equals(FORCED_CUSTOMS)) {
                return new MetalLFCustoms();
            }
            if ("Windows".equals(FORCED_CUSTOMS)) {
                return new WindowsLFCustoms();
            }
            if ("GTK".equals(FORCED_CUSTOMS)) {
                return new GtkLFCustoms();
            }
            try {
                return (LFCustoms)Class.forName(FORCED_CUSTOMS).newInstance();
            }
            catch (Exception exception) {
                System.err.println("UI customizations class not found: " + FORCED_CUSTOMS);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("Nb.");
        stringBuffer.append(UIManager.getLookAndFeel().getID());
        if (UIUtils.isXPLF()) {
            if (this.isWindowsVista() || this.isWindows7()) {
                stringBuffer.append("VistaLFCustoms");
            } else {
                stringBuffer.append("XPLFCustoms");
            }
        } else {
            stringBuffer.append("LFCustoms");
        }
        LFCustoms lFCustoms = null;
        try {
            lFCustoms = (LFCustoms)UIManager.get(stringBuffer.toString());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (lFCustoms == null) {
            String[] stringArray = new String[]{"Metal", "Windows", "Aqua", "GTK", NIMBUS};
            switch (Arrays.asList(stringArray).indexOf(UIManager.getLookAndFeel().getID())) {
                case 1: {
                    if (UIUtils.isXPLF()) {
                        if (this.isWindowsVista() || this.isWindows7()) {
                            lFCustoms = new VistaLFCustoms();
                            break;
                        }
                        lFCustoms = new XPLFCustoms();
                        break;
                    }
                    lFCustoms = new WindowsLFCustoms();
                    break;
                }
                case 0: {
                    lFCustoms = new MetalLFCustoms();
                    break;
                }
                case 2: {
                    lFCustoms = new AquaLFCustoms();
                    break;
                }
                case 3: {
                    lFCustoms = new GtkLFCustoms();
                    break;
                }
                case 4: {
                    lFCustoms = new NimbusLFCustoms();
                    break;
                }
                default: {
                    if (UIUtils.isXPLF()) {
                        if (this.isWindowsVista() || this.isWindows7()) {
                            lFCustoms = new VistaLFCustoms();
                            break;
                        }
                        lFCustoms = new XPLFCustoms();
                        break;
                    }
                    lFCustoms = new WindowsLFCustoms();
                }
            }
        }
        return lFCustoms;
    }

    public static void run(Class clazz, int n, URL uRL) {
        if (instance == null) {
            if (n > 0) {
                Integer n2 = new Integer(n);
                UIManager.put("customFontSize", n2);
            }
            uiClass = clazz;
            themeURL = uRL;
            instance = new Startup();
            instance.install();
        }
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    private boolean isWindowsVista() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindows7() {
        String string = System.getProperty("os.name");
        return string.indexOf("Windows 7") >= 0 || string.equals("Windows NT (unknown)") && "6.1".equals(System.getProperty("os.version"));
    }

    private boolean isMac() {
        String string = System.getProperty("os.name");
        boolean bl = string.startsWith("Darwin") || "Mac OS X".equals(string);
        return bl;
    }

    private boolean isSolaris10() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        boolean bl = string.startsWith("SunOS") && "5.10".equals(string2);
        return bl;
    }

    private boolean shouldUseMetal() {
        String string = System.getProperty("os.name");
        boolean bl = !"Solaris".equals(string) && !string.startsWith("SunOS") && !string.endsWith("Linux") || UIManager.getSystemLookAndFeelClassName().indexOf("Motif") > -1 || this.isSolaris10();
        return bl;
    }

    private class LFListener
    implements PropertyChangeListener {
        private LFListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName()) || "win.xpstyle.themeActive".equals(propertyChangeEvent.getPropertyName())) {
                Startup.this.uninstallPerLFDefaults();
                Startup.this.installPerLFDefaults();
            }
        }
    }

    private static final class CLValue
    implements UIDefaults.ActiveValue {
        private CLValue() {
        }

        public Object createValue(UIDefaults uIDefaults) {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

