/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RspecHandlerFactory
implements TestHandlerFactory {
    @Override
    public boolean printSummary() {
        return false;
    }

    @Override
    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> arrayList = new ArrayList<TestRecognizerHandler>();
        arrayList.add(new SuiteStartingHandler());
        arrayList.add(new SuiteStartedHandler());
        arrayList.add(new SuiteFinishedHandler());
        arrayList.add(new TestStartedHandler());
        arrayList.add(new TestFailedHandler());
        arrayList.add(new TestPendingHandler());
        arrayList.add(new TestFinishedHandler());
        arrayList.add(new StackTraceFilterHandler());
        return arrayList;
    }

    static class StackTraceFilterHandler
    extends TestRecognizerHandler {
        public StackTraceFilterHandler() {
            super(".*nb_rspec_mediator.rb.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super(".*%RSPEC_SUITE_STARTING%\\s(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(testSession);
            }
            String string = this.matcher.group(1);
            testSession.addSuite(new TestSuite(string));
            manager.displaySuiteRunning(testSession, string);
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super(".*%RSPEC_SUITE_STARTED%\\s.*");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super(".*%RSPEC_SUITE_FINISHED%\\s(.+)\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            manager.displayReport(testSession, testSession.getReport((long)SuiteFinishedHandler.toMillis(this.matcher.group(2))));
        }
    }

    static class TestPendingHandler
    extends TestRecognizerHandler {
        public TestPendingHandler() {
            super(".*%RSPEC_TEST_PENDING%\\sfile=(.*)\\sdescription=(.*)\\stime=(.+)\\smessage=(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), testSession);
            testcase.setTimeMillis((long)TestPendingHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(testSession.getCurrentSuite().getName());
            String string = this.matcher.group(1);
            if (string != null && !"".equals(string)) {
                testcase.setLocation(this.matcher.group(1));
            }
            testcase.setTrouble(new Trouble(false));
            testcase.getTrouble().setStackTrace(new String[]{this.matcher.group(4)});
            testcase.setStatus(Status.PENDING);
            testSession.addTestCase(testcase);
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler() {
            super(".*%RSPEC_TEST_FINISHED%\\sfile=(.*)\\sdescription=(.*)\\stime=(.+)");
        }

        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), testSession);
            testcase.setTimeMillis((long)TestFinishedHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(testSession.getCurrentSuite().getName());
            String string = this.matcher.group(1);
            if (string != null && !"".equals(string)) {
                testcase.setLocation(this.matcher.group(1));
            }
            testSession.addTestCase(testcase);
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super(".*%RSPEC_TEST_STARTED%\\s(.*)");
        }

        void updateUI(Manager manager, TestSession testSession) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestFailedHandler
    extends TestRecognizerHandler {
        public TestFailedHandler() {
            super(".*%RSPEC_TEST_FAILED%\\sfile=(.*)\\sdescription=(.*)\\stime=(\\d+\\.\\d+)\\smessage=(.*)\\slocation=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession testSession) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.RSPEC.name(), testSession);
            String string = this.matcher.group(1);
            String string2 = this.matcher.group(5);
            if (!TestFailedHandler.isEmpty(string)) {
                testcase.setLocation(string);
            } else if (!TestFailedHandler.isEmpty(string2)) {
                testcase.setLocation(string2);
            }
            testcase.setTimeMillis((long)TestFailedHandler.toMillis(this.matcher.group(3)));
            testcase.setClassName(this.matcher.group(2));
            testcase.setTrouble(new Trouble(false));
            testcase.getTrouble().setComparisonFailure(TestFailedHandler.getComparisonFailure(this.matcher.group(4)));
            testcase.getTrouble().setStackTrace(this.filterStackTrace(this.matcher.group(4), this.matcher.group(5)));
            testSession.addTestCase(testcase);
            for (String string3 : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(testSession, string3, false);
            }
            testcase.addOutputLines(this.getRecognizedOutput());
        }

        @Override
        List<String> getRecognizedOutput() {
            ArrayList<String> arrayList = new ArrayList<String>(2);
            arrayList.add(this.matcher.group(3));
            arrayList.add(this.matcher.group(4));
            return arrayList;
        }

        private String[] filterStackTrace(String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                if (TestRunnerUtilities.filterOutFromStacktrace(string)) continue;
                arrayList.add(string);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

