/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.DeclaredType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Attribute
implements AnnotationValue {
    public Type type;

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
        throw new UnsupportedOperationException();
    }

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitError(this);
        }

        @Override
        public String toString() {
            return "<error>";
        }

        @Override
        public String getValue() {
            return this.toString();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitString(this.toString(), p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol varSymbol) {
            super(type);
            assert (varSymbol != null);
            this.value = varSymbol;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitEnum(this);
        }

        @Override
        public String toString() {
            return this.value.enclClass() + "." + this.value;
        }

        @Override
        public Symbol.VarSymbol getValue() {
            return this.value;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitEnumConstant(this.value, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] attributeArray) {
            super(type);
            this.values = attributeArray;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArray(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            boolean bl = true;
            for (Attribute attribute : this.values) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(attribute);
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public List<Attribute> getValue() {
            return List.from(this.values);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitArray((java.util.List<AnnotationValue>)this.getValue(), p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compound
    extends Attribute
    implements AnnotationMirror {
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCompound(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@");
            stringBuilder.append(this.type);
            int n = this.values.length();
            if (n > 0) {
                stringBuilder.append('(');
                boolean bl = true;
                for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    bl = false;
                    Name name = ((Symbol.MethodSymbol)pair.fst).name;
                    if (n > 1 || name != name.table.value) {
                        stringBuilder.append(name);
                        stringBuilder.append('=');
                    }
                    stringBuilder.append(pair.snd);
                }
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }

        public Attribute member(Name name) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != name) continue;
                return (Attribute)pair.snd;
            }
            return null;
        }

        @Override
        public Compound getValue() {
            return this;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitAnnotation(this, p);
        }

        @Override
        public DeclaredType getAnnotationType() {
            return (DeclaredType)((Object)this.type);
        }

        public Map<Symbol.MethodSymbol, Attribute> getElementValues() {
            LinkedHashMap<Symbol.MethodSymbol, Attribute> linkedHashMap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                linkedHashMap.put((Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
            }
            return linkedHashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Class
    extends Attribute {
        public final Type type;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.type = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type type2 = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.getEnclosingType(), List.of(type2), types.syms.classType.tsym);
        }

        @Override
        public String toString() {
            return this.type + ".class";
        }

        @Override
        public Type getValue() {
            return this.type;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitType(this.type, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constant
    extends Attribute {
        public final Object value;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }

        public Constant(Type type, Object object) {
            super(type);
            this.value = object;
        }

        @Override
        public String toString() {
            return Constants.format(this.value, this.type);
        }

        @Override
        public Object getValue() {
            return Constants.decode(this.value, this.type);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            if (this.value instanceof String) {
                return annotationValueVisitor.visitString((String)this.value, p);
            }
            if (this.value instanceof Integer) {
                int n = (Integer)this.value;
                switch (this.type.tag) {
                    case 8: {
                        return annotationValueVisitor.visitBoolean(n != 0, p);
                    }
                    case 2: {
                        return annotationValueVisitor.visitChar((char)n, p);
                    }
                    case 1: {
                        return annotationValueVisitor.visitByte((byte)n, p);
                    }
                    case 3: {
                        return annotationValueVisitor.visitShort((short)n, p);
                    }
                    case 4: {
                        return annotationValueVisitor.visitInt(n, p);
                    }
                }
            }
            switch (this.type.tag) {
                case 5: {
                    return annotationValueVisitor.visitLong((Long)this.value, p);
                }
                case 6: {
                    return annotationValueVisitor.visitFloat(((Float)this.value).floatValue(), p);
                }
                case 7: {
                    return annotationValueVisitor.visitDouble((Double)this.value, p);
                }
            }
            throw new AssertionError((Object)("Bad annotation element value: " + this.value));
        }
    }
}

